/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors;

import java.util.List;
import se.fishtank.css.selectors.Specifier;
import se.fishtank.css.util.Assert;

public class Selector {
    public static final String UNIVERSAL_TAG = "*";
    private final String tagName;
    private final Combinator combinator;
    private final List<Specifier> specifiers;

    public Selector() {
        this.tagName = UNIVERSAL_TAG;
        this.combinator = Combinator.DESCENDANT;
        this.specifiers = null;
    }

    public Selector(String tagName, Combinator combinator) {
        Assert.notNull(tagName, "tagName is null!");
        Assert.notNull((Object)combinator, "combinator is null!");
        this.tagName = tagName;
        this.combinator = combinator;
        this.specifiers = null;
    }

    public Selector(String tagName, List<Specifier> specifiers) {
        Assert.notNull(tagName, "tagName is null!");
        this.tagName = tagName;
        this.combinator = Combinator.DESCENDANT;
        this.specifiers = specifiers;
    }

    public Selector(String tagName, Combinator combinator, List<Specifier> specifiers) {
        Assert.notNull(tagName, "tagName is null!");
        Assert.notNull((Object)combinator, "combinator is null!");
        this.tagName = tagName;
        this.combinator = combinator;
        this.specifiers = specifiers;
    }

    public String getTagName() {
        return this.tagName;
    }

    public Combinator getCombinator() {
        return this.combinator;
    }

    public List<Specifier> getSpecifiers() {
        return this.specifiers;
    }

    public boolean hasSpecifiers() {
        return this.specifiers != null && !this.specifiers.isEmpty();
    }

    public static enum Combinator {
        DESCENDANT,
        CHILD,
        ADJACENT_SIBLING,
        GENERAL_SIBLING;

    }
}

