/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.tools.SimpleResultSet;
import org.h2.value.Value;

public class JdbcArray
extends TraceObject
implements Array {
    private Value value;
    private final JdbcConnection conn;

    public JdbcArray(JdbcConnection jdbcConnection, Value value, int n) {
        this.setTrace(jdbcConnection.getSession().getTrace(), 16, n);
        this.conn = jdbcConnection;
        this.value = value;
    }

    @Override
    public Object getArray() throws SQLException {
        try {
            this.debugCodeCall("getArray");
            this.checkClosed();
            return this.get();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getArray(" + JdbcArray.quoteMap(map) + ");");
            }
            JdbcConnection.checkMap(map);
            this.checkClosed();
            return this.get();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Object getArray(long l, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getArray(" + l + ", " + n + ");");
            }
            this.checkClosed();
            return this.get(l, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Object getArray(long l, int n, Map<String, Class<?>> map) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getArray(" + l + ", " + n + ", " + JdbcArray.quoteMap(map) + ");");
            }
            this.checkClosed();
            JdbcConnection.checkMap(map);
            return this.get(l, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getBaseType() throws SQLException {
        try {
            this.debugCodeCall("getBaseType");
            this.checkClosed();
            return 0;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        try {
            this.debugCodeCall("getBaseTypeName");
            this.checkClosed();
            return "NULL";
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            this.debugCodeCall("getResultSet");
            this.checkClosed();
            return JdbcArray.getResultSet(this.get(), 0L);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getResultSet(" + JdbcArray.quoteMap(map) + ");");
            }
            this.checkClosed();
            JdbcConnection.checkMap(map);
            return JdbcArray.getResultSet(this.get(), 0L);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getResultSet(long l, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getResultSet(" + l + ", " + n + ");");
            }
            this.checkClosed();
            return JdbcArray.getResultSet(this.get(l, n), l - 1L);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getResultSet(long l, int n, Map<String, Class<?>> map) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getResultSet(" + l + ", " + n + ", " + JdbcArray.quoteMap(map) + ");");
            }
            this.checkClosed();
            JdbcConnection.checkMap(map);
            return JdbcArray.getResultSet(this.get(l, n), l - 1L);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void free() {
        this.debugCodeCall("free");
        this.value = null;
    }

    private static ResultSet getResultSet(Object[] objectArray, long l) {
        SimpleResultSet simpleResultSet = new SimpleResultSet();
        simpleResultSet.addColumn("INDEX", -5, 0, 0);
        simpleResultSet.addColumn("VALUE", 0, 0, 0);
        for (int i = 0; i < objectArray.length; ++i) {
            simpleResultSet.addRow(l + (long)i + 1L, objectArray[i]);
        }
        return simpleResultSet;
    }

    private void checkClosed() {
        this.conn.checkClosed();
        if (this.value == null) {
            throw DbException.get(90007);
        }
    }

    private Object[] get() {
        return (Object[])this.value.convertTo(17).getObject();
    }

    private Object[] get(long l, int n) {
        Object[] objectArray = this.get();
        if (n < 0 || n > objectArray.length) {
            throw DbException.getInvalidValueException("count (1.." + objectArray.length + ")", n);
        }
        if (l < 1L || l > (long)objectArray.length) {
            throw DbException.getInvalidValueException("index (1.." + objectArray.length + ")", l);
        }
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, (int)(l - 1L), objectArray2, 0, n);
        return objectArray2;
    }

    public String toString() {
        return this.value == null ? "null" : this.getTraceObjectName() + ": " + this.value.getTraceSQL();
    }
}

