/*
 * Decompiled with CFR 0.152.
 */
package com.BoxOfC.LevenshteinAutomaton;

import java.util.BitSet;

public class AugBitSet
extends BitSet {
    private int relevantBitSetSize = 0;

    public AugBitSet() {
    }

    public AugBitSet(int relevantBitSetSize) {
        super(relevantBitSetSize);
        this.relevantBitSetSize = relevantBitSetSize;
    }

    private AugBitSet(BitSet bs) {
        super.xor(bs);
    }

    @Override
    public AugBitSet get(int fromIndex, int toIndex) {
        return new AugBitSet(super.get(fromIndex, toIndex));
    }

    @Override
    public void set(int bitIndex) {
        this.relevantBitSetSize = Math.max(this.relevantBitSetSize, bitIndex);
        super.set(bitIndex);
    }

    @Override
    public void set(int bitIndex, boolean value) {
        this.relevantBitSetSize = Math.max(this.relevantBitSetSize, bitIndex);
        super.set(bitIndex, value);
    }

    public int getRelevantBitSetSize() {
        return this.relevantBitSetSize;
    }

    @Override
    public boolean equals(Object obj) {
        boolean areEqual;
        boolean bl = areEqual = this == obj;
        if (!areEqual && obj != null && obj.getClass().equals(AugBitSet.class)) {
            AugBitSet abs = (AugBitSet)obj;
            if (this.relevantBitSetSize == abs.relevantBitSetSize) {
                int i;
                for (i = 0; i < this.relevantBitSetSize && this.get(i) == abs.get(i); ++i) {
                }
                areEqual = i == this.relevantBitSetSize;
            }
        }
        return areEqual;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        for (int i = 0; i < this.relevantBitSetSize; ++i) {
            hash = 83 * hash + (super.get(i) ? 1231 : 1237) + (i + 53);
        }
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder strBuilder = new StringBuilder("{");
        for (int i = 0; i < this.relevantBitSetSize; ++i) {
            strBuilder.append(super.get(i) ? "1" : "0");
        }
        return strBuilder.append("}").toString();
    }
}

