/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.coremodel.InfoMessage;

public enum DatasetCodes implements InfoMessage.MessageCode
{
    ERR_DATASET_INVALID_NAME("Invalid dataset name", InfoMessage.FixabilityCategory.USER_CONFIG_DATASET),
    ERR_DATASET_INVALID_CONFIG("Invalid dataset configuration", InfoMessage.FixabilityCategory.USER_CONFIG_DATASET),
    ERR_DATASET_INVALID_TYPE("Dataset with unknown type found", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING),
    ERR_DATASET_PARTITION_EMPTY("Input partition is empty", InfoMessage.FixabilityCategory.USER_CONFIG_OR_BUILD),
    ERR_DATASET_WRITE_IN_NON_WRITABLE_CONNECTION("Dataset is a target in Flow but is in a non-writable connection", InfoMessage.FixabilityCategory.USER_CONFIG_DATASET),
    WARN_DATASET_USED_FOR_HIVE_BAD_CSV_FORMAT("Dataset used by a Hive recipe has incompatible format parameters", InfoMessage.FixabilityCategory.USER_CONFIG_DATASET),
    ERR_DATASET_SCHEMA_TO_DATA_MISMATCH("Mismatch between dataset schema and data", InfoMessage.FixabilityCategory.USER_CONFIG),
    ERR_DATASET_SCHEMA_CONSISTENCY_CHECK_FAILED("Failed to check consistency between schema and data", InfoMessage.FixabilityCategory.UNKNOWN),
    ERR_DATASET_INVALID_FORMAT_CONFIG("Invalid format configuration", InfoMessage.FixabilityCategory.USER_CONFIG_DATASET),
    ERR_DATASET_HIVE_INCOMPATIBLE_SCHEMA("Dataset schema not compatible with Hive", InfoMessage.FixabilityCategory.USER_CONFIG_DATASET),
    WARN_DATASET_UNSAFE_NAME("Chosen dataset name may cause issues", InfoMessage.FixabilityCategory.USER_CONFIG_DATASET),
    WARN_DATASET_MANAGED_UNSAFE_NAME("Chosen dataset name may cause issues", InfoMessage.FixabilityCategory.USER_CONFIG_DATASET),
    WARN_SQL_TABLE_NAME_CONFLICTS_WITH_OTHER_DATASET("Table name conflicts with another dataset", InfoMessage.FixabilityCategory.USER_CONFIG_DATASET),
    WARN_DATASET_DELETION_INTERNAL_ERROR("Internal error while clearing or deleting dataset", InfoMessage.FixabilityCategory.UNKNOWN),
    ERR_DATASET_DELETION_HIVE_FAILED("Failed dropping Hive table for dataset", InfoMessage.FixabilityCategory.UNKNOWN),
    ERR_DATASET_DELETION_DATA_FAILED("Failed clearing data for dataset", InfoMessage.FixabilityCategory.UNKNOWN),
    ERR_DATASET_DELETION_RESOURCES_FAILED("Failed clearing resources for dataset", InfoMessage.FixabilityCategory.UNKNOWN),
    ERR_DATASET_ACTION_NOT_SUPPORTED("Action not supported", InfoMessage.FixabilityCategory.UNKNOWN),
    ERR_DATASET_GENERIC_ERROR("Dataset error", InfoMessage.FixabilityCategory.UNKNOWN),
    ERR_DATASET_INVALID_PARTITIONING_CONFIG("Invalid partitioning", InfoMessage.FixabilityCategory.USER_CONFIG_DATASET),
    ERR_DATASET_CANNOT_PARTITION_DATABASE_TABLE("Cannot partition database table", InfoMessage.FixabilityCategory.USER_CONFIG_DATASET),
    ERR_DATASET_INVALID_METRIC_IDENTIFIER("Invalid or outdated metric identifier", InfoMessage.FixabilityCategory.IRRELEVANT),
    WARN_DATASET_MYSQL_SCHEMA_TOO_LARGE("MySQL table schema may be too large", InfoMessage.FixabilityCategory.USER_CONFIG),
    WARN_DATASET_TERADATA_SCHEMA_TOO_LARGE("Teradata table schema may be too large", InfoMessage.FixabilityCategory.USER_CONFIG),
    WARN_DATASET_NETEZZA_SCHEMA_TOO_LARGE("Netezza table schema may be too large", InfoMessage.FixabilityCategory.USER_CONFIG),
    WARN_DATASET_YELLOWBRICK_SCHEMA_TOO_LARGE("Yellowbrick table schema may be too large", InfoMessage.FixabilityCategory.USER_CONFIG),
    ERR_MISSING_SCHEMA("Missing dataset connection schema", InfoMessage.FixabilityCategory.USER_CONFIG_DATASET),
    ERR_DATASET_TRUNCATED_COMPRESSED_DATA("Truncated or invalid compressed data", InfoMessage.FixabilityCategory.DATA),
    ERR_DATASET_CSV_UNTERMINATED_QUOTE("Unterminated quoted field at the end of the file", InfoMessage.FixabilityCategory.USER_CONFIG_DATASET),
    ERR_DATASET_CSV_ROW_TOO_LARGE("Row length is too large", InfoMessage.FixabilityCategory.USER_CONFIG_DATASET),
    ERR_DATASET_DANGEROUS_PARTITIONING("Partitioning dependency could lead to unwanted costs and duplicated rows", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_DATASET_DANGEROUS_PARTITIONING_ACTIONABLE("Partitioning dependency could lead to unwanted costs and duplicated rows", InfoMessage.FixabilityCategory.IRRELEVANT);

    private final String title;
    private final InfoMessage.FixabilityCategory fixability;

    private DatasetCodes(String title, InfoMessage.FixabilityCategory fixability) {
        this.title = title;
        this.fixability = fixability;
    }

    public String getCode() {
        return this.name();
    }

    public String getCodeTitle() {
        return this.title;
    }

    public InfoMessage.FixabilityCategory getFixability() {
        return this.fixability;
    }
}

