/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.expressions;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.types.DataType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class ImplicitCastExpression
implements Expression {
    private final Expression input;
    private final DataType outputType;
    private static final Map<String, List<String>> UP_CASTABLE_TYPE_TABLE = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
        {
            this.put("byte", Arrays.asList("short", "integer", "long", "float", "double"));
            this.put("short", Arrays.asList("integer", "long", "float", "double"));
            this.put("integer", Arrays.asList("long", "float", "double"));
            this.put("long", Arrays.asList("float", "double"));
            this.put("float", Arrays.asList("double"));
        }
    });

    ImplicitCastExpression(Expression expression, DataType dataType) {
        this.input = Objects.requireNonNull(expression, "input is null");
        this.outputType = Objects.requireNonNull(dataType, "outputType is null");
    }

    public Expression getInput() {
        return this.input;
    }

    public DataType getOutputType() {
        return this.outputType;
    }

    public List<Expression> getChildren() {
        return Collections.singletonList(this.input);
    }

    ColumnVector eval(ColumnVector columnVector) {
        String string;
        switch (string = columnVector.getDataType().toString()) {
            case "byte": {
                return new ByteUpConverter(this.outputType, columnVector);
            }
            case "short": {
                return new ShortUpConverter(this.outputType, columnVector);
            }
            case "integer": {
                return new IntUpConverter(this.outputType, columnVector);
            }
            case "long": {
                return new LongUpConverter(this.outputType, columnVector);
            }
            case "float": {
                return new FloatUpConverter(this.outputType, columnVector);
            }
        }
        throw new UnsupportedOperationException(String.format("Cast from %s is not supported", string));
    }

    static boolean canCastTo(DataType dataType, DataType dataType2) {
        String string = dataType.toString();
        String string2 = dataType2.toString();
        return UP_CASTABLE_TYPE_TABLE.containsKey(string) && UP_CASTABLE_TYPE_TABLE.get(string).contains(string2);
    }

    private static class FloatUpConverter
    extends UpConverter {
        FloatUpConverter(DataType dataType, ColumnVector columnVector) {
            super(dataType, columnVector);
        }

        public double getDouble(int n) {
            return this.inputVector.getFloat(n);
        }
    }

    private static class LongUpConverter
    extends UpConverter {
        LongUpConverter(DataType dataType, ColumnVector columnVector) {
            super(dataType, columnVector);
        }

        public float getFloat(int n) {
            return this.inputVector.getLong(n);
        }

        public double getDouble(int n) {
            return this.inputVector.getLong(n);
        }
    }

    private static class IntUpConverter
    extends UpConverter {
        IntUpConverter(DataType dataType, ColumnVector columnVector) {
            super(dataType, columnVector);
        }

        public long getLong(int n) {
            return this.inputVector.getInt(n);
        }

        public float getFloat(int n) {
            return this.inputVector.getInt(n);
        }

        public double getDouble(int n) {
            return this.inputVector.getInt(n);
        }
    }

    private static class ShortUpConverter
    extends UpConverter {
        ShortUpConverter(DataType dataType, ColumnVector columnVector) {
            super(dataType, columnVector);
        }

        public int getInt(int n) {
            return this.inputVector.getShort(n);
        }

        public long getLong(int n) {
            return this.inputVector.getShort(n);
        }

        public float getFloat(int n) {
            return this.inputVector.getShort(n);
        }

        public double getDouble(int n) {
            return this.inputVector.getShort(n);
        }
    }

    private static class ByteUpConverter
    extends UpConverter {
        ByteUpConverter(DataType dataType, ColumnVector columnVector) {
            super(dataType, columnVector);
        }

        public short getShort(int n) {
            return this.inputVector.getByte(n);
        }

        public int getInt(int n) {
            return this.inputVector.getByte(n);
        }

        public long getLong(int n) {
            return this.inputVector.getByte(n);
        }

        public float getFloat(int n) {
            return this.inputVector.getByte(n);
        }

        public double getDouble(int n) {
            return this.inputVector.getByte(n);
        }
    }

    private static abstract class UpConverter
    implements ColumnVector {
        protected final DataType targetType;
        protected final ColumnVector inputVector;

        UpConverter(DataType dataType, ColumnVector columnVector) {
            this.targetType = dataType;
            this.inputVector = columnVector;
        }

        public DataType getDataType() {
            return this.targetType;
        }

        public boolean isNullAt(int n) {
            return this.inputVector.isNullAt(n);
        }

        public int getSize() {
            return this.inputVector.getSize();
        }

        public void close() {
            this.inputVector.close();
        }
    }
}

