/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.oauth;

import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.CredentialsProvider;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.DatabricksConfig;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.DatabricksException;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.HeaderFactory;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.http.Request;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.http.Response;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.oauth.OidcTokenSource;
import com.dataiku.dss.shadelibdatabricks.com.fasterxml.jackson.databind.ObjectMapper;
import com.dataiku.dss.shadelibdatabricks.com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;

public class AzureGithubOidcCredentialsProvider
implements CredentialsProvider {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public String authType() {
        return "github-oidc-azure";
    }

    @Override
    public HeaderFactory configure(DatabricksConfig config) {
        if (!config.isAzure() || config.getAzureClientId() == null || config.getAzureTenantId() == null || config.getHost() == null) {
            return null;
        }
        Optional<String> idToken = this.requestIdToken(config);
        if (!idToken.isPresent()) {
            return null;
        }
        OidcTokenSource tokenSource = new OidcTokenSource(config.getHttpClient(), config.getDatabricksEnvironment().getAzureEnvironment().getActiveDirectoryEndpoint() + config.getAzureTenantId() + "/oauth2/token", config.getAzureClientId(), config.getEffectiveAzureLoginAppId(), idToken.get(), "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        return () -> {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Bearer " + tokenSource.getToken().getAccessToken());
            return headers;
        };
    }

    private Optional<String> requestIdToken(DatabricksConfig config) {
        ObjectNode jsonResp;
        Response resp;
        if (config.getActionsIdTokenRequestUrl() == null || config.getActionsIdTokenRequestToken() == null) {
            return Optional.empty();
        }
        String requestUrl = config.getActionsIdTokenRequestUrl() + "&audience=api://AzureADTokenExchange";
        Request req = new Request("GET", requestUrl).withHeader("Authorization", "Bearer " + config.getActionsIdTokenRequestToken());
        try {
            resp = config.getHttpClient().execute(req);
        }
        catch (IOException e) {
            throw new DatabricksException("Failed to request ID token from " + requestUrl + ":" + e.getMessage(), e);
        }
        if (resp.getStatusCode() != 200) {
            throw new DatabricksException("Failed to request ID token: status code " + resp.getStatusCode() + ", response body: " + resp.getBody().toString());
        }
        try {
            jsonResp = this.mapper.readValue(resp.getBody(), ObjectNode.class);
        }
        catch (IOException e) {
            throw new DatabricksException("Failed to request ID token: corrupted token: " + e.getMessage());
        }
        return Optional.ofNullable(jsonResp.get("value").textValue());
    }
}

