/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files;

import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.ApiClient;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.http.Encoding;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.CreateDirectoryRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.CreateDirectoryResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.DeleteDirectoryRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.DeleteDirectoryResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.DeleteFileRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.DeleteResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.DownloadRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.DownloadResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.FilesService;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.GetDirectoryMetadataRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.GetDirectoryMetadataResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.GetMetadataRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.GetMetadataResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.ListDirectoryContentsRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.ListDirectoryResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.UploadRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.UploadResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class FilesImpl
implements FilesService {
    private final ApiClient apiClient;

    public FilesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void createDirectory(CreateDirectoryRequest request) {
        String path = String.format("/api/2.0/fs/directories%s", Encoding.encodeMultiSegmentPathParameter(request.getDirectoryPath()));
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.PUT(path, null, CreateDirectoryResponse.class, headers);
    }

    @Override
    public void delete(DeleteFileRequest request) {
        String path = String.format("/api/2.0/fs/files%s", Encoding.encodeMultiSegmentPathParameter(request.getFilePath()));
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.DELETE(path, request, DeleteResponse.class, headers);
    }

    @Override
    public void deleteDirectory(DeleteDirectoryRequest request) {
        String path = String.format("/api/2.0/fs/directories%s", Encoding.encodeMultiSegmentPathParameter(request.getDirectoryPath()));
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.DELETE(path, request, DeleteDirectoryResponse.class, headers);
    }

    @Override
    public DownloadResponse download(DownloadRequest request) {
        String path = String.format("/api/2.0/fs/files%s", Encoding.encodeMultiSegmentPathParameter(request.getFilePath()));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/octet-stream");
        return this.apiClient.GET(path, request, DownloadResponse.class, headers);
    }

    @Override
    public void getDirectoryMetadata(GetDirectoryMetadataRequest request) {
        String path = String.format("/api/2.0/fs/directories%s", Encoding.encodeMultiSegmentPathParameter(request.getDirectoryPath()));
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.HEAD(path, request, GetDirectoryMetadataResponse.class, headers);
    }

    @Override
    public GetMetadataResponse getMetadata(GetMetadataRequest request) {
        String path = String.format("/api/2.0/fs/files%s", Encoding.encodeMultiSegmentPathParameter(request.getFilePath()));
        HashMap<String, String> headers = new HashMap<String, String>();
        return this.apiClient.HEAD(path, request, GetMetadataResponse.class, headers);
    }

    @Override
    public ListDirectoryResponse listDirectoryContents(ListDirectoryContentsRequest request) {
        String path = String.format("/api/2.0/fs/directories%s", Encoding.encodeMultiSegmentPathParameter(request.getDirectoryPath()));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListDirectoryResponse.class, headers);
    }

    @Override
    public void upload(UploadRequest request) {
        String path = String.format("/api/2.0/fs/files%s", Encoding.encodeMultiSegmentPathParameter(request.getFilePath()));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/octet-stream");
        this.apiClient.PUT(path, request.getContents(), UploadResponse.class, headers);
    }
}

