/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.commons.math3.fitting.leastsquares;

import com.dataiku.dss.shadelibpoi.org.apache.commons.math3.fitting.leastsquares.AbstractEvaluation;
import com.dataiku.dss.shadelibpoi.org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import com.dataiku.dss.shadelibpoi.org.apache.commons.math3.linear.RealMatrix;
import com.dataiku.dss.shadelibpoi.org.apache.commons.math3.linear.RealVector;

class DenseWeightedEvaluation
extends AbstractEvaluation {
    private final LeastSquaresProblem.Evaluation unweighted;
    private final RealMatrix weightSqrt;

    DenseWeightedEvaluation(LeastSquaresProblem.Evaluation unweighted, RealMatrix weightSqrt) {
        super(weightSqrt.getColumnDimension());
        this.unweighted = unweighted;
        this.weightSqrt = weightSqrt;
    }

    public RealMatrix getJacobian() {
        return this.weightSqrt.multiply(this.unweighted.getJacobian());
    }

    public RealVector getResiduals() {
        return this.weightSqrt.operate(this.unweighted.getResiduals());
    }

    public RealVector getPoint() {
        return this.unweighted.getPoint();
    }
}

