/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.xwpf.model;

import com.dataiku.dss.shadelibpoi.org.apache.poi.xwpf.model.XWPFParagraphDecorator;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xwpf.usermodel.XWPFComment;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xwpf.usermodel.XWPFParagraph;
import java.math.BigInteger;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTMarkupRange;

public class XWPFCommentsDecorator
extends XWPFParagraphDecorator {
    private StringBuilder commentText = new StringBuilder(64);

    public XWPFCommentsDecorator(XWPFParagraphDecorator nextDecorator) {
        this(nextDecorator.paragraph, nextDecorator);
    }

    public XWPFCommentsDecorator(XWPFParagraph paragraph, XWPFParagraphDecorator nextDecorator) {
        super(paragraph, nextDecorator);
        for (CTMarkupRange anchor : paragraph.getCTP().getCommentRangeStartArray()) {
            XWPFComment comment;
            BigInteger id = anchor.getId();
            if (id == null || (comment = paragraph.getDocument().getCommentByID(id.toString())) == null) continue;
            this.commentText.append("\tComment by ").append(comment.getAuthor()).append(": ").append(comment.getText());
        }
    }

    public String getCommentText() {
        return this.commentText.toString();
    }

    @Override
    public String getText() {
        return super.getText() + this.commentText;
    }
}

