/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.example;

import java.io.IOException;
import java.security.KeyPair;
import java.sql.Connection;
import java.time.Instant;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.snowflake.ingest.SimpleIngestManager;
import net.snowflake.ingest.connection.HistoryRangeResponse;
import net.snowflake.ingest.connection.HistoryResponse;
import net.snowflake.ingest.connection.IngestResponse;
import net.snowflake.ingest.connection.IngestResponseException;
import net.snowflake.ingest.example.IngestExampleHelper;
import net.snowflake.ingest.utils.StagedFileWrapper;

public class SnowflakeIngestBasicExample {
    private static String account = "s3testaccount";
    private static String user = "snowman";
    private static String host = "s3testaccount.snowflakecomputing.com";
    private static String scheme = "https";
    private static String password = "****";
    private static int port = 8080;
    private static String database = "testdb";
    private static String schema = "public";
    private static String stage = "ingest_stage";
    private static String table = "ingest_table";
    private static String pipe = "ingest_pipe";
    private static Connection conn;
    private static String fqPipe;
    private static SimpleIngestManager manager;
    private static KeyPair keypair;

    private static void setup(Set<String> files, String filesLocation) throws Exception {
        IngestExampleHelper.doQuery(conn, "use database " + database);
        IngestExampleHelper.doQuery(conn, "use schema " + schema);
        IngestExampleHelper.doQuery(conn, "create or replace stage " + stage + " FILE_FORMAT=(type='csv' COMPRESSION=NONE)");
        IngestExampleHelper.doQuery(conn, "create or replace table " + table + " (row_id int, row_str string, num int, src string)");
        IngestExampleHelper.doQuery(conn, "create or replace pipe " + pipe + " as copy into " + table + " from @" + stage + " file_format=(type='csv')");
        String pk = IngestExampleHelper.getPublicKeyString(keypair);
        IngestExampleHelper.doQuery(conn, "use role accountadmin");
        IngestExampleHelper.doQuery(conn, "alter user " + user + " set RSA_PUBLIC_KEY='" + pk + "'");
        files.forEach(file -> IngestExampleHelper.doQuery(conn, "PUT " + filesLocation + file + " @" + stage + " AUTO_COMPRESS=FALSE"));
        IngestExampleHelper.doQuery(conn, "use role sysadmin");
    }

    private static IngestResponse insertFile(String filename) throws Exception {
        StagedFileWrapper myFile = new StagedFileWrapper(filename, null);
        return manager.ingestFile(myFile, null);
    }

    private static IngestResponse insertFiles(Set<String> files) throws Exception {
        return manager.ingestFiles(SimpleIngestManager.wrapFilepaths(files), null);
    }

    private static HistoryResponse waitForFilesHistory(Set<String> files) throws Exception {
        ExecutorService service = Executors.newSingleThreadExecutor();
        class GetHistory
        implements Callable<HistoryResponse> {
            private Set<String> filesWatchList;
            String beginMark = null;

            GetHistory(Set<String> files) {
                this.filesWatchList = files;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public HistoryResponse call() throws Exception {
                filesHistory = null;
                block0: while (true) {
                    Thread.sleep(500L);
                    response = SnowflakeIngestBasicExample.access$000().getHistory(null, null, this.beginMark);
                    if (response.getNextBeginMark() != null) {
                        this.beginMark = response.getNextBeginMark();
                    }
                    if (response == null || response.files == null) continue;
                    var3_3 = response.files.iterator();
                    while (true) {
                        if (var3_3.hasNext()) ** break;
                        continue block0;
                        entry = var3_3.next();
                        filename = entry.getPath();
                        if (entry.getPath() == null || !entry.isComplete().booleanValue() || !this.filesWatchList.contains(filename)) continue;
                        if (filesHistory == null) {
                            filesHistory = new HistoryResponse();
                            filesHistory.setPipe(response.getPipe());
                        }
                        filesHistory.files.add(entry);
                        this.filesWatchList.remove(filename);
                        if (this.filesWatchList.isEmpty()) break block0;
                    }
                    break;
                }
                return filesHistory;
            }
        }
        GetHistory historyCaller = new GetHistory(files);
        Future<HistoryResponse> result = service.submit(historyCaller);
        HistoryResponse response = result.get(2L, TimeUnit.MINUTES);
        return response;
    }

    public static void main(String[] args) throws IOException {
        String filesDirectory = "/tmp/data/";
        String filesLocationUrl = "file:///tmp/data/";
        String fileWithWrongCSVFormat = "letters.csv";
        IngestExampleHelper.makeLocalDirectory("/tmp/data/");
        IngestExampleHelper.makeSampleFile("/tmp/data/", "letters.csv");
        TreeSet<String> files = new TreeSet<String>();
        files.add(IngestExampleHelper.createTempCsv("/tmp/data/", "sample", 10).getFileName().toString());
        files.add(IngestExampleHelper.createTempCsv("/tmp/data/", "sample", 15).getFileName().toString());
        files.add(IngestExampleHelper.createTempCsv("/tmp/data/", "sample", 20).getFileName().toString());
        System.out.println("Starting snowflake ingest client");
        System.out.println("Connecting to " + scheme + "://" + host + ":" + port + "\n with Account:" + account + ", User: " + user);
        try {
            long oneHourMillis = 3600000L;
            String startTime = Instant.ofEpochMilli(System.currentTimeMillis() - 14400000L).toString();
            conn = IngestExampleHelper.getConnection(user, password, account, host, port);
            keypair = IngestExampleHelper.generateKeyPair();
            manager = new SimpleIngestManager(account, user, fqPipe, keypair, scheme, host, port);
            files.add("letters.csv");
            SnowflakeIngestBasicExample.setup(files, "file:///tmp/data/");
            IngestResponse response = SnowflakeIngestBasicExample.insertFiles(files);
            System.out.println("Received ingest response: " + response.toString());
            response = SnowflakeIngestBasicExample.insertFile("letters.csv");
            System.out.println("Received ingest response: " + response.toString());
            HistoryResponse history = SnowflakeIngestBasicExample.waitForFilesHistory(files);
            System.out.println("Received history response: " + history.toString());
            String endTime = Instant.ofEpochMilli(System.currentTimeMillis()).toString();
            HistoryRangeResponse historyRangeResponse = manager.getHistoryRange(null, startTime, endTime);
            System.out.println("Received history range response: " + historyRangeResponse.toString());
        }
        catch (IngestResponseException e) {
            System.out.println("Service exception: " + e.toString());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    static /* synthetic */ SimpleIngestManager access$000() {
        return manager;
    }

    static {
        fqPipe = database + "." + schema + "." + pipe;
    }
}

