/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.geo;

import com.dataiku.dip.shaker.processors.SnowflakeUDF;
import com.dataiku.dip.shaker.processors.geo.GeoIPResolverParameter;
import com.dataiku.dss.shadelib.com.google.common.net.InetAddresses;
import com.dataiku.dss.shadelib.com.google.gson.GsonBuilder;
import com.dataiku.geoip.fastgeo.FastGeoIP2;
import com.dataiku.geoip.uniquedb.InvalidDatabaseException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GeoIPResolverUDF
extends SnowflakeUDF {
    private FastGeoIP2 fastAPI;
    private GeoIPResolverParameter parameter;
    private boolean initialized;
    private HashMap<String, String> countryCodeMap;
    private static Logger logger = Logger.getLogger((String)"dku.prepare.geoip");

    private void initialize(String settings) throws InvalidDatabaseException, IOException {
        this.parameter = (GeoIPResolverParameter)new GsonBuilder().create().fromJson(settings, GeoIPResolverParameter.class);
        String importDirectory = System.getProperty("com.snowflake.import_directory");
        File f = new File(importDirectory, "GeoLite2City.fgdb.gz");
        this.fastAPI = new FastGeoIP2(f);
        Locale[] availableLocales = Locale.getAvailableLocales();
        this.countryCodeMap = new HashMap();
        for (Locale l : availableLocales) {
            try {
                this.countryCodeMap.put(l.getCountry(), l.getISO3Country());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        this.initialized = true;
    }

    public String browse(String path) {
        File f = new File(path);
        String s = "BROWSING: " + f.getName() + "if=" + f.isFile() + " id=" + f.isDirectory() + " -------\n";
        File[] data = f.listFiles();
        if (data == null) {
            s = s + " CANT LIST";
        } else {
            for (File subfile : data) {
                s = s + " ENTRY " + subfile.getName() + " if=" + subfile.isFile() + " id=" + subfile.isDirectory() + " ---\n";
            }
        }
        return s;
    }

    public String cat(String path) throws IOException {
        try (FileReader fis = new FileReader(new File(path));){
            char[] x = new char[32768];
            fis.read(x);
            String string = new String(x);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] process(String inputData, String settings) throws InvalidDatabaseException, IOException, InterruptedException {
        InetAddress addr;
        block43: {
            GeoIPResolverUDF geoIPResolverUDF = this;
            synchronized (geoIPResolverUDF) {
                if (!this.initialized) {
                    this.initialize(settings);
                }
            }
            String iCV = inputData;
            addr = null;
            try {
                if (iCV != null && iCV.length() > 2) {
                    addr = InetAddresses.forString((String)iCV);
                }
            }
            catch (IllegalArgumentException e) {
                if (!iCV.contains(",")) break block43;
                try {
                    String[] ips = iCV.split(",");
                    for (int i = ips.length - 1; i >= 0; --i) {
                        String ip = ips[i].trim();
                        if (ip.matches("(^127\\.0\\.0\\.1)|(^10\\.)|(^172\\.1[6-9]\\.)|(^172\\.2[0-9]\\.)|(^172\\.3[0-1]\\.)|(^192\\.168\\.)")) continue;
                        addr = InetAddresses.forString((String)ip);
                    }
                }
                catch (IllegalArgumentException e2) {
                    addr = null;
                }
            }
        }
        FastGeoIP2.Result details = null;
        if (addr != null) {
            try {
                details = this.fastAPI.find(addr);
            }
            catch (Exception e) {
                logger.warn((Object)"GeoIP processing failed ", (Throwable)e);
            }
        }
        ArrayList<Object> output = new ArrayList<Object>();
        if (details == null) {
            if (this.parameter.extract_continentcode) {
                output.add(null);
            }
            if (this.parameter.extract_timezone) {
                output.add(null);
            }
            if (this.parameter.extract_latlng) {
                output.add(null);
                output.add(null);
            }
            if (this.parameter.extract_geopoint) {
                output.add(null);
            }
            if (this.parameter.extract_postalcode) {
                output.add(null);
            }
            if (this.parameter.extract_city) {
                output.add(null);
            }
            if (this.parameter.extract_region) {
                output.add(null);
                output.add(null);
                output.add(null);
            }
            if (this.parameter.extract_countrycode) {
                output.add(null);
            }
            if (this.parameter.extract_countrycode3) {
                output.add(null);
            }
            if (this.parameter.extract_country) {
                output.add(null);
            }
        } else {
            if (this.parameter.extract_continentcode) {
                output.add(details.getContinent());
            }
            if (this.parameter.extract_timezone) {
                output.add(details.getTimezone());
            }
            if (this.parameter.extract_latlng) {
                String longitude = details.getLongitude();
                String latitude = details.getLatitude();
                if (StringUtils.isNotBlank((String)longitude)) {
                    output.add(longitude);
                } else {
                    output.add(null);
                }
                if (StringUtils.isNotBlank((String)latitude)) {
                    output.add(latitude);
                } else {
                    output.add(null);
                }
            }
            if (this.parameter.extract_geopoint) {
                String lat = details.getLatitude();
                String lon = details.getLongitude();
                if (StringUtils.isNotBlank((String)lat) && StringUtils.isNotBlank((String)lon)) {
                    output.add("POINT(" + lon + " " + lat + ")");
                } else {
                    output.add(null);
                }
            }
            if (this.parameter.extract_postalcode) {
                output.add(details.getPostalCode());
            }
            if (this.parameter.extract_city) {
                output.add(details.getCity());
            }
            if (this.parameter.extract_region) {
                Object regionHierarchy = "";
                String mostSpecificName = "";
                String mostSpecificCode = "";
                boolean first = true;
                for (FastGeoIP2.Result.Subdivision sub : details.getSubdivisions()) {
                    if (!first) {
                        regionHierarchy = (String)regionHierarchy + ",";
                    }
                    regionHierarchy = (String)regionHierarchy + sub.name;
                    mostSpecificName = sub.name;
                    mostSpecificCode = sub.code;
                    first = false;
                }
                output.add(regionHierarchy);
                output.add(mostSpecificName);
                output.add(mostSpecificCode);
            }
            if (this.parameter.extract_countrycode) {
                output.add(details.getCountryCode());
            }
            if (this.parameter.extract_countrycode3) {
                output.add(this.countryCodeMap.get(details.getCountryCode()));
            }
            if (this.parameter.extract_country) {
                output.add(details.getCountry());
            }
        }
        return output.toArray(new String[0]);
    }
}

