/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.numbers;

import com.dataiku.dip.shaker.processors.SnowflakeUDF;
import com.dataiku.dip.shaker.processors.numbers.BinnerAlgorithm;
import java.util.Arrays;
import java.util.Iterator;

public class BinnerProcessorUDF
extends SnowflakeUDF {
    private static BinnerAlgorithm binnerAlgorithm = null;

    public String widthModeProcess(String input, double binWidth, Double maxValue, Double minValue) {
        if (binnerAlgorithm == null) {
            BinnerAlgorithm.Parameter params = new BinnerAlgorithm.Parameter();
            params.mode = BinnerAlgorithm.Mode.WIDTH;
            params.width = binWidth;
            params.useMax = maxValue != null;
            boolean bl = params.useMin = minValue != null;
            if (params.useMax) {
                params.max = maxValue;
            }
            if (params.useMin) {
                params.min = minValue;
            }
            binnerAlgorithm = new BinnerAlgorithm(params);
        }
        return binnerAlgorithm.bin(input);
    }

    public String customModeProcess(String input, String ... bins) {
        if (binnerAlgorithm == null) {
            BinnerAlgorithm.Parameter params = new BinnerAlgorithm.Parameter();
            params.mode = BinnerAlgorithm.Mode.CUSTOM;
            Iterator it = Arrays.stream(bins).iterator();
            while (it.hasNext()) {
                String infString = (String)it.next();
                Double inf = infString == null ? null : Double.valueOf(Double.parseDouble(infString));
                String supString = (String)it.next();
                Double sup = supString == null ? null : Double.valueOf(Double.parseDouble(supString));
                String name = (String)it.next();
                BinnerAlgorithm.Interval interval = new BinnerAlgorithm.Interval(inf, sup, name);
                params.bins.add(interval);
            }
            binnerAlgorithm = new BinnerAlgorithm(params);
        }
        return binnerAlgorithm.bin(input);
    }
}

