/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.numbers;

import com.dataiku.dip.shaker.processors.SnowflakeUDF;
import com.dataiku.dip.shaker.processors.numbers.CurrencyConverterAlgorithm;
import java.io.File;

public class CurrencyConverterUDF
extends SnowflakeUDF {
    private static boolean initialized;
    private static CurrencyConverterAlgorithm currencyConverterAlgorithm;

    public void init() {
        String importDirectory = System.getProperty("com.snowflake.import_directory");
        File resourceFile = new File(importDirectory, "data.csv.gz");
        currencyConverterAlgorithm = CurrencyConverterAlgorithm.getInstance(resourceFile);
        initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double process(String input, String inputCurrency, String outputCurrency, String date, Integer decimalNumber) {
        CurrencyConverterUDF currencyConverterUDF = this;
        synchronized (currencyConverterUDF) {
            if (!initialized) {
                this.init();
            }
        }
        return currencyConverterAlgorithm.convert(input, inputCurrency, outputCurrency, date, decimalNumber);
    }
}

