/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.shaker.types.AbstractLongMeaning;

public class LongMeaning
extends AbstractLongMeaning {
    private boolean hasZeroLeadingIntegers;

    @Override
    public String getMeaningId() {
        return "LongMeaning";
    }

    @Override
    public long longValue(String val) {
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            return Long.MAX_VALUE;
        }
    }

    public long permissiveLongValue(String val) {
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            try {
                double dval = Double.parseDouble(val);
                long lval = Math.round(dval);
                if (Math.abs(dval - (double)lval) < 1.0E-10) {
                    return lval;
                }
                return Long.MAX_VALUE;
            }
            catch (Exception e2) {
                return Long.MAX_VALUE;
            }
        }
    }

    @Override
    public double detects(String v) {
        if (v == null) {
            return 0.0;
        }
        for (int i = 0; i < v.length(); ++i) {
            if (!(i == 0 && v.charAt(i) == '-' ? v.length() == 1 : !Character.isDigit(v.charAt(i)))) continue;
            return 0.0;
        }
        if (v.length() > 1 && v.charAt(0) == '0') {
            this.hasZeroLeadingIntegers = true;
        }
        return 0.26;
    }

    public boolean hasZeroLeadingIntegers() {
        return this.hasZeroLeadingIntegers;
    }
}

