/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.measure.Quantity;
import javax.measure.spi.FormatService;
import javax.measure.spi.QuantityFactory;
import javax.measure.spi.SystemOfUnitsService;
import javax.measure.spi.UnitFormatService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class ServiceProvider {
    private static final String NAMED_ANNOTATION = "javax.inject.Named";
    private static final String PRIORITY_ANNOTATION = "javax.annotation.Priority";
    private static final AtomicReference<ServiceProvider> current = new AtomicReference();

    protected ServiceProvider() {
    }

    public int getPriority() {
        return 0;
    }

    public abstract SystemOfUnitsService getSystemOfUnitsService();

    @Deprecated(forRemoval=true)
    public abstract UnitFormatService getUnitFormatService();

    public abstract FormatService getFormatService();

    public abstract <Q extends Quantity<Q>> QuantityFactory<Q> getQuantityFactory(Class<Q> var1);

    public static final List<ServiceProvider> available() {
        ArrayList arrayList;
        block4: {
            arrayList = new Selector(null).stream().collect(Collectors.toCollection(ArrayList::new));
            ServiceProvider serviceProvider = current.get();
            if (serviceProvider == null && !arrayList.isEmpty()) {
                serviceProvider = ServiceProvider.setDefault((ServiceProvider)arrayList.get(0));
            }
            if (serviceProvider != null) {
                Class<?> clazz = serviceProvider.getClass();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    if (!clazz.equals(((ServiceProvider)arrayList.get(i)).getClass())) continue;
                    if (i != 0) {
                        arrayList.remove(i);
                        break;
                    }
                    break block4;
                }
                arrayList.add(0, serviceProvider);
            }
        }
        return arrayList;
    }

    public static ServiceProvider of(String string) {
        Objects.requireNonNull(string);
        Selector selector = new Selector(string);
        ServiceProvider serviceProvider = current.get();
        if (serviceProvider != null && selector.test(serviceProvider)) {
            return serviceProvider;
        }
        Optional optional = selector.stream().findFirst();
        if (optional.isPresent()) {
            return (ServiceProvider)optional.get();
        }
        throw new IllegalArgumentException("No measurement ServiceProvider " + string + " found .");
    }

    public static final ServiceProvider current() {
        ServiceProvider serviceProvider = current.get();
        if (serviceProvider == null) {
            Optional optional = new Selector(null).stream().findFirst();
            if (!optional.isPresent()) {
                throw new IllegalStateException("No measurement ServiceProvider found.");
            }
            serviceProvider = (ServiceProvider)optional.get();
            serviceProvider = ServiceProvider.setDefault(serviceProvider);
        }
        return serviceProvider;
    }

    private static ServiceProvider setDefault(ServiceProvider serviceProvider) {
        while (!current.compareAndSet(null, serviceProvider)) {
            ServiceProvider serviceProvider2 = current.get();
            if (serviceProvider2 == null) continue;
            return serviceProvider2;
        }
        return serviceProvider;
    }

    public static final ServiceProvider setCurrent(ServiceProvider serviceProvider) {
        Objects.requireNonNull(serviceProvider);
        ServiceProvider serviceProvider2 = current.getAndSet(serviceProvider);
        if (serviceProvider2 != serviceProvider) {
            System.getLogger("javax.measure.spi").log(System.Logger.Level.DEBUG, "Measurement ServiceProvider {1,choice,0#set to|1#replaced by} {0}.", serviceProvider.getClass().getName(), serviceProvider2 == null ? 0 : 1);
        }
        return serviceProvider2;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Selector
    implements Predicate<ServiceProvider>,
    Comparator<ServiceProvider> {
        private final String toSearch;
        private Class<? extends Annotation> nameAnnotation;
        private Class<? extends Annotation> priorityAnnotation;
        private Method nameGetter;
        private Method priorityGetter;

        Selector(String string) {
            this.toSearch = string;
            try {
                if (string != null) {
                    try {
                        this.nameAnnotation = Class.forName(ServiceProvider.NAMED_ANNOTATION).asSubclass(Annotation.class);
                        this.nameGetter = this.nameAnnotation.getMethod("value", null);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                try {
                    this.priorityAnnotation = Class.forName(ServiceProvider.PRIORITY_ANNOTATION).asSubclass(Annotation.class);
                    this.priorityGetter = this.priorityAnnotation.getMethod("value", null);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ServiceConfigurationError("Can not get annotation value", noSuchMethodException);
            }
        }

        @Override
        public boolean test(ServiceProvider serviceProvider) {
            Annotation annotation;
            Object object = null;
            if (this.nameGetter != null && (annotation = serviceProvider.getClass().getAnnotation(this.nameAnnotation)) != null) {
                try {
                    object = this.nameGetter.invoke((Object)annotation, (Object[])null);
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    throw new ServiceConfigurationError("Can not get annotation value", reflectiveOperationException);
                }
            }
            if (object == null) {
                object = serviceProvider.toString();
            }
            return this.toSearch.equals(object);
        }

        private int priority(ServiceProvider serviceProvider) {
            Annotation annotation;
            if (this.priorityGetter != null && (annotation = serviceProvider.getClass().getAnnotation(this.priorityAnnotation)) != null) {
                try {
                    return (Integer)this.priorityGetter.invoke((Object)annotation, (Object[])null);
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    throw new ServiceConfigurationError("Can not get annotation value", reflectiveOperationException);
                }
            }
            return serviceProvider.getPriority();
        }

        @Override
        public int compare(ServiceProvider serviceProvider, ServiceProvider serviceProvider2) {
            return Integer.compare(this.priority(serviceProvider), this.priority(serviceProvider2));
        }

        private Stream<ServiceProvider> stream() {
            Stream<ServiceProvider> stream = StreamSupport.stream(ServiceLoader.load(ServiceProvider.class).spliterator(), false);
            if (this.toSearch != null) {
                stream = stream.filter(this);
            }
            return stream.sorted(this);
        }
    }
}

