/*
 * Decompiled with CFR 0.152.
 */
package org.apache.toree.kernel.protocol.v5.handler;

import java.io.Serializable;
import org.apache.toree.comm.CommCallbacks;
import org.apache.toree.comm.CommRegistrar;
import org.apache.toree.comm.CommStorage;
import org.apache.toree.comm.KernelCommWriter;
import org.apache.toree.global.ExecuteRequestState$;
import org.apache.toree.kernel.protocol.v5.KMBuilder;
import org.apache.toree.kernel.protocol.v5.KMBuilder$;
import org.apache.toree.kernel.protocol.v5.KernelMessage;
import org.apache.toree.kernel.protocol.v5.content.CommClose;
import org.apache.toree.kernel.protocol.v5.content.CommClose$;
import org.apache.toree.kernel.protocol.v5.handler.BaseHandler;
import org.apache.toree.kernel.protocol.v5.kernel.ActorLoader;
import org.apache.toree.kernel.protocol.v5.kernel.Utilities$;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonValidationError;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001\u0002\u0005\n\u0001aA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tS\u0001\u0011\t\u0011)A\u0005U!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007C\u00035\u0001\u0011\u0005Q\u0007C\u0003;\u0001\u0011\u00053\bC\u0003X\u0001\u0011%\u0001\fC\u0003k\u0001\u0011%1N\u0001\tD_6l7\t\\8tK\"\u000bg\u000e\u001a7fe*\u0011!bC\u0001\bQ\u0006tG\r\\3s\u0015\taQ\"\u0001\u0002wk)\u0011abD\u0001\taJ|Go\\2pY*\u0011\u0001#E\u0001\u0007W\u0016\u0014h.\u001a7\u000b\u0005I\u0019\u0012!\u0002;pe\u0016,'B\u0001\u000b\u0016\u0003\u0019\t\u0007/Y2iK*\ta#A\u0002pe\u001e\u001c\u0001aE\u0002\u00013u\u0001\"AG\u000e\u000e\u0003%I!\u0001H\u0005\u0003\u0017\t\u000b7/\u001a%b]\u0012dWM\u001d\t\u0003=\u0005j\u0011a\b\u0006\u0003AE\tQ!\u001e;jYNL!AI\u0010\u0003#5+7o]1hK2{wmU;qa>\u0014H/A\u0006bGR|'\u000fT8bI\u0016\u0014\bCA\u0013(\u001b\u00051#B\u0001\t\f\u0013\tAcEA\u0006BGR|'\u000fT8bI\u0016\u0014\u0018!D2p[6\u0014VmZ5tiJ\f'\u000f\u0005\u0002,]5\tAF\u0003\u0002.#\u0005!1m\\7n\u0013\tyCFA\u0007D_6l'+Z4jgR\u0014\u0018M]\u0001\fG>lWn\u0015;pe\u0006<W\r\u0005\u0002,e%\u00111\u0007\f\u0002\f\u0007>lWn\u0015;pe\u0006<W-\u0001\u0004=S:LGO\u0010\u000b\u0005m]B\u0014\b\u0005\u0002\u001b\u0001!)1\u0005\u0002a\u0001I!)\u0011\u0006\u0002a\u0001U!)\u0001\u0007\u0002a\u0001c\u00059\u0001O]8dKN\u001cHC\u0001\u001fRa\tit\tE\u0002?\u0007\u0016k\u0011a\u0010\u0006\u0003\u0001\u0006\u000b!bY8oGV\u0014(/\u001a8u\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#@\u0005\u00191U\u000f^;sKB\u0011ai\u0012\u0007\u0001\t%AU!!A\u0001\u0002\u000b\u0005\u0011JA\u0002`IE\n\"A\u0013(\u0011\u0005-cU\"A!\n\u00055\u000b%a\u0002(pi\"Lgn\u001a\t\u0003\u0017>K!\u0001U!\u0003\u0007\u0005s\u0017\u0010C\u0003S\u000b\u0001\u00071+A\u0007lKJtW\r\\'fgN\fw-\u001a\t\u0003)Vk\u0011aC\u0005\u0003-.\u0011QbS3s]\u0016dW*Z:tC\u001e,\u0017a\u00045b]\u0012dWmQ8n[\u000ecwn]3\u0015\u0005e+GC\u0001.^!\tY5,\u0003\u0002]\u0003\n!QK\\5u\u0011\u0015qf\u00011\u0001`\u0003%\u0019w.\\7DY>\u001cX\r\u0005\u0002aG6\t\u0011M\u0003\u0002c\u0017\u000591m\u001c8uK:$\u0018B\u00013b\u0005%\u0019u.\\7DY>\u001cX\rC\u0003g\r\u0001\u0007q-A\u0005l[\n+\u0018\u000e\u001c3feB\u0011A\u000b[\u0005\u0003S.\u0011\u0011bS'Ck&dG-\u001a:\u0002!!\fg\u000e\u001a7f!\u0006\u00148/Z#se>\u0014HC\u0001.m\u0011\u0015iw\u00011\u0001o\u0003\u001dIgN^1mS\u0012\u00042a\\<{\u001d\t\u0001XO\u0004\u0002ri6\t!O\u0003\u0002t/\u00051AH]8pizJ\u0011AQ\u0005\u0003m\u0006\u000bq\u0001]1dW\u0006<W-\u0003\u0002ys\n\u00191+Z9\u000b\u0005Y\f\u0005#B&|{\u0006M\u0011B\u0001?B\u0005\u0019!V\u000f\u001d7feA\u0019a0a\u0004\u000e\u0003}TA!!\u0001\u0002\u0004\u0005!!n]8o\u0015\u0011\t)!a\u0002\u0002\t1L'm\u001d\u0006\u0005\u0003\u0013\tY!A\u0002ba&T!!!\u0004\u0002\tAd\u0017-_\u0005\u0004\u0003#y(A\u0002&t!\u0006$\b\u000e\u0005\u0003po\u0006U\u0001c\u0001@\u0002\u0018%\u0019\u0011\u0011D@\u0003')\u001bxN\u001c,bY&$\u0017\r^5p]\u0016\u0013(o\u001c:")
public class CommCloseHandler
extends BaseHandler {
    private final ActorLoader actorLoader;
    private final CommStorage commStorage;

    @Override
    public Future<?> process(KernelMessage kernelMessage) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logKernelMessageAction("Initiating Comm Close for", kernelMessage);
            ExecuteRequestState$.MODULE$.processIncomingKernelMessage(kernelMessage);
            KMBuilder kmBuilder = new KMBuilder(KMBuilder$.MODULE$.apply$default$1()).withParent(kernelMessage);
            Utilities$.MODULE$.parseAndHandle(kernelMessage.contentString(), CommClose$.MODULE$.commCloseReads(), (Function1 & Serializable & scala.Serializable)commClose -> {
                this.handleCommClose(kmBuilder, commClose);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable & scala.Serializable)invalid -> {
                this.handleParseError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)invalid);
                return BoxedUnit.UNIT;
            });
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private void handleCommClose(KMBuilder kmBuilder, CommClose commClose) {
        String commId = commClose.comm_id();
        JsValue data = commClose.data();
        this.logger().debug(new StringBuilder(30).append("Received comm_close with id '").append(commId).append("'").toString());
        KernelCommWriter commWriter = new KernelCommWriter(this.actorLoader, kmBuilder, commId);
        Option<CommCallbacks> option2 = this.commStorage.getCommIdCallbacks(commId);
        if (None$.MODULE$.equals(option2)) {
            this.logger().warn(new StringBuilder(36).append("Received invalid id for Comm Close: ").append(commId).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option2 instanceof Some) {
            Some some = (Some)option2;
            CommCallbacks callbacks = (CommCallbacks)some.value();
            this.logger().debug(new StringBuilder(35).append("Executing close callbacks for id '").append(commId).append("'").toString());
            ((IterableLike)((TraversableLike)callbacks.executeCloseCallbacks(commWriter, commId, data).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFailure()))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.failed(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)throwable2 -> {
                CommCloseHandler.$anonfun$handleCommClose$3(this, throwable2);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option2);
        }
    }

    private void handleParseError(Seq<Tuple2<JsPath, Seq<JsonValidationError>>> invalid) {
        this.logger().warn("Parse error for Comm Close! Not responding!");
    }

    public static final /* synthetic */ void $anonfun$handleCommClose$3(CommCloseHandler $this, Try throwable2) {
        $this.logger().error("Comm close callback encountered an error!", new Object[]{throwable2});
    }

    public CommCloseHandler(ActorLoader actorLoader, CommRegistrar commRegistrar, CommStorage commStorage) {
        this.actorLoader = actorLoader;
        this.commStorage = commStorage;
        super(actorLoader);
    }
}

