/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.sandbox.hive.common;

import com.dataiku.dss.shadelib.org.apache.commons.io.output.NullOutputStream;
import com.dataiku.hproxy.sandbox.hive.common.CleanableSessionState;
import com.dataiku.hproxy.sandbox.hive.common.HiveLoaderImpl;
import com.dataiku.hproxy.server.hive.executor.IHiveLoader;
import com.dataiku.hproxy.server.utils.IdGenerator;
import com.dataiku.hproxy.server.utils.LogCollector;
import com.dataiku.hproxy.server.utils.SessionLocalObject;
import com.dataiku.hproxy.utils.Reflector;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import org.apache.hadoop.hive.common.HiveInterruptUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.log4j.Logger;

public class HiveSession {
    private static Logger logger = Logger.getLogger(HiveSession.class);
    private HiveLoaderImpl loader;
    private HiveConf conf;
    private String sessionId;
    CleanableSessionState sessionState;
    private LogCollector errStream;
    private NullOutputStream outStream;

    public String getErrorStreamAsString() {
        try {
            this.sessionState.err.flush();
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        this.sessionState.childErr.flush();
        return this.errStream.toString();
    }

    private HiveSession() {
    }

    public void killMRJobs() {
        this.useMe();
        logger.info((Object)"Kill MR jobs");
        Reflector reflect = new Reflector(this.loader.getClassLoader());
        boolean ok = false;
        Exception error1 = null;
        Exception error2 = null;
        try {
            reflect.callStatic("org.apache.hadoop.hive.ql.exec.HadoopJobExecHelper", "killRunningJobs", new Object[0]);
            ok = true;
        }
        catch (Exception e) {
            error1 = e;
        }
        try {
            reflect.callStatic("org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHelper", "killRunningJobs", new Object[0]);
            ok = true;
        }
        catch (Exception e) {
            error2 = e;
        }
        if (ok) {
            logger.info((Object)"Killed Hive MR jobs successfully");
        } else {
            if (error1 != null) {
                logger.error((Object)"Failed to kill Hive MR jobs, method 1 failed", (Throwable)error1);
            }
            if (error2 != null) {
                logger.error((Object)"Failed to kill Hive MR jobs, method 2 failed", (Throwable)error2);
            }
        }
        this.release();
    }

    public Driver newDriver() {
        return new Driver(this.conf);
    }

    public void triggerInterruptions() {
        logger.info((Object)"Execute Hive interruption handlers");
        this.useMe();
        HiveInterruptUtils.interrupt();
        this.loader.getInterruptionList().removeFromSession();
    }

    public static HiveSession initSession(IHiveLoader hl) {
        HiveSession hs = new HiveSession();
        hs.loader = (HiveLoaderImpl)hl;
        Thread.currentThread().setContextClassLoader(hs.loader.getClassLoader());
        hs.sessionId = IdGenerator.generate();
        hs.conf = new HiveConf(hs.loader.getConf());
        hs.conf.set("hive.session.id", hs.sessionId);
        hs.sessionState = new CleanableSessionState(hs.conf);
        SessionState.start((SessionState)hs.sessionState);
        hs.sessionState.getConf().setClassLoader(hs.loader.getClassLoader());
        hs.errStream = new LogCollector();
        hs.outStream = new NullOutputStream();
        try {
            hs.sessionState.out = new PrintStream((OutputStream)hs.outStream);
            hs.sessionState.err = new PrintStream((OutputStream)hs.errStream);
            hs.sessionState.childOut = new PrintStream(hs.sessionState.out);
            hs.sessionState.childErr = new PrintStream(hs.sessionState.err);
        }
        catch (NoSuchFieldError e) {
            hs.sessionState.childOut = new PrintStream((OutputStream)hs.outStream);
            hs.sessionState.childErr = new PrintStream((OutputStream)hs.errStream);
        }
        hs.useMe();
        return hs;
    }

    public void useMe() {
        SessionLocalObject.enterSession((String)this.sessionId);
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public SessionState getSessionState() {
        return this.sessionState;
    }

    public void destroy() {
        if (this.sessionState.getTmpOutputFile() != null) {
            this.sessionState.getTmpOutputFile().delete();
        }
        try {
            this.sessionState.close();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to close sessionstate", (Throwable)e);
        }
        this.loader.getInjectedKillJobMap().removeFromSession();
        this.loader.getInjectedKillJobList().removeFromSession();
    }

    public String getLogTail() {
        return this.errStream.toString();
    }

    public void injectLogMessage(String msg) throws IOException {
        byte[] bytes = msg.getBytes(Charset.forName("UTF-8"));
        this.errStream.write(bytes);
    }

    public void release() {
        logger.info((Object)"Force hive to release resources");
        Reflector reflect = new Reflector(this.loader.getClassLoader());
        try {
            Object tezSession = reflect.call((Object)this.sessionState, "getTezSession", new Object[0]);
            if (tezSession != null) {
                logger.info((Object)"Found a Tez session, closing it");
                try {
                    reflect.call(tezSession, "close", new Object[]{false});
                    reflect.call((Object)this.sessionState, "setTezSession", new Object[]{null});
                }
                catch (Exception e) {
                    logger.info((Object)"Error while closing a Tez session", (Throwable)e);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

