/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.sandbox.hive.common;

import com.dataiku.hproxy.sandbox.hive.common.HiveLoaderImpl;
import com.dataiku.hproxy.sandbox.hive.common.HiveSession;
import com.dataiku.hproxy.server.hive.executor.IHiveLoader;
import com.dataiku.hproxy.server.hive.executor.IHiveSession;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.log4j.Logger;

public class HiveSessionImpl
implements IHiveSession {
    private final HiveLoaderImpl hiveLoaderImpl;
    private HiveSession session;
    private boolean destroyed = false;
    private static Logger logger = Logger.getLogger(HiveSessionImpl.class);

    public HiveSessionImpl(IHiveLoader hiveLoader) {
        this.hiveLoaderImpl = (HiveLoaderImpl)hiveLoader;
    }

    public HiveSession getSession() {
        if (this.session == null) {
            this.session = HiveSession.initSession(this.hiveLoaderImpl);
        }
        return this.session;
    }

    public void destroy() {
        if (this.session != null) {
            logger.info((Object)"Destroy Hive session");
            logger.info((Object)("The end session ID is " + this.session.getConf().getVar(HiveConf.ConfVars.HIVESESSIONID) + " for session object " + System.identityHashCode(this.session) + " and configuration object " + System.identityHashCode(this.session.getConf())));
            this.session.destroy();
            this.destroyed = true;
        }
    }

    public String getIdentifier() {
        if (this.session == null) {
            return "not started";
        }
        return this.session.sessionState.getSessionId();
    }

    public boolean isActive() {
        if (this.session == null) {
            return false;
        }
        return !this.destroyed;
    }
}

