/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.cli;

import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.BuiltinsLoader;
import com.dataiku.gh.cli.AddAdminPublicAPIKeyCommand;
import com.dataiku.gh.cli.AddUserCommand;
import com.dataiku.gh.cli.CLICommand;
import com.dataiku.gh.cli.CheckDBVersionCommand;
import com.dataiku.gh.cli.DecryptPasswordCommand;
import com.dataiku.gh.cli.DumpDBCommand;
import com.dataiku.gh.cli.EnableHashedApiKeysCommand;
import com.dataiku.gh.cli.EncryptPasswordCommand;
import com.dataiku.gh.cli.GenerateCryptoKeyCommand;
import com.dataiku.gh.cli.InitDBCommand;
import com.dataiku.gh.cli.ReloadDBCommand;
import com.dataiku.gh.cli.RemoveUserCommand;
import com.dataiku.gh.cli.SetUserPasswordCommand;
import com.dataiku.gh.cli.UpdateDBCommand;
import com.dataiku.gh.cli.internalcmd.InitialSetupHome;
import com.dataiku.gh.cli.internalcmd.SetMonitoringConfigCommand;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DKU {
    private static Map<String, Class<? extends CLICommand>> commands = new LinkedHashMap<String, Class<? extends CLICommand>>();

    public static void addGlobalOptions(Options opts) {
        opts.addOption("h", false, "Help");
        opts.addOption("v", false, "Verbose mode (enable debug logs)");
    }

    private static int dispatchOnCommand(String command, String[] args) throws Exception {
        Class<? extends CLICommand> cmd = commands.get(command.toLowerCase());
        if (cmd != null) {
            try {
                CLICommand actualCmd = cmd.newInstance();
                int result = actualCmd.execute(args);
                actualCmd.onPostExecute();
                return result;
            }
            catch (EndOfCommandException e) {
                return 0;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return 1;
            }
        }
        System.err.println("Unrecognized command : " + command);
        DKU.usage();
        return 1;
    }

    private static void usage() throws Exception {
        System.err.println("Dataiku DSS internal command-line");
        if (System.getenv("DKU_DEBUG_DUMP_COMMANDS") != null) {
            Options gopts = new Options();
            DKU.addGlobalOptions(gopts);
            new HelpFormatter().printHelp("dku [-h] [-v] command args", gopts);
            System.err.println();
            System.err.println("Available commands: ");
            for (Map.Entry<String, Class<? extends CLICommand>> e : commands.entrySet()) {
                System.err.println("  " + e.getKey());
            }
            System.err.println();
            System.err.println("Fore more information about a command, type 'dku command -h'");
        }
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("DIP_HOME", System.getenv("DIP_HOME"));
        ApplicationConfigurator.autoconfigure();
        MainLoggingConfigurator.configure((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.DKU);
        if (System.getenv("DKU_SILENT") != null) {
            Logger.getRootLogger().setLevel(Level.WARN);
        }
        if (System.getenv("DKU_NOTDEBUG") != null) {
            Logger.getRootLogger().setLevel(Level.INFO);
        }
        if (System.getenv("DKU_DEBUG") != null) {
            Logger.getRootLogger().setLevel(Level.DEBUG);
        }
        BuiltinsLoader.load();
        Options opts = new Options();
        DKU.addGlobalOptions(opts);
        CommandLine cmdLine = new LenientGNUParser().parse(opts, args);
        if (cmdLine.getArgs().length == 0) {
            DKU.usage();
        } else {
            String command = cmdLine.getArgs()[0];
            System.exit(DKU.dispatchOnCommand(command, args));
        }
    }

    static {
        commands.put("add-user", AddUserCommand.class);
        commands.put("remove-user", RemoveUserCommand.class);
        commands.put("user-set-password", SetUserPasswordCommand.class);
        commands.put("add-admin-api-key", AddAdminPublicAPIKeyCommand.class);
        commands.put("encrypt-password", EncryptPasswordCommand.class);
        commands.put("get-cleartext-password", DecryptPasswordCommand.class);
        commands.put("generate-crypto-key", GenerateCryptoKeyCommand.class);
        commands.put("enable-hashed-api-keys", EnableHashedApiKeysCommand.class);
        commands.put("__initial-setup-home", InitialSetupHome.class);
        commands.put("__set-monitoring-config", SetMonitoringConfigCommand.class);
        commands.put("init-db", InitDBCommand.class);
        commands.put("__update-db", UpdateDBCommand.class);
        commands.put("__check-db-version", CheckDBVersionCommand.class);
        commands.put("__dump-db", DumpDBCommand.class);
        commands.put("__reload-db", ReloadDBCommand.class);
    }

    static class EndOfCommandException
    extends IOException {
        EndOfCommandException() {
        }
    }

    public static class LenientGNUParser
    extends GnuParser {
        protected void processOption(String arg, ListIterator iter) throws ParseException {
            boolean hasOption = this.getOptions().hasOption(arg);
            if (hasOption) {
                super.processOption(arg, iter);
            }
        }
    }
}

