/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.cli;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.gh.GHSpring;
import com.dataiku.gh.cli.CLICommandWithInvalidateCommonFilesCache;
import com.dataiku.gh.cli.DKU;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.dao.impl.FilesBasedUsersDAO;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class SetUserPasswordCommand
extends CLICommandWithInvalidateCommonFilesCache {
    @Override
    public String usageString() {
        return "user-set-password LOGIN PASSWORD";
    }

    @Override
    public String description() {
        return "Sets the password of a user";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdLine = this.parseAndMiniSetup(args, "user-set-password", true);
        if (cmdLine.getArgs().length < 3) {
            return this.usage(1, "Missing argument");
        }
        GHSpring.doCLISetup();
        try (RWTransaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).beginWriteAsDSS();){
            FilesBasedUsersDAO ud = new FilesBasedUsersDAO();
            String login = cmdLine.getArgs()[1];
            String password = cmdLine.getArgs()[2];
            UsersDAO.User user = ud.getOrNull(login);
            user.setSecurePassword(password);
            System.out.println(user.checkPassword(password));
            ud.saveUser(user);
            t.commit("CLI: Changed password of " + user.login);
            int n = 0;
            return n;
        }
    }
}

