/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.context;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.base.Stopwatch;
import java.sql.Connection;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.sql.DataSource;
import org.postgresql.core.BaseConnection;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class TransactionLogContext {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.context.db-transaction");
    private static final ThreadLocal<Deque<NewTransactionLogContextContainer>> contextQueue = ThreadLocal.withInitial(ArrayDeque::new);

    private static String getConnectionId() {
        String transactionId = SecretKeyGenerator.generateSmall();
        try {
            DataSource dataSource = (DataSource)SpringUtils.getBean(DataSource.class);
            Connection connection = (Connection)DataSourceUtils.getConnection((DataSource)dataSource).unwrap(BaseConnection.class);
            return connection.toString() + "-" + transactionId;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to get the connection id", (Throwable)e);
            return "unknown_connection-" + transactionId;
        }
    }

    public static TransactionLogContextContainer newTransactionOrKeepExisting(boolean isReadOnly) {
        NewTransactionLogContextContainer currentContext = contextQueue.get().peek();
        if (currentContext != null) {
            return new NestedTransactionLogContextContainer();
        }
        return TransactionLogContext.newTransaction(isReadOnly);
    }

    public static TransactionLogContextContainer newTransaction(boolean isReadOnly) {
        NewTransactionLogContextContainer context = new NewTransactionLogContextContainer(isReadOnly);
        contextQueue.get().push(context);
        return context;
    }

    private static class NewTransactionLogContextContainer
    implements TransactionLogContextContainer {
        public final boolean isReadOnly;
        private final String connectionId;
        private final Stopwatch stopwatch;

        public NewTransactionLogContextContainer(boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
            String transactionType = this.isReadOnly ? "Read only" : "Write";
            this.stopwatch = Stopwatch.createStarted();
            this.connectionId = TransactionLogContext.getConnectionId();
            logger.debug(() -> String.format("[%s] %s transaction started", this.connectionId, transactionType));
        }

        @Override
        public void close() {
            String transactionType = this.isReadOnly ? "Read only" : "Write";
            logger.debug(() -> String.format("[%s] %s transaction finished and lasted %s ms", this.connectionId, transactionType, this.stopwatch.elapsed().toMillis()));
            Deque<NewTransactionLogContextContainer> queue = contextQueue.get();
            if (!queue.isEmpty()) {
                queue.pop();
            }
            if (queue.isEmpty()) {
                contextQueue.remove();
            }
        }
    }

    private static class NestedTransactionLogContextContainer
    implements TransactionLogContextContainer {
        private NestedTransactionLogContextContainer() {
        }

        @Override
        public void close() {
        }
    }

    public static interface TransactionLogContextContainer
    extends AutoCloseable {
        @Override
        public void close();
    }
}

