/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.context;

import com.dataiku.gh.core.context.TransactionLogContext;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=0x7FFFFFFF)
public class TransactionLogContextAspect {
    @Around(value="execution(* *(..)) && @annotation(ghReadonlyTransaction)", argNames="pjp,ghReadonlyTransaction")
    public Object onReadOnlyTransaction(ProceedingJoinPoint pjp, GHReadonlyTransaction ghReadonlyTransaction) throws Throwable {
        try (TransactionLogContext.TransactionLogContextContainer transactionLogContextContainer = TransactionLogContext.newTransactionOrKeepExisting(true);){
            Object object = pjp.proceed();
            return object;
        }
    }

    @Around(value="execution(* *(..)) && @annotation(ghWriteTransaction)", argNames="pjp,ghWriteTransaction")
    public Object onWriteTransaction(ProceedingJoinPoint pjp, GHWriteTransaction ghWriteTransaction) throws Throwable {
        try (TransactionLogContext.TransactionLogContextContainer transactionLogContextContainer = TransactionLogContext.newTransactionOrKeepExisting(false);){
            Object object = pjp.proceed();
            return object;
        }
    }
}

