/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.security.UserUsersContainer;
import com.dataiku.gh.core.models.signoff.Signoff;
import com.dataiku.gh.core.models.signoff.SignoffApproval;
import com.dataiku.gh.core.models.signoff.SignoffDetails;
import com.dataiku.gh.core.models.signoff.SignoffFeedback;
import com.dataiku.gh.core.models.signoff.SignoffId;
import com.dataiku.gh.core.models.signoff.SignoffRecurrenceConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffUserAndGroupId;
import com.dataiku.gh.core.models.signoff.search.SignoffSearchQuery;
import com.dataiku.gh.core.models.ui.UISignoffApprovalData;
import com.dataiku.gh.core.models.ui.UISignoffFeedbackData;
import com.dataiku.gh.core.models.ui.UISignoffSearchResults;
import com.dataiku.gh.core.services.signoff.ISignoffsService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SignoffsController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ISignoffsService signoffsService;

    @AuditedCall(value={"msgType", "signoff-get-details", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/api/signoffs/get-details"}, method={RequestMethod.GET})
    @ResponseBody
    public SignoffDetails getSignoffDetails(HttpServletRequest req, @RequestParam String artifactId, @RequestParam String stepId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.signoffsService.getSignoffDetails(authCtx, SignoffId.build(artifactId, stepId));
    }

    @AuditedCall(value={"msgType", "signoff-create", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/api/signoffs/create"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SIGNOFF_CREATE)
    @ResponseBody
    public Signoff createSignoff(HttpServletRequest req, @RequestParam String artifactId, @RequestParam String stepId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.signoffsService.createSignoff(authCtx, SignoffId.build(artifactId, stepId));
    }

    @AuditedCall(value={"msgType", "signoff-add-feedback", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/api/signoffs/add-feedback"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SIGNOFF_ADD_FEEDBACK)
    @ResponseBody
    public SignoffFeedback addFeedback(HttpServletRequest req, @RequestParam String artifactId, @RequestParam String stepId, @RequestParam String groupId, @RequestParam UISignoffFeedbackData feedback) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.signoffsService.addFeedback(authCtx, SignoffId.build(artifactId, stepId), groupId, feedback);
    }

    @AuditedCall(value={"msgType", "signoff-edit-feedback", "artifactId", "${artifactId}", "stepId", "${stepId}", "feedbackId", "${feedbackId}"})
    @RequestMapping(value={"/api/signoffs/edit-feedback"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SIGNOFF_EDIT_FEEDBACK)
    @ResponseBody
    public SignoffFeedback editFeedback(HttpServletRequest req, @RequestParam String artifactId, @RequestParam String stepId, @RequestParam String feedbackId, @RequestParam UISignoffFeedbackData feedback) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.signoffsService.editFeedback(authCtx, SignoffId.build(artifactId, stepId), feedbackId, feedback);
    }

    @AuditedCall(value={"msgType", "signoff-delete-feedback", "artifactId", "${artifactId}", "stepId", "${stepId}", "feedbackId", "${feedbackId}"})
    @RequestMapping(value={"/api/signoffs/delete-feedback"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.SIGNOFF_DELETE_FEEDBACK)
    @ResponseBody
    public void deleteFeedback(HttpServletRequest req, @RequestParam String artifactId, @RequestParam String stepId, @RequestParam String feedbackId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.signoffsService.deleteFeedback(authCtx, SignoffId.build(artifactId, stepId), feedbackId);
    }

    @AuditedCall(value={"msgType", "signoff-delegate-feedback", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/api/signoffs/delegate-feedback"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SIGNOFF_DELEGATE_FEEDBACK)
    @ResponseBody
    public Signoff delegateFeedback(HttpServletRequest req, @RequestParam String artifactId, @RequestParam String stepId, @RequestParam String groupId, @RequestParam UserUsersContainer delegatedUser) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.signoffsService.delegateFeedback(authCtx, SignoffId.build(artifactId, stepId), groupId, delegatedUser);
    }

    @AuditedCall(value={"msgType", "signoff-add-approval", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/api/signoffs/add-approval"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SIGNOFF_ADD_APPROVAL)
    @ResponseBody
    public SignoffApproval addApproval(HttpServletRequest req, @RequestParam String artifactId, @RequestParam String stepId, @RequestParam UISignoffApprovalData approval) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.signoffsService.addApproval(authCtx, SignoffId.build(artifactId, stepId), approval);
    }

    @AuditedCall(value={"msgType", "signoff-edit-approval", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/api/signoffs/edit-approval"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SIGNOFF_EDIT_APPROVAL)
    @ResponseBody
    public SignoffApproval editApproval(HttpServletRequest req, @RequestParam String artifactId, @RequestParam String stepId, @RequestParam UISignoffApprovalData approval) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.signoffsService.editApproval(authCtx, SignoffId.build(artifactId, stepId), approval);
    }

    @AuditedCall(value={"msgType", "signoff-delete-approval", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/api/signoffs/delete-approval"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.SIGNOFF_DELETE_APPROVAL)
    @ResponseBody
    public void deleteApproval(HttpServletRequest req, @RequestParam String artifactId, @RequestParam String stepId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.signoffsService.deleteApproval(authCtx, SignoffId.build(artifactId, stepId));
    }

    @AuditedCall(value={"msgType", "signoff-delegate-approval", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/api/signoffs/delegate-approval"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SIGNOFF_DELEGATE_APPROVAL)
    @ResponseBody
    public Signoff delegateApproval(HttpServletRequest req, @RequestParam String artifactId, @RequestParam String stepId, @RequestParam UserUsersContainer delegatedUser) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.signoffsService.delegateApproval(authCtx, SignoffId.build(artifactId, stepId), delegatedUser);
    }

    @AuditedCall(value={"msgType", "signoff-update-status", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/api/signoffs/update-status"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SIGNOFF_UPDATE_STATUS)
    @ResponseBody
    @Nullable
    public Signoff updateStatus(HttpServletRequest req, @RequestParam String artifactId, @RequestParam String stepId, @RequestParam Signoff.SignoffStatus status, @RequestParam(required=false) Set<SignoffUserAndGroupId> usersToSendEmailTo, @RequestParam(required=false) Boolean reloadConfForReset) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.signoffsService.updateStatus(authCtx, SignoffId.build(artifactId, stepId), status, usersToSendEmailTo, reloadConfForReset);
    }

    @AuditedCall(value={"msgType", "signoff-schedule-reset", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/api/signoffs/schedule-reset"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SIGNOFF_SCHEDULE_RESET)
    @ResponseBody
    public Signoff scheduleReset(HttpServletRequest req, @RequestParam String artifactId, @RequestParam String stepId, @RequestParam SignoffRecurrenceConfiguration signoffRecurrenceConfiguration) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.signoffsService.scheduleReset(authCtx, SignoffId.build(artifactId, stepId), signoffRecurrenceConfiguration);
    }

    @AuditedCall(value={"msgType", "signoff-steps-configurations", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/api/signoffs/get-steps-configurations"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getStepsWithSignoffConfiguration(HttpServletRequest req, @RequestParam String artifactId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.signoffsService.getStepsWithSignoffConfiguration(authCtx, artifactId);
    }

    @AuditedCall(value={"msgType", "signoffs-search-for-user"})
    @RequestMapping(value={"/api/signoffs/search-for-user"}, method={RequestMethod.POST})
    @ResponseBody
    public UISignoffSearchResults searchUserSignoffs(HttpServletRequest req, @RequestParam SignoffSearchQuery signoffSearchQuery) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.signoffsService.searchUserSignoffs(authCtx, signoffSearchQuery);
    }
}

