/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.blueprints;

import com.dataiku.dip.logging.LoggableAPIResource;
import com.dataiku.gh.core.models.blueprints.Action;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.blueprints.LogicalHook;
import com.dataiku.gh.core.models.blueprints.WorkflowDefinition;
import com.dataiku.gh.core.models.blueprints.ui.UIDefinition;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.visitors.IBlueprintVersionVisitor;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@UIModel
public class BlueprintVersion
implements LoggableAPIResource {
    public BlueprintVersionId id;
    @UINullable
    public String name;
    public Map<String, FieldDefinition> fieldDefinitions = new HashMap<String, FieldDefinition>();
    public WorkflowDefinition workflowDefinition = new WorkflowDefinition();
    public List<LogicalHook> logicalHookList = new ArrayList<LogicalHook>();
    public Map<String, Action> actions = new HashMap<String, Action>();
    @UINullable
    public String hierarchicalParentFieldId;
    public UIDefinition uiDefinition = new UIDefinition();
    @UINullable
    public String instructions;
    @UINullable
    public IconMode iconMode = IconMode.INHERIT;
    @Nullable
    public String icon;
    @Nullable
    public String color;
    @Nullable
    public String backgroundColor;

    public void accept(IBlueprintVersionVisitor blueprintVersionVisitor) {
        this.id.accept(blueprintVersionVisitor);
        this.fieldDefinitions.forEach((fieldId, fieldDefinition) -> fieldDefinition.accept(blueprintVersionVisitor, (String)fieldId));
        this.workflowDefinition.accept(blueprintVersionVisitor);
        this.actions.values().forEach(action -> action.accept(blueprintVersionVisitor));
        this.logicalHookList.forEach(hook -> hook.accept(blueprintVersionVisitor));
        this.uiDefinition.accept(blueprintVersionVisitor);
        blueprintVersionVisitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlueprintVersion that = (BlueprintVersion)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.fieldDefinitions, that.fieldDefinitions) && Objects.equals(this.workflowDefinition, that.workflowDefinition) && Objects.equals(this.logicalHookList, that.logicalHookList) && Objects.equals(this.actions, that.actions) && Objects.equals(this.hierarchicalParentFieldId, that.hierarchicalParentFieldId) && Objects.equals(this.uiDefinition, that.uiDefinition) && Objects.equals(this.instructions, that.instructions) && Objects.equals((Object)this.iconMode, (Object)that.iconMode) && Objects.equals(this.icon, that.icon) && Objects.equals(this.color, that.color) && Objects.equals(this.backgroundColor, that.backgroundColor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.fieldDefinitions, this.workflowDefinition, this.logicalHookList, this.actions, this.hierarchicalParentFieldId, this.uiDefinition, this.instructions, this.iconMode, this.icon, this.color, this.backgroundColor});
    }

    public Map<String, Object> getLoggableIdentifiers() {
        return Collections.singletonMap("id", this.id);
    }

    public void updateIconSettings(@Nullable IconSettings iconSettings) {
        if (iconSettings != null) {
            this.iconMode = iconSettings.iconMode;
            this.icon = iconSettings.icon;
            this.color = iconSettings.color;
            this.backgroundColor = iconSettings.backgroundColor;
        } else {
            this.iconMode = IconMode.INHERIT;
            this.icon = null;
            this.color = null;
            this.backgroundColor = null;
        }
    }

    public static BlueprintVersion build(BlueprintVersionId blueprintVersionId, String name, @Nullable IconSettings iconSettings) {
        BlueprintVersion blueprintVersion = new BlueprintVersion();
        blueprintVersion.id = blueprintVersionId;
        blueprintVersion.name = name;
        blueprintVersion.updateIconSettings(iconSettings);
        return blueprintVersion;
    }

    public static BlueprintVersion build(BlueprintVersionId id, @Nullable String name, Map<String, FieldDefinition> fieldDefinitions, WorkflowDefinition workflowDefinition, @Nullable List<LogicalHook> logicalHookList, @Nullable Map<String, Action> actions, @Nullable String hierarchicalParentFieldId, UIDefinition uiDefinition, @Nullable String instructions, @Nullable IconSettings iconSettings) {
        BlueprintVersion blueprintVersion = BlueprintVersion.build(id, name, iconSettings);
        blueprintVersion.fieldDefinitions = fieldDefinitions;
        blueprintVersion.workflowDefinition = workflowDefinition;
        blueprintVersion.logicalHookList.addAll(logicalHookList != null ? logicalHookList : Collections.emptyList());
        blueprintVersion.actions.putAll(actions != null ? actions : Collections.emptyMap());
        blueprintVersion.hierarchicalParentFieldId = hierarchicalParentFieldId;
        blueprintVersion.uiDefinition = uiDefinition;
        blueprintVersion.instructions = instructions;
        return blueprintVersion;
    }

    public static enum IconMode {
        ICON,
        INHERIT;

    }

    @UIModel
    public static class IconSettings {
        public final IconMode iconMode;
        public final String icon;
        public final String color;
        public final String backgroundColor;

        public IconSettings(IconMode iconMode, String icon, String color, String backgroundColor) {
            this.iconMode = iconMode;
            this.icon = icon;
            this.color = color;
            this.backgroundColor = backgroundColor;
        }
    }
}

