/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.governance;

import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.governance.GovernanceResult;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class GovernanceResultContainer {
    @Nullable
    public GovernanceResult project;
    public List<GovernanceResult> bundles = new ArrayList<GovernanceResult>();
    public List<GovernanceResult> models = new ArrayList<GovernanceResult>();
    public List<GovernanceResult> modelVersions = new ArrayList<GovernanceResult>();
    public List<GovernanceResult> unknown = new ArrayList<GovernanceResult>();

    public void add(@Nullable BlueprintVersionId blueprintVersionId, GovernanceResult governanceResult) {
        if (blueprintVersionId == null) {
            this.unknown.add(governanceResult);
        } else if (SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(blueprintVersionId)) {
            this.project = governanceResult;
        } else if (SystemProvidedConstants.DATAIKU_BUNDLE.matchBlueprint(blueprintVersionId)) {
            this.bundles.add(governanceResult);
        } else if (SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(blueprintVersionId)) {
            this.models.add(governanceResult);
        } else if (SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.matchBlueprint(blueprintVersionId)) {
            this.modelVersions.add(governanceResult);
        }
    }

    public void mergeWith(GovernanceResultContainer other) {
        if (this.project == null) {
            this.project = other.project;
        }
        this.bundles.addAll(other.bundles);
        this.models.addAll(other.models);
        this.modelVersions.addAll(other.modelVersions);
        this.unknown.addAll(other.unknown);
    }

    public String toString() {
        return "GovernanceResultContainer{project=" + String.valueOf(this.project) + ", bundles=" + String.valueOf(this.bundles) + ", models=" + String.valueOf(this.models) + ", modelVersions=" + String.valueOf(this.modelVersions) + ", unknown=" + String.valueOf(this.unknown) + "}";
    }
}

