/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.signoff;

import com.dataiku.gh.core.services.signoff.SignoffUtils;
import com.dataiku.gh.core.utils.DateUtils;
import com.dataiku.gh.core.visitors.ISignoffVisitor;
import com.dataiku.j2ts.annotations.UINullable;
import java.util.Objects;
import java.util.Set;

public class SignoffFeedback {
    public String id;
    public String groupId;
    public String user;
    public SignoffFeedbackStatus status;
    public String creationDate;
    @UINullable
    public String editionDate;
    @UINullable
    public String comment;

    public void updateCommentAndStatus(String comment, SignoffFeedbackStatus status) {
        this.editionDate = DateUtils.now();
        this.comment = comment;
        this.status = status;
    }

    public void accept(ISignoffVisitor visitor) {
        visitor.visit(this);
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignoffFeedback that = (SignoffFeedback)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.user, that.user) && this.status == that.status && Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.editionDate, that.editionDate) && Objects.equals(this.comment, that.comment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.groupId, this.user, this.status, this.creationDate, this.editionDate, this.comment});
    }

    public static SignoffFeedback build(Set<String> usedUUIDs, String groupId, String user, String comment, SignoffFeedbackStatus status) {
        SignoffFeedback feedback = new SignoffFeedback();
        feedback.id = SignoffUtils.generateFeedbackId(usedUUIDs);
        feedback.creationDate = DateUtils.now();
        feedback.editionDate = null;
        feedback.groupId = groupId;
        feedback.user = user;
        feedback.comment = comment;
        feedback.status = status;
        return feedback;
    }

    public static enum SignoffFeedbackStatus {
        APPROVED,
        MINOR_ISSUE,
        MAJOR_ISSUE;

    }
}

