/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.ui;

import com.dataiku.j2ts.annotations.UIModel;
import java.util.Objects;

@UIModel
public class UIDiff {
    public final String path;
    public final Object oldValue;
    public final Object newValue;

    public UIDiff(DiffPath diffPath, Object oldValue, Object newValue) {
        this.path = diffPath.path;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public UIDiff(ComputedPathWithSuffixOrPrefix diffPath, Object oldValue, Object newValue) {
        this.path = diffPath.path;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public String toString() {
        return "UIDiff{newValue=" + String.valueOf(this.newValue) + ", path='" + this.path + "', oldValue=" + String.valueOf(this.oldValue) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UIDiff uiDiff = (UIDiff)o;
        return Objects.equals(this.path, uiDiff.path) && Objects.equals(this.oldValue, uiDiff.oldValue) && Objects.equals(this.newValue, uiDiff.newValue);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.oldValue, this.newValue);
    }

    @UIModel
    public static enum DiffPath {
        ATTACHMENT_FILES("artifact.attachments.files"),
        ATTACHMENT_REFERENCES("artifact.attachments.references"),
        ARTIFACT_FIELD_PREFIX("artifact.field."),
        ARTIFACT_NAME("artifact.name"),
        ARTIFACT_WORKFLOW_PREFIX("artifact.workflow.steps."),
        ARTIFACT_WORKFLOW_ARCHIVED("artifact.status.archived"),
        ARTIFACT_BLUEPRINTVERSION_VERSION("artifact.blueprintVersionId.versionId"),
        BLUEPRINTVERSION_FIELD_DEFINITIONS("blueprintVersion.fieldDefinitions"),
        BLUEPRINTVERSION_STEP_DEFINITIONS("blueprintVersion.workflowDefinition.stepDefinitions"),
        SIGNOFF_PREFIX("artifactSignoffs.signoffs."),
        SIGNOFF_STATUS_SUFFIX(".status"),
        SIGNOFF_CONFIGURATION_APPROVERS_SUFFIX(".configuration.approvers"),
        SIGNOFF_CONFIGURATION_FEEDBACK_USERSGROUPS_SUFFIX(".configuration.feedbackUsersGroups"),
        SIGNOFF_APPROVER_RESPONSE_SUFFIX(".approverResponse"),
        SIGNOFF_FEEDBACK_RESPONSE_SUFFIX(".feedbackResponses"),
        SIGNOFF_RECURRENCE_CONFIGURATION_SUFFIX(".configuration.recurrenceConfiguration");

        protected final String path;

        private DiffPath(String path) {
            this.path = path;
        }

        public ComputedPathWithSuffixOrPrefix withPrefix(String prefix) {
            return new ComputedPathWithSuffixOrPrefix(prefix + this.path);
        }

        public ComputedPathWithSuffixOrPrefix withSuffix(String suffix) {
            return new ComputedPathWithSuffixOrPrefix(this.path + suffix);
        }

        public String toString() {
            return this.path;
        }
    }

    public static class ComputedPathWithSuffixOrPrefix {
        public final String path;

        public ComputedPathWithSuffixOrPrefix(String path) {
            this.path = path;
        }
    }
}

