/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.gh.core.services.roles_and_permissions.roles.IRolesService;
import com.dataiku.gh.security.auth.MetaAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PublicAPIRolesController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IRolesService rolesService;

    @AuditedCall(value={"msgType", "roles-list"})
    @RequestMapping(value={"/publicapi/roles"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        PublicAPIRolesController.writeJSON((HttpServletResponse)resp, this.rolesService.listRoles(authCtx));
    }

    @AuditedCall(value={"msgType", "role-get", "roleId", "${roleId}"})
    @RequestMapping(value={"/publicapi/role/{roleId}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String roleId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        PublicAPIRolesController.writeJSON((HttpServletResponse)resp, (Object)this.rolesService.getRole(authCtx, roleId));
    }
}

