/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.admin;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.admin.MigrationFile;
import com.dataiku.gh.core.services.admin.IMigrationService;
import com.dataiku.gh.core.services.admin.migrations.Migration;
import com.dataiku.gh.core.services.admin.migrations.MigrationV10000;
import com.dataiku.gh.core.services.admin.migrations.MigrationV10060;
import com.dataiku.gh.core.services.admin.migrations.MigrationV11000;
import com.dataiku.gh.core.services.admin.migrations.MigrationV11200;
import com.dataiku.gh.core.services.admin.migrations.MigrationV12000;
import com.dataiku.gh.core.services.admin.migrations.MigrationV12100;
import com.dataiku.gh.core.services.admin.migrations.MigrationV12200;
import com.dataiku.gh.core.services.admin.migrations.MigrationV12400;
import com.dataiku.gh.core.services.admin.migrations.MigrationV12500;
import com.dataiku.gh.core.services.admin.migrations.MigrationV12600;
import com.dataiku.gh.core.services.admin.migrations.MigrationV13000;
import com.dataiku.gh.core.services.admin.migrations.MigrationV13100;
import com.dataiku.gh.core.services.admin.migrations.MigrationV13200;
import com.dataiku.gh.core.services.admin.migrations.MigrationV13300;
import com.dataiku.gh.core.services.admin.migrations.MigrationV13400;
import com.dataiku.gh.core.services.admin.migrations.MigrationV13500;
import com.dataiku.gh.core.services.admin.migrations.MigrationV14000;
import com.dataiku.gh.core.services.admin.migrations.MigrationV14100;
import com.dataiku.gh.core.services.admin.migrations.MigrationV14200;
import com.dataiku.gh.core.services.admin.migrations.MigrationV14300;
import com.dataiku.gh.core.services.admin.migrations.MigrationV14400;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.utils.TransactionUtils;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;

@Service
public class MigrationService
implements IMigrationService {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.admin.migration");
    public static final String MIGRATIONS_BASE_DIR = "govern/migrations";
    public static final String PROVIDED_SYSTEM_OBJECTS_DIR = "system";
    public static final String SQL_DIR = "sql";
    public static final String SQL_FINALLY_DIR = "sql/finally";
    private static final Map<Long, Migration> JAVA_MIGRATIONS = Stream.of(Pair.of((Object)10000L, (Object)new MigrationV10000()), Pair.of((Object)10060L, (Object)new MigrationV10060()), Pair.of((Object)11000L, (Object)new MigrationV11000()), Pair.of((Object)11200L, (Object)new MigrationV11200()), Pair.of((Object)12000L, (Object)new MigrationV12000()), Pair.of((Object)12100L, (Object)new MigrationV12100()), Pair.of((Object)12200L, (Object)new MigrationV12200()), Pair.of((Object)12400L, (Object)new MigrationV12400()), Pair.of((Object)12500L, (Object)new MigrationV12500()), Pair.of((Object)12600L, (Object)new MigrationV12600()), Pair.of((Object)13000L, (Object)new MigrationV13000()), Pair.of((Object)13100L, (Object)new MigrationV13100()), Pair.of((Object)13200L, (Object)new MigrationV13200()), Pair.of((Object)13300L, (Object)new MigrationV13300()), Pair.of((Object)13400L, (Object)new MigrationV13400()), Pair.of((Object)13500L, (Object)new MigrationV13500()), Pair.of((Object)14000L, (Object)new MigrationV14000()), Pair.of((Object)14100L, (Object)new MigrationV14100()), Pair.of((Object)14200L, (Object)new MigrationV14200()), Pair.of((Object)14300L, (Object)new MigrationV14300()), Pair.of((Object)14400L, (Object)new MigrationV14400())).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    @Autowired
    private IDBMigrationDAO dbMigrationDAO;

    @Override
    public void checkCurrentSchemaVersion() throws IOException {
        long versionToCheck = Long.parseLong(DKUApp.getDSSVersion().conf_version);
        this.checkCurrentSchemaVersion(versionToCheck);
    }

    @Override
    public void checkCurrentSchemaVersion(long versionToCheck) throws IOException {
        long lastCompatibleVersionToCheck = this.getLastCompatibleVersion(versionToCheck);
        Long currentSchemaVersion = this.dbMigrationDAO.getSchemaVersion();
        if (currentSchemaVersion == null) {
            throw new IOException("The database has not been initialized for Dataiku Govern");
        }
        long lastCompatibleCurrentSchemaVersion = this.getLastCompatibleVersion(currentSchemaVersion);
        if (lastCompatibleVersionToCheck != lastCompatibleCurrentSchemaVersion) {
            throw new IOException("The actual schema version (" + currentSchemaVersion + ") in the DB is not supported by the current version of Dataiku Govern backend (" + versionToCheck + ")");
        }
    }

    private long getLastCompatibleVersion(long confVersion) {
        return JAVA_MIGRATIONS.keySet().stream().filter(migVersion -> migVersion <= confVersion).max(Long::compare).orElseThrow(() -> new ValidationException("Can't find a valid Govern Version for confVersion=" + confVersion));
    }

    @Override
    public void checkNoneVersion() throws IOException {
        Long currentSchemaVersion = this.dbMigrationDAO.getSchemaVersion();
        if (currentSchemaVersion != null) {
            throw new IOException("The schema version is not none (version found = " + currentSchemaVersion + ")");
        }
    }

    @Override
    @GHWriteTransaction
    public Long migrateToVersion(Long targetVersion, PlatformTransactionManager transactionManager) throws IOException {
        logger.info((Object)("Current database version is: " + this.dbMigrationDAO.getDatabaseVersion()));
        Long currentVersion = Optional.ofNullable(this.dbMigrationDAO.getSchemaVersion()).orElse(0L);
        logger.info((Object)("Current database schema version is " + currentVersion));
        if (currentVersion > targetVersion) {
            throw new ValidationException(String.format("Current database version (%s) is newer than the kit version (%s)", currentVersion, targetVersion));
        }
        if (currentVersion.equals(targetVersion)) {
            logger.info((Object)"Current database schema is already up to date");
            return currentVersion;
        }
        List allVersionsToApply = JAVA_MIGRATIONS.keySet().stream().filter(version -> version > currentVersion && version <= targetVersion).distinct().sorted(Long::compareTo).collect(Collectors.toList());
        logger.info((Object)String.format("Migration to apply are, in order : %s", allVersionsToApply));
        boolean shouldPerformDbOptimizationAtEnd = false;
        for (Long versionToApply : allVersionsToApply) {
            Migration javaMigration = JAVA_MIGRATIONS.get(versionToApply);
            List<MigrationFile> sqlMigrationFiles = this.findSQLMigrationsIn(DKUApp.getResourceFile((String[])new String[]{MIGRATIONS_BASE_DIR, "V" + versionToApply, SQL_DIR}));
            List<MigrationFile> sqlFinallyMigrationFiles = this.findSQLMigrationsIn(DKUApp.getResourceFile((String[])new String[]{MIGRATIONS_BASE_DIR, "V" + versionToApply, SQL_FINALLY_DIR}));
            File providedObjectsFolder = DKUApp.getResourceFile((String[])new String[]{MIGRATIONS_BASE_DIR, "V" + versionToApply, PROVIDED_SYSTEM_OBJECTS_DIR});
            logger.info((Object)String.format("Running migration %s with sql files %s", versionToApply, sqlMigrationFiles));
            javaMigration.execute(this.dbMigrationDAO, sqlMigrationFiles, sqlFinallyMigrationFiles, providedObjectsFolder);
            shouldPerformDbOptimizationAtEnd |= javaMigration.shouldPerformDbOptimizationAfterMigration();
        }
        if (shouldPerformDbOptimizationAtEnd) {
            TransactionUtils.executeAfterCommitWithinNewTransaction(transactionManager, () -> {
                try {
                    logger.infoV("Running 'ANALYZE' command after updating database schema version to %s", new Object[]{targetVersion});
                    this.dbMigrationDAO.executeAnalyze();
                }
                catch (Throwable e) {
                    logger.warnV(e, "Unable to run 'ANALYZE' after the migration to %s. You should consider running this command if you are experiencing slow queries", new Object[]{targetVersion});
                }
            });
        }
        logger.info((Object)("Updating database schema version to " + targetVersion));
        this.dbMigrationDAO.setSchemaVersion(targetVersion);
        logger.info((Object)("Successfully updated database schema version to " + targetVersion));
        return targetVersion;
    }

    private List<MigrationFile> findSQLMigrationsIn(File sqlFolder) {
        if (!sqlFolder.exists()) {
            return Collections.emptyList();
        }
        File[] sqlFiles = sqlFolder.listFiles(File::isFile);
        if (sqlFiles == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(sqlFiles).map(file -> {
            MigrationFile migrationFile = MigrationFile.parseOrNull(file);
            if (migrationFile == null) {
                logger.warn((Object)String.format("File '%s' doesn't match expected migration naming pattern, file ignored", file.getName()));
            }
            return migrationFile;
        }).filter(Objects::nonNull).sorted(Comparator.comparing(migrationFile -> migrationFile.order)).collect(Collectors.toList());
    }
}

