/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.admin.migrations;

import com.dataiku.gh.core.models.admin.MigrationFile;
import com.dataiku.gh.core.services.admin.migrations.Migration;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationEntitiesUtilsBetweenV0AndV10999;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationJsonUtils;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class MigrationV10060
extends Migration {
    private static final String SETTINGS_OLD_ATTR = "artifactTableSettings";
    private static final String SETTINGS_NEW_ATTR = "artifactSearchSettings";
    private static final String SOURCE_OLD_ATTR = "artifactTableSource";
    private static final String SOURCE_NEW_ATTR = "artifactSearchSource";

    @Override
    public void postRunSQLFiles(IDBMigrationDAO dbMigrationDAO, List<MigrationFile> migrationFiles) throws IOException {
        MigrationEntitiesUtilsBetweenV0AndV10999.migrateObjects(dbMigrationDAO.getJdbcTemplate(), "custom_pages", "custom_page_id", "custom_page_json", MigrationV10060::migrateCustomPage, cp -> cp.get("id").getAsString());
    }

    @VisibleForTesting
    protected static JsonObject migrateCustomPage(JsonObject customPage) {
        Optional<JsonElement> source;
        String type = MigrationJsonUtils.getStringSubpath((JsonElement)customPage, "type").orElse("");
        Optional<Object> settings = Optional.empty();
        if ("artifact-table".equals(type)) {
            settings = MigrationJsonUtils.getObjectSubpath((JsonElement)customPage, SETTINGS_OLD_ATTR);
            if (settings.isPresent()) {
                customPage.remove(SETTINGS_OLD_ATTR);
                customPage.add(SETTINGS_NEW_ATTR, (JsonElement)settings.get());
            }
        } else if ("artifact-matrix".equals(type)) {
            Optional<JsonObject> matrixSettings = MigrationJsonUtils.getObjectSubpath((JsonElement)customPage, "artifactMatrixSettings");
            settings = MigrationJsonUtils.getObjectSubpath(matrixSettings.orElse(null), SETTINGS_OLD_ATTR);
            if (matrixSettings.isPresent() && settings.isPresent()) {
                matrixSettings.get().remove(SETTINGS_OLD_ATTR);
                matrixSettings.get().add(SETTINGS_NEW_ATTR, (JsonElement)settings.get());
            }
        }
        if (settings.isPresent() && (source = MigrationJsonUtils.getSubpath((JsonElement)settings.get(), SOURCE_OLD_ATTR)).isPresent()) {
            ((JsonObject)settings.get()).remove(SOURCE_OLD_ATTR);
            ((JsonObject)settings.get()).add(SOURCE_NEW_ATTR, source.get());
        }
        return customPage;
    }

    @Override
    public boolean shouldPerformDbOptimizationAfterMigration() {
        return false;
    }
}

