/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.admin.migrations;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.services.admin.migrations.Migration;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationEntitiesUtilsBetweenV12200AndV13099;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationJsonUtils;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class MigrationV12400
extends Migration {
    @Override
    public void updateProvidedSystemObjects(IDBMigrationDAO dbMigrationDAO, @Nullable File providedObjectsFolder) throws IOException {
        if (providedObjectsFolder == null) {
            throw new ValidationException("Migration " + this.getClass().getSimpleName() + " is expecting a provided object folder");
        }
        this.standardCustomPagesCreation(providedObjectsFolder, dbMigrationDAO);
        long migrationTS = this.getMigrationTimestamp();
        JdbcTemplate jdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        Long actionId = MigrationEntitiesUtilsBetweenV12200AndV13099.createMigrationAction(jdbcTemplate, migrationTS);
        this.customPagesMigration(migrationTS, actionId, dbMigrationDAO);
        this.cleanCustomPageModels(dbMigrationDAO);
        this.cleanReferenceViewComponentModels(dbMigrationDAO);
        MigrationV12400.presubscribeUsers(jdbcTemplate, actionId, migrationTS);
        this.migrateBlueprintRoleAssigments(dbMigrationDAO);
        MigrationEntitiesUtilsBetweenV12200AndV13099.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"api_deployer_infrastructure", "blueprint_version_default.json"}), "bp.system.api_deployer_infrastructure", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV12200AndV13099.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"api_deployer_deployment", "blueprint_version_default.json"}), "bp.system.api_deployer_deployment", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV12200AndV13099.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"project_deployer_infrastructure", "blueprint_version_default.json"}), "bp.system.project_deployer_infrastructure", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV12200AndV13099.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"project_deployer_deployment", "blueprint_version_default.json"}), "bp.system.project_deployer_deployment", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV12200AndV13099.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_bundle", "blueprint_version_default.json"}), "bp.system.dataiku_bundle", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV12200AndV13099.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_saved_model_version", "blueprint_version_default.json"}), "bp.system.dataiku_saved_model_version", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV12200AndV13099.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"govern_project", "blueprint_version_default.json"}), "bp.system.govern_project", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV12200AndV13099.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"business_initiative", "blueprint_version_default.json"}), "bp.system.business_initiative", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV12200AndV13099.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"user", "blueprint_version_default.json"}), "bp.system.user", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV12200AndV13099.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"group", "blueprint_version_default.json"}), "bp.system.group", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV12200AndV13099.fixArtifacts(dbMigrationDAO, "artifacts.artifact_blueprint_id = 'bp.system.govern_project'  AND artifacts.artifact_version_id = 'bv.system.default'", MigrationV12400::migrateStandardGovernProject, actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV12200AndV13099.fixArtifacts(dbMigrationDAO, "artifacts.artifact_blueprint_id = 'bp.system.business_initiative'  AND artifacts.artifact_version_id = 'bv.system.default'", MigrationV12400::migrateStandardBusinessInitiative, actionId, migrationTS);
    }

    protected void standardCustomPagesCreation(File providedObjectsFolder, IDBMigrationDAO dbMigrationDAO) throws IOException {
        Long actionId = MigrationEntitiesUtilsBetweenV12200AndV13099.createFixupMigrationAction(dbMigrationDAO.getJdbcTemplate());
        for (String file : Lists.newArrayList((Object[])new String[]{"governable_items.json", "model_registry.json", "bundle_registry.json", "business_initiatives.json", "governed_projects.json"})) {
            MigrationEntitiesUtilsBetweenV12200AndV13099.upsertCustomPage(dbMigrationDAO.getJdbcTemplate(), DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"custom_page", file}), actionId, MigrationEntitiesUtilsBetweenV12200AndV13099.getMinActionTimestamp(dbMigrationDAO.getJdbcTemplate()));
        }
    }

    protected void customPagesMigration(long migrationTS, long actionId, IDBMigrationDAO dbMigrationDAO) throws IOException {
        JsonObject customPageOrderConfiguration = this.buildCustomPageOrderConfiguration(dbMigrationDAO);
        MigrationEntitiesUtilsBetweenV12200AndV13099.upsertGovernConfiguration(dbMigrationDAO.getJdbcTemplate(), customPageOrderConfiguration, actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV12200AndV13099.migrateObjects(dbMigrationDAO.getJdbcTemplate(), "custom_pages", "custom_page_id = (?)", "custom_page_json", cp -> Collections.singletonList(cp.get("id").getAsString()), MigrationV12400::migrateCustomPage);
        MigrationEntitiesUtilsBetweenV12200AndV13099.migrateObjectsHistory(dbMigrationDAO.getJdbcTemplate(), "custom_pages_history", "custom_page_json", MigrationV12400::migrateCustomPage);
    }

    public static JsonObject migrateCustomPage(JsonObject customPage) {
        customPage.remove("index");
        customPage.addProperty("visible", Boolean.valueOf(true));
        return customPage;
    }

    protected JsonObject buildCustomPageOrderConfiguration(IDBMigrationDAO dbMigrationDAO) throws IOException {
        List<String> order = this.buildCurrentCustomPagesOrder(dbMigrationDAO);
        order.addAll(0, this.buildStandardPagesOrder());
        JsonObject customPageOrderConfiguration = new JsonObject();
        customPageOrderConfiguration.addProperty("type", "custom-page-order");
        JsonArray customPageConfigurationOrder = new JsonArray();
        order.forEach(arg_0 -> ((JsonArray)customPageConfigurationOrder).add(arg_0));
        customPageOrderConfiguration.add("customPageIds", (JsonElement)customPageConfigurationOrder);
        return customPageOrderConfiguration;
    }

    protected List<String> buildCurrentCustomPagesOrder(IDBMigrationDAO dbMigrationDAO) throws IOException {
        try (Stream<JsonObject> customPages = MigrationEntitiesUtilsBetweenV12200AndV13099.streamObjects(dbMigrationDAO.getJdbcTemplate(), "custom_pages", "custom_page_json", null);){
            List<String> list = customPages.filter(jsonObject -> {
                String id = MigrationJsonUtils.getStringSubpath((JsonElement)jsonObject, "id").orElse(null);
                return id != null && !id.startsWith("cp.system.");
            }).sorted(Comparator.comparingInt(o -> {
                if (o.get("index") == null) {
                    return Integer.MAX_VALUE;
                }
                try {
                    o.get("index").getAsInt();
                }
                catch (NumberFormatException nfe) {
                    return Integer.MAX_VALUE;
                }
                return o.get("index").getAsInt();
            })).map(customPage -> customPage.get("id").getAsString()).collect(Collectors.toList());
            return list;
        }
    }

    protected List<String> buildStandardPagesOrder() {
        return Lists.newArrayList((Object[])new String[]{"cp.system.governable-items", "cp.system.model-registry", "cp.system.bundle-registry", "cp.system.business-initiatives", "cp.system.governed-projects"});
    }

    protected static JsonObject migrateStandardGovernProject(JsonObject artifact) {
        Optional<JsonObject> fieldsOpt = MigrationJsonUtils.getObjectSubpath((JsonElement)artifact, "fields");
        if (fieldsOpt.isPresent()) {
            JsonElement qualificationResultingDecision;
            JsonObject fields = fieldsOpt.get();
            fields.remove("business_functions");
            JsonElement useCaseTechnicalDimension = fields.remove("use_case_technical_dimension");
            if (useCaseTechnicalDimension != null) {
                try {
                    String useCaseStr = useCaseTechnicalDimension.getAsString();
                    JsonArray useCasesTechnicalDimension = new JsonArray();
                    useCasesTechnicalDimension.add(useCaseStr);
                    fields.add("use_case_technical_dimension", (JsonElement)useCasesTechnicalDimension);
                }
                catch (Exception useCaseStr) {
                    // empty catch block
                }
            }
            if ((qualificationResultingDecision = fields.remove("qualification_resulting_decision")) != null) {
                try {
                    String qualificationResultingDecisionStr = qualificationResultingDecision.getAsString();
                    fields.addProperty("qualification_resulting_decision", StringUtils.capitalize((String)qualificationResultingDecisionStr));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return artifact;
    }

    protected static JsonObject migrateStandardBusinessInitiative(JsonObject artifact) {
        Optional<JsonObject> statusOpt = MigrationJsonUtils.getObjectSubpath((JsonElement)artifact, "status");
        if (statusOpt.isPresent()) {
            JsonObject status = statusOpt.get();
            status.addProperty("stepId", "ideation");
        }
        return artifact;
    }

    private void cleanCustomPageModels(IDBMigrationDAO dbMigrationDAO) throws IOException {
        MigrationEntitiesUtilsBetweenV12200AndV13099.migrateObjects(dbMigrationDAO.getJdbcTemplate(), "custom_pages", "custom_page_id = (?)", "custom_page_json", cp -> Collections.singletonList(cp.get("id").getAsString()), MigrationV12400::cleanCustomPageModel);
        MigrationEntitiesUtilsBetweenV12200AndV13099.migrateObjectsHistory(dbMigrationDAO.getJdbcTemplate(), "custom_pages_history", "custom_page_json", MigrationV12400::cleanCustomPageModel);
    }

    protected static JsonObject cleanCustomPageModel(JsonObject customPage) {
        String type = MigrationJsonUtils.getStringSubpath((JsonElement)customPage, "type").orElse(null);
        if (type == null) {
            return customPage;
        }
        switch (type) {
            case "artifact-table": {
                JsonElement blueprintIdViewIdPairs;
                JsonObject artifactSearchSettings2 = MigrationJsonUtils.getObjectSubpath((JsonElement)customPage, "artifactSearchSettings").orElse(null);
                if (artifactSearchSettings2 == null || (blueprintIdViewIdPairs = artifactSearchSettings2.remove("blueprintIdViewIdPairs")) == null) break;
                JsonObject artifactTableSettings = MigrationJsonUtils.getObjectSubpath((JsonElement)customPage, "artifactTableSettings").orElse(new JsonObject());
                artifactTableSettings.add("blueprintIdViewIdPairs", blueprintIdViewIdPairs);
                customPage.add("artifactTableSettings", (JsonElement)artifactTableSettings);
                break;
            }
            case "artifact-matrix": {
                JsonObject artifactSearchSettings3 = MigrationJsonUtils.getObjectSubpath((JsonElement)customPage, "artifactMatrixSettings", "artifactSearchSettings").orElse(null);
                if (artifactSearchSettings3 == null) break;
                customPage.getAsJsonObject("artifactMatrixSettings").remove("artifactSearchSettings");
                customPage.add("artifactSearchSettings", (JsonElement)artifactSearchSettings3);
                JsonElement blueprintIdViewIdPairs = artifactSearchSettings3.remove("blueprintIdViewIdPairs");
                if (blueprintIdViewIdPairs == null) break;
                JsonObject artifactTableSettings = MigrationJsonUtils.getObjectSubpath((JsonElement)customPage, "artifactTableSettings").orElse(new JsonObject());
                artifactTableSettings.add("blueprintIdViewIdPairs", blueprintIdViewIdPairs);
                customPage.add("artifactTableSettings", (JsonElement)artifactTableSettings);
                break;
            }
            case "artifact-kanban-view": {
                MigrationJsonUtils.getObjectSubpath((JsonElement)customPage, "artifactSearchSettings").ifPresent(artifactSearchSettings -> artifactSearchSettings.remove("blueprintIdViewIdPairs"));
            }
        }
        return customPage;
    }

    private void cleanReferenceViewComponentModels(IDBMigrationDAO dbMigrationDAO) throws IOException {
        MigrationEntitiesUtilsBetweenV12200AndV13099.migrateObjects(dbMigrationDAO.getJdbcTemplate(), "blueprint_versions", "blueprint_version_blueprint_id=? AND blueprint_version_version_id=?", "blueprint_version_json", bpv -> Arrays.asList(MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "blueprintId").orElse(null), MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "versionId").orElse(null)), MigrationV12400::migrateReferenceViewComponentsFromBPV);
        MigrationEntitiesUtilsBetweenV12200AndV13099.migrateObjectsHistory(dbMigrationDAO.getJdbcTemplate(), "blueprint_versions_history", "blueprint_version_json", MigrationV12400::migrateReferenceViewComponentsFromBPV);
    }

    public static JsonObject migrateReferenceViewComponentsFromBPV(JsonObject bpv) {
        JsonObject views = MigrationJsonUtils.getObjectSubpath((JsonElement)bpv, "uiDefinition", "views").orElse(null);
        if (views == null) {
            return bpv;
        }
        ArrayList<JsonObject> refViewComponents = new ArrayList<JsonObject>();
        for (String key : views.keySet()) {
            JsonObject view = MigrationJsonUtils.getObjectSubpath((JsonElement)views, key).orElse(null);
            if (view == null) continue;
            String viewType = MigrationJsonUtils.getStringSubpath((JsonElement)view, "type").orElse(null);
            if (StringUtils.equals((CharSequence)"card", (CharSequence)viewType)) {
                MigrationJsonUtils.getObjectSubpath((JsonElement)view, "viewComponent").ifPresent(vc -> MigrationV12400.collectRefViewComponents(vc, refViewComponents));
                continue;
            }
            if (!StringUtils.equals((CharSequence)"row", (CharSequence)viewType)) continue;
            MigrationV12400.collectRefViewComponents(MigrationJsonUtils.getArraySubpath((JsonElement)view, "viewComponents").orElse(new JsonArray()), refViewComponents);
        }
        for (JsonObject refViewComponent : refViewComponents) {
            JsonElement bvip;
            String type = MigrationJsonUtils.getStringSubpath((JsonElement)refViewComponent, "type").orElse(null);
            if (StringUtils.equals((CharSequence)"card-reference-field", (CharSequence)type)) {
                bvip = refViewComponent.remove("blueprintIdViewIdPairs");
                if (bvip == null) continue;
                refViewComponent.add("bigCardViews", bvip);
                continue;
            }
            if (!StringUtils.equals((CharSequence)"table-reference-field", (CharSequence)type) || (bvip = refViewComponent.remove("blueprintIdViewIdPairs")) == null) continue;
            JsonObject artifactTableSettings = MigrationJsonUtils.getObjectSubpath((JsonElement)refViewComponent, "artifactTableSettings").orElse(new JsonObject());
            artifactTableSettings.add("blueprintIdViewIdPairs", bvip);
            refViewComponent.add("artifactTableSettings", (JsonElement)artifactTableSettings);
        }
        return bpv;
    }

    private static void collectRefViewComponents(JsonObject viewComponent, ArrayList<JsonObject> collector) {
        String type = MigrationJsonUtils.getStringSubpath((JsonElement)viewComponent, "type").orElse(null);
        if (StringUtils.equals((CharSequence)"card-reference-field", (CharSequence)type)) {
            collector.add(viewComponent);
        } else if (StringUtils.equals((CharSequence)"table-reference-field", (CharSequence)type)) {
            collector.add(viewComponent);
        } else if (StringUtils.equals((CharSequence)"container", (CharSequence)type)) {
            MigrationJsonUtils.getArraySubpath((JsonElement)viewComponent, "layout", "viewComponents").ifPresent(vcs -> MigrationV12400.collectRefViewComponents(vcs, collector));
        }
    }

    private static void collectRefViewComponents(JsonArray viewComponents, ArrayList<JsonObject> collector) {
        viewComponents.forEach(vc -> {
            if (vc.isJsonObject()) {
                MigrationV12400.collectRefViewComponents((JsonObject)vc, collector);
            }
        });
    }

    private static void presubscribeUsers(JdbcTemplate querydslJdbcTemplate, Long actionId, Long migrationTS) throws IOException {
        String sqlSelectAllSubscribers = "SELECT signoff_artifact_id, user_login\nFROM (\n    (\n        SELECT\n            signoff_artifact_id,\n            jsonb_array_elements(signoff_json->'feedbackResponses')->>'user' AS user_login\n        FROM signoffs\n    )\n    UNION\n    (\n        SELECT\n            signoff_artifact_id,\n            signoff_json->'approverResponse'->>'user' AS user_login\n        FROM signoffs\n    )\n) signoff_users_unfiltered\nWHERE NOT starts_with(user_login, 'api:')";
        String sqlInsert = "INSERT INTO artifact_subscriptions (artifact_subscription_json) VALUES (?::jsonb)";
        String sqlInsertHistory = "INSERT INTO artifact_subscriptions_history (_revision_json, artifact_subscription_json) VALUES (?::jsonb, ?::jsonb)";
        try (Stream subscriptionStream = querydslJdbcTemplate.queryForStream(sqlSelectAllSubscribers, (rs, rowNum) -> new SubscriptionWithHistory(querydslJdbcTemplate, rs.getString("signoff_artifact_id"), rs.getString("user_login"), actionId, migrationTS));){
            Iterators.partition(subscriptionStream.iterator(), (int)100).forEachRemaining(listToInsert -> {
                querydslJdbcTemplate.batchUpdate(sqlInsert, (Collection)listToInsert, 100, (ps, toInsert) -> ps.setString(1, JSON.json((Object)toInsert.entity)));
                querydslJdbcTemplate.batchUpdate(sqlInsertHistory, (Collection)listToInsert, 100, (ps, toInsert) -> {
                    ps.setString(1, toInsert.revision);
                    ps.setString(2, JSON.json((Object)toInsert.entity));
                });
            });
        }
        catch (DataAccessException e) {
            throw new IOException("Cannot reach Govern Database, verify the connection settings", e);
        }
    }

    private void migrateBlueprintRoleAssigments(IDBMigrationDAO dbMigrationDAO) throws IOException {
        MigrationEntitiesUtilsBetweenV12200AndV13099.migrateObjects(dbMigrationDAO.getJdbcTemplate(), "blueprint_role_assignments", "blueprint_role_assignments_blueprint_id = (?)", "blueprint_role_assignments_json", bpra -> Collections.singletonList(bpra.get("blueprintId").getAsString()), MigrationV12400::migrateBlueprintRoleAssignments);
        MigrationEntitiesUtilsBetweenV12200AndV13099.migrateObjectsHistory(dbMigrationDAO.getJdbcTemplate(), "blueprint_role_assignments_history", "blueprint_role_assignments_json", MigrationV12400::migrateBlueprintRoleAssignments);
    }

    public static JsonObject migrateBlueprintRoleAssignments(JsonObject blueprintRoleAssignments) {
        JsonArray inheritBlueprintIds = new JsonArray();
        JsonElement inheritBlueprintId = blueprintRoleAssignments.remove("inheritBlueprintId");
        if (inheritBlueprintId != null && inheritBlueprintId.isJsonPrimitive() && StringUtils.isNotBlank((CharSequence)inheritBlueprintId.getAsString())) {
            inheritBlueprintIds.add(inheritBlueprintId);
        }
        blueprintRoleAssignments.add("inheritBlueprintIds", (JsonElement)inheritBlueprintIds);
        JsonArray inheritArtifactFieldIds = new JsonArray();
        JsonElement inheritArtifactFieldId = blueprintRoleAssignments.remove("inheritArtifactFieldId");
        if (inheritArtifactFieldId != null && inheritArtifactFieldId.isJsonPrimitive() && StringUtils.isNotBlank((CharSequence)inheritArtifactFieldId.getAsString())) {
            inheritArtifactFieldIds.add(inheritArtifactFieldId);
        }
        blueprintRoleAssignments.add("inheritArtifactFieldIds", (JsonElement)inheritArtifactFieldIds);
        return blueprintRoleAssignments;
    }

    private static class SubscriptionWithHistory {
        JsonObject entity;
        String revision;

        SubscriptionWithHistory(JdbcTemplate jdbcTemplate, String artifactId, String userLogin, long actionId, long migrationTS) {
            JsonObject subscriptionId = new JsonObject();
            subscriptionId.addProperty("artifactId", artifactId);
            subscriptionId.addProperty("userLogin", userLogin);
            this.entity = new JsonObject();
            this.entity.add("subscriptionId", (JsonElement)subscriptionId);
            this.entity.addProperty("subscriptionLevel", "YES");
            this.revision = MigrationEntitiesUtilsBetweenV12200AndV13099.buildRevisionObject(jdbcTemplate, actionId, "ADD", "SUBSCRIPTION", migrationTS);
        }
    }
}

