/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.admin.migrations;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.gh.core.services.admin.migrations.Migration;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationEntitiesUtilsBetweenV12200AndV13099;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationJsonUtils;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.springframework.jdbc.core.JdbcTemplate;

public class MigrationV13000
extends Migration {
    private static final String[] BPV_BLUEPRINT_IDS = new String[]{"user", "group", "api_deployer_deployment", "api_deployer_infrastructure", "business_initiative", "dataiku_bundle", "dataiku_dataset", "dataiku_project", "dataiku_saved_model", "dataiku_saved_model_version", "project_deployer_deployment", "project_deployer_infrastructure", "govern_bundle", "govern_dataset", "govern_model", "govern_model_version", "govern_project"};

    @Override
    protected void updateProvidedSystemObjects(IDBMigrationDAO dbMigrationDAO, @Nullable File providedObjectsFolder) throws IOException {
        if (providedObjectsFolder == null) {
            throw new ValidationException("Migration " + this.getClass().getSimpleName() + " is expecting a provided object folder");
        }
        this.cleanDisplayAddNewButtonFromReferenceView(dbMigrationDAO);
        long migrationTS = this.getMigrationTimestamp();
        JdbcTemplate jdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        Long actionId = MigrationEntitiesUtilsBetweenV12200AndV13099.createMigrationAction(jdbcTemplate, migrationTS);
        for (String bpvBluePrintId : BPV_BLUEPRINT_IDS) {
            MigrationEntitiesUtilsBetweenV12200AndV13099.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{bpvBluePrintId, "blueprint_version_default.json"}), "bp.system." + bpvBluePrintId, "bv.system.default", actionId, migrationTS);
        }
    }

    private void cleanDisplayAddNewButtonFromReferenceView(IDBMigrationDAO dbMigrationDAO) throws IOException {
        MigrationEntitiesUtilsBetweenV12200AndV13099.migrateObjects(dbMigrationDAO.getJdbcTemplate(), "blueprint_versions", "blueprint_version_blueprint_id=? AND blueprint_version_version_id=?", "blueprint_version_json", bpv -> Arrays.asList(MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "blueprintId").orElse(null), MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "versionId").orElse(null)), MigrationV13000::removeDisplayAddNewButtonFromBPV);
        MigrationEntitiesUtilsBetweenV12200AndV13099.migrateObjectsHistory(dbMigrationDAO.getJdbcTemplate(), "blueprint_versions_history", "blueprint_version_json", MigrationV13000::removeDisplayAddNewButtonFromBPV);
    }

    public static JsonObject removeDisplayAddNewButtonFromBPV(JsonObject bpv) {
        JsonObject views = MigrationJsonUtils.getObjectSubpath((JsonElement)bpv, "uiDefinition", "views").orElse(null);
        if (views == null) {
            return bpv;
        }
        MigrationEntitiesUtilsBetweenV12200AndV13099.collectRefViewComponentsFromViews(views).forEach(refViewComponent -> refViewComponent.remove("displayAddNewButton"));
        return bpv;
    }
}

