/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.admin.migrations;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.admin.MigrationFile;
import com.dataiku.gh.core.models.signoff.Signoff;
import com.dataiku.gh.core.services.admin.migrations.Migration;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationEntitiesUtilsBetweenV13300AndBeyond;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationJsonUtils;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.api.util.Strings;
import org.springframework.jdbc.core.JdbcTemplate;

public class MigrationV13400
extends Migration {
    private Long actionId;

    private Long getMigrationActionId(IDBMigrationDAO dbMigrationDAO, long migrationTS) throws IOException {
        if (this.actionId == null) {
            this.actionId = MigrationEntitiesUtilsBetweenV13300AndBeyond.createMigrationAction(dbMigrationDAO.getJdbcTemplate(), migrationTS);
        }
        return this.actionId;
    }

    @Override
    protected void postRunSQLFiles(IDBMigrationDAO dbMigrationDAO, List<MigrationFile> migrationFiles) {
        MigrationV13400.migrateSignoffUsers(dbMigrationDAO.getJdbcTemplate());
    }

    private static void migrateSignoffUsers(JdbcTemplate jdbcTemplate) {
        String signoffHistoryForLastIndexOfSignoff = "SELECT _revision_id AS pk, \n_revision_json AS revision_json, \nsignoff_json AS signoff_json, \nsignoff_artifact_id AS artifact_id,\nsignoff_step_id AS step_id \nFROM signoffs_history\nORDER BY artifact_id DESC, step_id DESC, _revision_timestamp DESC, _revision_id DESC";
        try (Stream queryStream = jdbcTemplate.queryForStream(signoffHistoryForLastIndexOfSignoff, (rs, rowNum) -> MigrationV13400.mapRow(rs));){
            SignoffHistory previousRow = new SignoffHistory();
            boolean signOffToUpdateForFeedback = false;
            boolean signOffToUpdateForApproval = false;
            HashSet<String> idsToFillForFeedback = new HashSet<String>();
            HashSet<String> idsToFillForApproval = new HashSet<String>();
            Iterator it = queryStream.iterator();
            while (it.hasNext()) {
                boolean artifactOrStepChanged;
                SignoffHistory currentRow = (SignoffHistory)it.next();
                boolean bl = artifactOrStepChanged = !Objects.equals(currentRow.artifactId, previousRow.artifactId) || !Objects.equals(currentRow.stepId, previousRow.stepId);
                if (artifactOrStepChanged) {
                    signOffToUpdateForApproval = true;
                    signOffToUpdateForFeedback = true;
                } else if (!Objects.equals(currentRow.cycleIndex, previousRow.cycleIndex)) {
                    signOffToUpdateForApproval = false;
                    signOffToUpdateForFeedback = false;
                }
                if (artifactOrStepChanged || !Objects.equals(currentRow.cycleIndex, previousRow.cycleIndex)) {
                    idsToFillForFeedback = new HashSet();
                    idsToFillForApproval = new HashSet();
                    previousRow = new SignoffHistory();
                }
                if (Objects.equals(previousRow.status, Signoff.SignoffStatus.WAITING_FOR_FEEDBACK.toString()) && Objects.equals(currentRow.status, Signoff.SignoffStatus.NOT_STARTED.toString())) {
                    RequestInfo feedbackRequestInfo = new RequestInfo();
                    feedbackRequestInfo.user = previousRow.revisionUser;
                    feedbackRequestInfo.date = previousRow.revisionDate;
                    MigrationV13400.updateRequestingUserForSignoffHistory(RequestType.FEEDBACK, jdbcTemplate, feedbackRequestInfo, idsToFillForFeedback);
                    if (signOffToUpdateForFeedback) {
                        MigrationV13400.updateRequestingUserForSignoff(RequestType.FEEDBACK, jdbcTemplate, feedbackRequestInfo, currentRow.artifactId, currentRow.stepId);
                        signOffToUpdateForFeedback = false;
                    }
                    idsToFillForFeedback = new HashSet();
                }
                if (Objects.equals(previousRow.status, Signoff.SignoffStatus.WAITING_FOR_APPROVAL.toString()) && (Objects.equals(currentRow.status, Signoff.SignoffStatus.NOT_STARTED.toString()) || Objects.equals(currentRow.status, Signoff.SignoffStatus.WAITING_FOR_FEEDBACK.toString()))) {
                    RequestInfo approvalRequestInfo = new RequestInfo();
                    approvalRequestInfo.user = previousRow.revisionUser;
                    approvalRequestInfo.date = previousRow.revisionDate;
                    MigrationV13400.updateRequestingUserForSignoffHistory(RequestType.APPROVAL, jdbcTemplate, approvalRequestInfo, idsToFillForApproval);
                    if (signOffToUpdateForApproval) {
                        MigrationV13400.updateRequestingUserForSignoff(RequestType.APPROVAL, jdbcTemplate, approvalRequestInfo, currentRow.artifactId, currentRow.stepId);
                        signOffToUpdateForApproval = false;
                    }
                    idsToFillForApproval = new HashSet();
                }
                idsToFillForFeedback.add(currentRow.primaryKey);
                idsToFillForApproval.add(currentRow.primaryKey);
                previousRow = currentRow;
            }
        }
    }

    private static void updateRequestingUserForSignoff(RequestType requestType, JdbcTemplate jdbcTemplate, RequestInfo requestInfo, String artifactId, String stepId) {
        String userIdentifier = requestType == RequestType.APPROVAL ? "approvalRequesterIdentifier" : "feedbackRequesterIdentifier";
        String dateIdentifier = requestType == RequestType.APPROVAL ? "approvalRequestDate" : "feedbackRequestDate";
        jdbcTemplate.update(String.format("UPDATE signoffs \nSET signoff_json = signoff_json || jsonb_object(array['%s', '%s'],array['%s', '%s']) \nWHERE signoff_artifact_id = '%s' AND signoff_step_id = '%s'", userIdentifier, dateIdentifier, requestInfo.user, requestInfo.date, artifactId, stepId));
    }

    private static void updateRequestingUserForSignoffHistory(RequestType requestType, JdbcTemplate jdbcTemplate, RequestInfo requestInfo, Set<String> pksToOverwriteRequestersFor) {
        String userIdentifier = requestType == RequestType.APPROVAL ? "approvalRequesterIdentifier" : "feedbackRequesterIdentifier";
        String dateIdentifier = requestType == RequestType.APPROVAL ? "approvalRequestDate" : "feedbackRequestDate";
        jdbcTemplate.update(String.format("UPDATE signoffs_history \nSET signoff_json = signoff_json || jsonb_object(array['%s', '%s'],array['%s', '%s']) \nWHERE _revision_id IN (%s)", userIdentifier, dateIdentifier, requestInfo.user, requestInfo.date, pksToOverwriteRequestersFor.stream().map(str -> "'" + str + "'").collect(Collectors.joining(","))));
    }

    private static SignoffHistory mapRow(ResultSet rs) throws SQLException {
        SignoffHistory signoffHistory = new SignoffHistory();
        signoffHistory.primaryKey = rs.getString("pk");
        signoffHistory.artifactId = rs.getString("artifact_id");
        signoffHistory.stepId = rs.getString("step_id");
        JsonObject revisionJson = (JsonObject)JSON.parse((String)rs.getString("revision_json"), JsonObject.class);
        signoffHistory.revisionUser = MigrationJsonUtils.getStringSubpath((JsonElement)revisionJson, "user").orElse("");
        JsonObject signoffJson = (JsonObject)JSON.parse((String)rs.getString("signoff_json"), JsonObject.class);
        signoffHistory.revisionDate = MigrationJsonUtils.getStringSubpath((JsonElement)signoffJson, "statusDate").orElse(null);
        signoffHistory.status = MigrationJsonUtils.getStringSubpath((JsonElement)signoffJson, "status").orElse(null);
        signoffHistory.cycleIndex = MigrationJsonUtils.getStringSubpath((JsonElement)signoffJson, "cycleIndex").orElse(null);
        return signoffHistory;
    }

    @Override
    protected void updateProvidedSystemObjects(IDBMigrationDAO dbMigrationDAO, @Nullable File providedObjectsFolder) throws IOException {
        JsonElement arrayElement;
        JdbcTemplate jdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        long migrationTS = this.getMigrationTimestamp();
        long actionId = this.getMigrationActionId(dbMigrationDAO, migrationTS);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprint(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_retrievable_knowledge", "blueprint.json"}), "bp.system.dataiku_retrievable_knowledge", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintRoleAssignments(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_retrievable_knowledge", "blueprint_role_assignments.json"}), "bp.system.dataiku_retrievable_knowledge", actionId, migrationTS);
        try (Stream selectStream = dbMigrationDAO.getJdbcTemplate().queryForStream(String.format("SELECT %s FROM %s WHERE %s", "blueprint_permissions_json", "blueprint_permissions", "blueprint_permissions_blueprint_id = 'bp.system.dataiku_saved_model'"), (rs, rowNum) -> (JsonObject)JSON.parse((String)rs.getString("blueprint_permissions_json"), JsonObject.class));){
            Optional modelBPPermission = selectStream.findAny();
            if (modelBPPermission.isPresent()) {
                MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintPermissions(jdbcTemplate, (JsonObject)modelBPPermission.get(), "bp.system.dataiku_retrievable_knowledge", actionId, migrationTS);
            }
        }
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_retrievable_knowledge", "blueprint_version_default.json"}), "bp.system.dataiku_retrievable_knowledge", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_project", "blueprint_version_default.json"}), "bp.system.dataiku_project", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_bundle", "blueprint_version_default.json"}), "bp.system.dataiku_bundle", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"govern_project", "blueprint_version_default.json"}), "bp.system.govern_project", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"govern_model_version", "blueprint_version_default.json"}), "bp.system.govern_model_version", "bv.system.default", actionId, migrationTS);
        selectStream = dbMigrationDAO.getJdbcTemplate().queryForStream(String.format("SELECT %s FROM %s WHERE %s FOR UPDATE", "blueprint_version_json", "blueprint_versions", "blueprint_version_blueprint_id = 'bp.system.govern_model_version' AND blueprint_version_version_id != 'bv.system.default'"), (rs, rowNum) -> (JsonObject)JSON.parse((String)rs.getString("blueprint_version_json"), JsonObject.class));
        try {
            for (String[] bpv : selectStream.collect(Collectors.toList())) {
                JsonObject newBpv;
                String blueprintId = MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "blueprintId").orElse(null);
                String versionId = MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "versionId").orElse(null);
                if (blueprintId == null || versionId == null || Objects.equals(bpv, newBpv = MigrationV13400.migrateGovernModelVersionBPVsReferenceToParentToAllowGovernProject((JsonObject)JSON.deepCopy((Object)bpv)))) continue;
                MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersion(dbMigrationDAO.getJdbcTemplate(), newBpv, blueprintId, versionId, actionId, migrationTS);
            }
        }
        finally {
            if (selectStream != null) {
                selectStream.close();
            }
        }
        JsonObject governModelVersionBRA = dbMigrationDAO.getJdbcTemplate().queryForStream(String.format("SELECT %s FROM %s WHERE %s FOR UPDATE", "blueprint_role_assignments_json", "blueprint_role_assignments", "blueprint_role_assignments_blueprint_id = 'bp.system.govern_model_version'"), (rs, rowNum) -> (JsonObject)JSON.parse((String)rs.getString("blueprint_role_assignments_json"), JsonObject.class)).findAny().orElse(new JSON.JsonBuilder().kv("blueprintId", (Object)"bp.system.govern_model_version").get());
        JsonArray governModelVersionInheritBPIds = MigrationJsonUtils.getArraySubpath((JsonElement)governModelVersionBRA, "inheritBlueprintIds").orElse(new JsonArray());
        governModelVersionInheritBPIds.add("bp.system.govern_project");
        governModelVersionBRA.add("inheritBlueprintIds", (JsonElement)governModelVersionInheritBPIds);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintRoleAssignments(jdbcTemplate, governModelVersionBRA, "bp.system.govern_model_version", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_saved_model", "blueprint_version_default.json"}), "bp.system.dataiku_saved_model", "bv.system.default", actionId, migrationTS);
        for (String modelVersion : new String[]{"prediction", "clustering", "fine_tuning", "agent", "augmented"}) {
            MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_saved_model_version", "blueprint_version_" + modelVersion + ".json"}), "bp.system.dataiku_saved_model_version", "bv.system." + modelVersion, actionId, migrationTS);
        }
        JsonObject dkuModelVersionBRA = dbMigrationDAO.getJdbcTemplate().queryForStream(String.format("SELECT %s FROM %s WHERE %s FOR UPDATE", "blueprint_role_assignments_json", "blueprint_role_assignments", "blueprint_role_assignments_blueprint_id = 'bp.system.dataiku_saved_model_version'"), (rs, rowNum) -> (JsonObject)JSON.parse((String)rs.getString("blueprint_role_assignments_json"), JsonObject.class)).findAny().orElse(new JSON.JsonBuilder().kv("blueprintId", (Object)"bp.system.dataiku_saved_model_version").get());
        JsonArray dkuModelVersionInheritBPIds = MigrationJsonUtils.getArraySubpath((JsonElement)dkuModelVersionBRA, "inheritBlueprintIds").orElse(new JsonArray());
        dkuModelVersionInheritBPIds.add("bp.system.dataiku_project");
        dkuModelVersionBRA.add("inheritBlueprintIds", (JsonElement)dkuModelVersionInheritBPIds);
        JsonArray dkuModelVersionInheritFieldIds = MigrationJsonUtils.getArraySubpath((JsonElement)dkuModelVersionBRA, "inheritArtifactFieldIds").orElse(new JsonArray());
        dkuModelVersionInheritFieldIds.add("dataiku_project");
        dkuModelVersionBRA.add("inheritArtifactFieldIds", (JsonElement)dkuModelVersionInheritFieldIds);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintRoleAssignments(jdbcTemplate, dkuModelVersionBRA, "bp.system.dataiku_saved_model_version", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertCustomPage(dbMigrationDAO.getJdbcTemplate(), DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"custom_page", "gen_ai_registry.json"}), actionId, migrationTS);
        JsonObject config = MigrationEntitiesUtilsBetweenV13300AndBeyond.streamObjects(jdbcTemplate, "govern_configuration", "configuration_item_json", "configuration_item_id='custom-page-order'").findAny().orElse(null);
        if (config != null && config.has("customPageIds") && (arrayElement = config.get("customPageIds")).isJsonArray()) {
            List<String> customPageIds;
            JsonArray array = arrayElement.getAsJsonArray();
            customPageIds.add((customPageIds = IntStream.range(0, array.size()).mapToObj(arg_0 -> ((JsonArray)array).get(arg_0)).filter(je -> je.isJsonPrimitive() && je.getAsJsonPrimitive().isString()).map(JsonElement::getAsString).collect(Collectors.toList())).contains("cp.system.model-registry") ? customPageIds.indexOf("cp.system.model-registry") + 1 : customPageIds.size(), "cp.system.gen-ai-registry");
            JsonArray newArray = new JsonArray();
            customPageIds.forEach(arg_0 -> ((JsonArray)newArray).add(arg_0));
            config.add("customPageIds", (JsonElement)newArray);
            MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertGovernConfiguration(jdbcTemplate, config, actionId, migrationTS);
        }
    }

    public static JsonObject migrateGovernModelVersionBPVsReferenceToParentToAllowGovernProject(JsonObject bpv) {
        Optional<JsonArray> allowedBPs;
        String blueprintId = MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "blueprintId").orElse(null);
        String versionId = MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "versionId").orElse(null);
        if (blueprintId == null || versionId == null || !Strings.equals((String)blueprintId, (String)"bp.system.govern_model_version")) {
            return bpv;
        }
        if (Strings.equals((String)MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "fieldDefinitions", "govern_model", "label").orElse(null), (String)"Governed model")) {
            bpv.getAsJsonObject("fieldDefinitions").getAsJsonObject("govern_model").addProperty("label", "Governed parent item");
        }
        if ((allowedBPs = MigrationJsonUtils.getArraySubpath((JsonElement)bpv, "fieldDefinitions", "govern_model", "allowedBlueprints")).isPresent() && !allowedBPs.get().contains((JsonElement)new JsonPrimitive("bp.system.govern_project"))) {
            allowedBPs.get().add((JsonElement)new JsonPrimitive("bp.system.govern_project"));
        }
        Optional<JsonObject> views = MigrationJsonUtils.getObjectSubpath((JsonElement)bpv, "uiDefinition", "views");
        views.ifPresent(MigrationV13400::browseGovernModelFieldVCsFromViews);
        return bpv;
    }

    private static void browseGovernModelFieldVCsFromViews(JsonObject views) {
        for (String key : views.keySet()) {
            MigrationJsonUtils.getObjectSubpath((JsonElement)views, key, "viewComponent").ifPresent(MigrationV13400::browseGovernModelFields);
        }
    }

    private static void browseGovernModelFields(JsonObject viewComponent) {
        String type = MigrationJsonUtils.getStringSubpath((JsonElement)viewComponent, "type").orElse(null);
        String fieldId = MigrationJsonUtils.getStringSubpath((JsonElement)viewComponent, "fieldId").orElse(null);
        String label = MigrationJsonUtils.getStringSubpath((JsonElement)viewComponent, "label").orElse(null);
        if (StringUtils.equals((CharSequence)"govern_model", (CharSequence)fieldId) && (StringUtils.equals((CharSequence)"card-reference-field", (CharSequence)type) || StringUtils.equals((CharSequence)"table-reference-field", (CharSequence)type)) && StringUtils.equals((CharSequence)"Governed model", (CharSequence)label)) {
            viewComponent.addProperty("label", "Governed parent item");
        } else if (StringUtils.equals((CharSequence)"container", (CharSequence)type)) {
            MigrationJsonUtils.getArraySubpath((JsonElement)viewComponent, "layout", "viewComponents").ifPresent(vcs -> vcs.forEach(vc -> {
                if (vc.isJsonObject()) {
                    MigrationV13400.browseGovernModelFields(vc.getAsJsonObject());
                }
            }));
        }
    }

    private static class SignoffHistory {
        public String primaryKey;
        public String revisionUser;
        public String revisionDate;
        public String artifactId;
        public String stepId;
        public String status;
        public String cycleIndex;

        private SignoffHistory() {
        }
    }

    private static class RequestInfo {
        public String user;
        public String date;

        private RequestInfo() {
        }
    }

    private static enum RequestType {
        APPROVAL,
        FEEDBACK;

    }
}

