/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.artifacts;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.artifacts.ArtifactDescription;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionStatus;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.ArtifactPostFilter;
import com.dataiku.gh.core.models.search.ArtifactSearchPagination;
import com.dataiku.gh.core.models.search.ArtifactSearchQuery;
import com.dataiku.gh.core.models.search.ArtifactSearchSourceConfig;
import com.dataiku.gh.core.models.subscriptions.Subscription;
import com.dataiku.gh.core.models.time_series.TimeSeriesHead;
import com.dataiku.gh.core.models.ui.UIArtifact;
import com.dataiku.gh.core.models.ui.UIArtifactException;
import com.dataiku.gh.core.models.ui.UIArtifactSearchResults;
import com.dataiku.gh.core.models.uploaded_files.UploadedFileDesc;
import com.dataiku.gh.core.services.artifacts.IArtifactPostFilterService;
import com.dataiku.gh.core.services.artifacts.IArtifactWorkflowService;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.artifacts.IArtifactsService;
import com.dataiku.gh.core.services.artifacts.context.EnrichedArtifactContext;
import com.dataiku.gh.core.services.artifacts.context.EnrichedBlueprintVersionContext;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.mappers.IUIModelsMapperService;
import com.dataiku.gh.core.services.python_execution.IPythonExecutionService;
import com.dataiku.gh.core.services.python_execution.logical_hooks.HooksExecutionResult;
import com.dataiku.gh.core.services.relationships.collectors.RelationshipsCollector;
import com.dataiku.gh.core.services.relationships.permissions.ITimeSeriesRelationshipPermissionService;
import com.dataiku.gh.core.services.relationships.permissions.IUploadedFileRelationshipPermissionService;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.IRolesAndPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.context.UserRolesCacheContext;
import com.dataiku.gh.core.services.subscriptions.ISubscriptionsService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.IArtifactSearchQueryValidationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.artifacts.IArtifactIDDAO;
import com.dataiku.gh.core.storage.time_series.ITimeSeriesHeadDAO;
import com.dataiku.gh.core.storage.uploaded_files.IUploadedFileDAO;
import com.dataiku.gh.core.utils.Either;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.core.utils.ValidatorUtils;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArtifactsService
implements IArtifactsService {
    public static final int DEFAULT_PAGE_SIZE = 50;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IBlueprintsDataService blueprintsDataService;
    @Autowired
    private IArtifactIDDAO artifactIDDAO;
    @Autowired
    private IArtifactPostFilterService artifactPostFilterService;
    @Autowired
    private IPythonExecutionService pythonExecutionService;
    @Autowired
    private IRolesAndPermissionsService rolesAndPermissionsService;
    @Autowired
    private IUIModelsMapperService uiModelsMapperService;
    @Autowired
    private ICheckPermissionsService checkPermissionsService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private IArtifactSearchQueryValidationService artifactSearchQueryValidationService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ISubscriptionsService subscriptionsService;
    @Autowired
    private IUploadedFileDAO uploadedFileDAO;
    @Autowired
    private IUploadedFileRelationshipPermissionService uploadedFileRelationshipPermissionService;
    @Autowired
    private ITimeSeriesHeadDAO timeSeriesHeadDAO;
    @Autowired
    private ITimeSeriesRelationshipPermissionService timeSeriesRelationshipPermissionService;
    @Autowired
    private IArtifactWorkflowService artifactWorkflowService;
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.services.artifact");

    @Override
    @GHWriteTransaction
    public ArtifactDescription createArtifact(AuthCtx authCtx, Artifact inputArtifactInCreation) throws IOException, DKUSecurityException, LimitsStatusComputer.LicenseLimitException {
        try (EnrichedArtifactContext.EnrichedArtifactContextContainer enrichedArtifactContext = EnrichedArtifactContext.attachNewContextOrKeepExistingOne();){
            EnrichedArtifact createdEnrichedArtifact = this.storeNewArtifactAndSubscribe(authCtx, inputArtifactInCreation);
            ArtifactDescription artifactDescription = ArtifactDescription.build(createdEnrichedArtifact.artifact.id);
            return artifactDescription;
        }
    }

    @Override
    @GHWriteTransaction
    public UIArtifact saveArtifact(AuthCtx authCtx, Artifact inputArtifact) throws IOException, DKUSecurityException {
        try (EnrichedArtifactContext.EnrichedArtifactContextContainer enrichedArtifactContext = EnrichedArtifactContext.attachNewContextOrKeepExistingOne();){
            UIArtifact uIArtifact = this.storeExistingArtifactAndReturnUIArtifact(authCtx, inputArtifact);
            return uIArtifact;
        }
    }

    @Override
    @GHReadonlyTransaction
    public UIArtifact prepareSaveArtifact(AuthCtx authCtx, Artifact inputArtifact) throws IOException, DKUSecurityException, LimitsStatusComputer.LicenseLimitException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        try (EnrichedArtifactContext.EnrichedArtifactContextContainer enrichedArtifactContext = EnrichedArtifactContext.attachNewContextOrKeepExistingOne();){
            EnrichedArtifact existingEnrichedArtifact;
            EnrichedArtifact enrichedArtifact = existingEnrichedArtifact = inputArtifact.id == null ? null : this.artifactsDataService.getArtifactOrNull(inputArtifact.id);
            if (existingEnrichedArtifact != null) {
                EnrichedArtifact preparedEnrichedArtifact = this.prepareStoreExistingArtifact(authCtx, inputArtifact, existingEnrichedArtifact, false);
                Subscription existingSubscription = this.subscriptionsService.getSubscriptionOrNull(authCtx, inputArtifact.id);
                UIArtifact uIArtifact = this.checkArtifactReadPermissionsAndMapToUIArtifact(authCtx, preparedEnrichedArtifact, existingSubscription);
                return uIArtifact;
            }
            EnrichedArtifact preparedEnrichedArtifact = this.prepareCreateArtifact(authCtx, inputArtifact, false);
            UIArtifact uIArtifact = this.checkArtifactReadPermissionsAndMapToUIArtifact(authCtx, preparedEnrichedArtifact, null);
            return uIArtifact;
        }
    }

    @Override
    @GHWriteTransaction
    public void deleteArtifact(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        EnrichedArtifact existingEnrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
        this.checkLockedSystemArtifact(authCtx, existingEnrichedArtifact.blueprint.id);
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authCtx, existingEnrichedArtifact);
        this.checkPermissionsService.checkArtifactDeletePermission(authCtx, assignedRolesAndPermissionsCtx.effectivePermissionsItem, existingEnrichedArtifact.artifact.id);
        this.pythonExecutionService.applyLogicalHooksForDeletion(existingEnrichedArtifact, authCtx.getIdentifier());
        this.artifactsDataService.deleteArtifact(existingEnrichedArtifact.artifact.id, existingEnrichedArtifact.artifact.blueprintVersionId);
    }

    @Override
    @GHReadonlyTransaction
    public UIArtifact getArtifact(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        try (EnrichedArtifactContext.EnrichedArtifactContextContainer enrichedArtifactContext = EnrichedArtifactContext.attachNewContextOrKeepExistingOne();){
            EnrichedArtifact enrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
            Subscription subscription = this.subscriptionsService.getSubscriptionOrNull(authCtx, artifactId);
            UIArtifact uIArtifact = this.checkArtifactReadPermissionsAndMapToUIArtifact(authCtx, enrichedArtifact, subscription);
            return uIArtifact;
        }
    }

    @Override
    @GHWriteTransaction
    public List<Either<UIArtifactException, UIArtifact>> getArtifactsOrExceptions(AuthCtx authCtx, List<String> artifactIds, @Nullable Boolean archived) throws IOException, DKUSecurityException {
        List<Either<UIArtifactException, UIArtifact>> result;
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        ArrayList artifactFilters = Lists.newArrayList((Object[])new ArtifactFilter[]{ArtifactFilter.ArtifactsArtifactFilter.build(artifactIds)});
        if (archived != null) {
            artifactFilters.add(ArtifactFilter.ArchivedStatusArtifactFilter.build(archived));
        }
        try (EnrichedBlueprintVersionContext.EnrichedBlueprintVersionContextContainer blueprintVersionCache = EnrichedBlueprintVersionContext.attachNewContextOrKeepExistingOne();
             Stream<EnrichedArtifact> searchResults = this.artifactsDataService.searchArtifactsStream(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), artifactFilters, null, null);
             UserRolesCacheContext.ContextContainer rolesCache = UserRolesCacheContext.attachNewContext();
             EnrichedArtifactContext.EnrichedArtifactContextContainer enrichedArtifactContext = EnrichedArtifactContext.attachNewContextOrKeepExistingOne();){
            Map<String, Subscription.SubscriptionLevel> subscriptions = this.subscriptionsService.getSubscriptionsMap(authCtx, artifactIds);
            result = searchResults.map(enrichedArtifact -> this.mapToUIArtifactsOrUIArtifactException_NoLicenseCheck_UncheckedIOException(authCtx, (EnrichedArtifact)enrichedArtifact, (Subscription.SubscriptionLevel)((Object)((Object)subscriptions.get(enrichedArtifact.artifact.id))))).collect(Collectors.toList());
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
        HashSet<String> requestedArtifactIds = new HashSet<String>(artifactIds);
        if (requestedArtifactIds.size() != result.size()) {
            Set existingArtifactIds = result.stream().map(i -> i.isRight() ? ((UIArtifact)i.getRight()).artifact.id : ((UIArtifactException)i.getLeft()).artifactId).collect(Collectors.toSet());
            for (String artifactId : requestedArtifactIds) {
                if (existingArtifactIds.contains(artifactId)) continue;
                result.add(Either.left(UIArtifactException.build(artifactId, (Exception)new NotFoundException("Artifact item does not exist: " + artifactId))));
            }
        }
        return result;
    }

    @Override
    @GHWriteTransaction
    public UIArtifactSearchResults search(AuthCtx authCtx, ArtifactSearchQuery artifactSearchQuery) throws IOException, DKUSecurityException {
        boolean hasNextPage;
        List<UIArtifact> uiArtifactsPaginated;
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        this.artifactSearchQueryValidationService.validateArtifactSearchQuery(artifactSearchQuery);
        ArtifactSearchPagination artifactSearchPagination = artifactSearchQuery.artifactSearchPagination;
        if (artifactSearchPagination == null) {
            artifactSearchPagination = new ArtifactSearchPagination();
        }
        if (artifactSearchPagination.pageSize == null || artifactSearchPagination.pageSize == 0) {
            artifactSearchPagination.pageSize = 50;
        }
        try (EnrichedBlueprintVersionContext.EnrichedBlueprintVersionContextContainer blueprintVersionCache = EnrichedBlueprintVersionContext.attachNewContextOrKeepExistingOne();
             Stream<EnrichedArtifact> enrichedArtifactStream = this.artifactsDataService.searchArtifactsStream(artifactSearchQuery.artifactSearchSource, artifactSearchQuery.artifactFilters, artifactSearchQuery.artifactSearchSort, artifactSearchPagination.lastArtifactId);
             UserRolesCacheContext.ContextContainer rolesCache = UserRolesCacheContext.attachNewContext();
             EnrichedArtifactContext.EnrichedArtifactContextContainer enrichedArtifactContextContainer = EnrichedArtifactContext.attachNewContextOrKeepExistingOne();){
            Map<String, Subscription.SubscriptionLevel> subscriptions = this.subscriptionsService.getSubscriptionsMapForUser(authCtx);
            Stream<UIArtifact> uiArtifactStream = enrichedArtifactStream.map(enrichedArtifact -> this.getEnrichedArtifactAndCurrentUserDataCtx_UncheckedIOException(authCtx, (EnrichedArtifact)enrichedArtifact, (Subscription.SubscriptionLevel)((Object)((Object)subscriptions.get(enrichedArtifact.artifact.id))))).filter(enrichedArtifactWithCurrentUserDataCtx -> this.applyArtifactPostFilters((EnrichedArtifactWithCurrentUserDataCtx)enrichedArtifactWithCurrentUserDataCtx, artifactSearchQuery.artifactPostFilters)).map(enrichedArtifactWithCurrentUserDataCtx -> this.mapToUIArtifactsOrUIArtifactException_NoLicenseCheck_UncheckedIOException(authCtx, (EnrichedArtifactWithCurrentUserDataCtx)enrichedArtifactWithCurrentUserDataCtx)).filter(Either::isRight).map(Either::getRight);
            if (artifactSearchPagination.all == null || !artifactSearchPagination.all.booleanValue()) {
                uiArtifactStream = uiArtifactStream.limit((long)artifactSearchPagination.pageSize.intValue() + 1L);
            }
            uiArtifactsPaginated = uiArtifactStream.collect(Collectors.toList());
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
        boolean bl = hasNextPage = uiArtifactsPaginated.size() > artifactSearchPagination.pageSize;
        if (artifactSearchPagination.all != null && artifactSearchPagination.all.booleanValue()) {
            hasNextPage = false;
        }
        if (hasNextPage) {
            uiArtifactsPaginated.remove(uiArtifactsPaginated.size() - 1);
        }
        return UIArtifactSearchResults.build(hasNextPage, uiArtifactsPaginated);
    }

    private EnrichedArtifact storeNewArtifactAndSubscribe(AuthCtx authCtx, Artifact inputArtifactInCreation) throws IOException, DKUSecurityException, LimitsStatusComputer.LicenseLimitException {
        EnrichedArtifact newEnrichedArtifact = this.prepareCreateArtifact(authCtx, inputArtifactInCreation, true);
        this.checkRelationshipEntitiesReadPermissions(authCtx, newEnrichedArtifact);
        HooksExecutionResult hooksExecutionResult = this.pythonExecutionService.applyLogicalHooksForCreation(newEnrichedArtifact, authCtx.getIdentifier());
        EnrichedArtifact storedArtifact = this.artifactsDataService.storeArtifact(hooksExecutionResult.newEnrichedArtifact, true);
        this.subscriptionsService.automaticSubscribe(authCtx, storedArtifact.artifact.id);
        return storedArtifact;
    }

    private EnrichedArtifact prepareCreateArtifact(AuthCtx authCtx, Artifact inputArtifactInCreation, boolean forCreation) throws IOException, DKUSecurityException, LimitsStatusComputer.LicenseLimitException {
        this.checkLockedSystemArtifact(authCtx, inputArtifactInCreation.blueprintVersionId.blueprintId);
        if (inputArtifactInCreation.id != null) {
            throw new ValidationException("Artifact ID `" + inputArtifactInCreation.id + "` cannot be set in creation");
        }
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.blueprintsDataService.getBlueprintVersion(inputArtifactInCreation.blueprintVersionId);
        if (enrichedBlueprintVersion.blueprintVersionTrace.status == BlueprintVersionStatus.DRAFT) {
            throw new ValidationException("Cannot create an artifact on a draft blueprint version with id: " + String.valueOf(enrichedBlueprintVersion.blueprintVersion.id));
        }
        if (enrichedBlueprintVersion.blueprintVersionTrace.status == BlueprintVersionStatus.ARCHIVED) {
            throw new ValidationException("Cannot create an artifact on an archived blueprint version with id: " + String.valueOf(enrichedBlueprintVersion.blueprintVersion.id));
        }
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtBlueprintVersionLevel(authCtx, enrichedBlueprintVersion);
        this.checkPermissionsService.checkArtifactCreatePermission(authCtx, assignedRolesAndPermissionsCtx.effectivePermissionsItem, enrichedBlueprintVersion.blueprint.id);
        inputArtifactInCreation.id = forCreation ? IdentifiersUtils.buildArtifactId(this.artifactIDDAO.newId()) : "prepare.only.id";
        return this.uiModelsMapperService.buildEnrichedArtifactFromInputArtifactForCreation(assignedRolesAndPermissionsCtx, enrichedBlueprintVersion, inputArtifactInCreation);
    }

    private EnrichedArtifact storeExistingArtifact(AuthCtx authCtx, Artifact inputArtifact) throws IOException, DKUSecurityException {
        this.checkLockedSystemArtifact(authCtx, inputArtifact.blueprintVersionId.blueprintId);
        EnrichedArtifact existingEnrichedArtifact = this.artifactsDataService.getArtifact(inputArtifact.id);
        EnrichedArtifact newEnrichedArtifact = this.prepareStoreExistingArtifact(authCtx, inputArtifact, existingEnrichedArtifact, true);
        this.checkRelationshipEntitiesReadPermissions(authCtx, newEnrichedArtifact);
        HooksExecutionResult hooksExecutionResult = this.pythonExecutionService.applyLogicalHooksForUpdate(newEnrichedArtifact, existingEnrichedArtifact, authCtx.getIdentifier());
        return this.artifactsDataService.storeArtifact(hooksExecutionResult.newEnrichedArtifact, false);
    }

    private EnrichedArtifact prepareStoreExistingArtifact(AuthCtx authCtx, Artifact inputArtifact, EnrichedArtifact existingEnrichedArtifact, boolean forSave) throws IOException, DKUSecurityException {
        existingEnrichedArtifact.artifact.status.stepId = existingEnrichedArtifact.artifact.getLegacyStepId(this.artifactWorkflowService.computeVisibleArtifactWorkflowSteps(existingEnrichedArtifact));
        ValidatorUtils.validateThat(Objects.equals(existingEnrichedArtifact.blueprintVersion.id, inputArtifact.blueprintVersionId), "Invalid blueprint version ID: " + String.valueOf(inputArtifact.blueprintVersionId) + " , it must match the current one: " + String.valueOf(existingEnrichedArtifact.blueprintVersion.id), new Object[0]);
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authCtx, existingEnrichedArtifact);
        this.checkPermissionsService.checkArtifactWritePermission(authCtx, assignedRolesAndPermissionsCtx.effectivePermissionsItem, existingEnrichedArtifact.artifact.id);
        return this.uiModelsMapperService.buildEnrichedArtifactFromInputArtifactForSave(assignedRolesAndPermissionsCtx, existingEnrichedArtifact, inputArtifact, forSave);
    }

    private UIArtifact storeExistingArtifactAndReturnUIArtifact(AuthCtx authCtx, Artifact inputArtifact) throws IOException, DKUSecurityException {
        EnrichedArtifact savedEnrichedArtifact = this.storeExistingArtifact(authCtx, inputArtifact);
        Subscription subscription = this.subscriptionsService.automaticSubscribe(authCtx, savedEnrichedArtifact.artifact.id);
        return this.checkArtifactReadPermissionsAndMapToUIArtifact(authCtx, savedEnrichedArtifact, subscription);
    }

    private void checkRelationshipEntitiesReadPermissions(AuthCtx authCtx, EnrichedArtifact enrichedArtifact) throws IOException, DKUSecurityException {
        RelationshipsCollector relationshipsCollector = new RelationshipsCollector(enrichedArtifact.artifact);
        enrichedArtifact.accept(relationshipsCollector);
        try (Stream<UploadedFileDesc> uploadedFileDescStream = this.uploadedFileDAO.listUploadedFileDescStream(relationshipsCollector.result.getUploadedFileRelationships().stream().map(ufr -> ufr.uploadedFileId).distinct().collect(Collectors.toList()));){
            for (UploadedFileDesc ufd : uploadedFileDescStream.collect(Collectors.toList())) {
                this.uploadedFileRelationshipPermissionService.checkRelationshipReadPermission(authCtx, ufd);
            }
        }
        try (Stream<TimeSeriesHead> timeSeriesHeadStream = this.timeSeriesHeadDAO.listTimeSeriesHeadStream(relationshipsCollector.result.getTimeSeriesRelationships().stream().map(tsr -> tsr.timeSeriesId).distinct().collect(Collectors.toList()));){
            for (TimeSeriesHead tsh : timeSeriesHeadStream.collect(Collectors.toList())) {
                this.timeSeriesRelationshipPermissionService.checkRelationshipReadPermission(authCtx, tsh);
            }
        }
    }

    @Override
    public UIArtifact checkArtifactReadPermissionsAndMapToUIArtifact(AuthCtx authCtx, EnrichedArtifact enrichedArtifact, @Nullable Subscription subscription) throws IOException, DKUSecurityException {
        EnrichedArtifactWithCurrentUserDataCtx enrichedArtifactWithCurrentUserDataCtx = this.getEnrichedArtifactAndCurrentUserDataCtx_UncheckedIOException(authCtx, enrichedArtifact, subscription == null ? null : subscription.subscriptionLevel);
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        return this.uiModelsMapperService.checkReadAndMapEnrichedArtifactToUIArtifact(this.permissionsService.isGovernArchitect(authCtx), enrichedArtifactWithCurrentUserDataCtx.assignedRolesAndPermissionsCtx, enrichedArtifactWithCurrentUserDataCtx.enrichedArtifact, enrichedArtifactWithCurrentUserDataCtx.subscriptionLevel);
    }

    @Override
    public Either<UIArtifactException, UIArtifact> mapToUIArtifactsOrUIArtifactException_NoLicenseCheck_UncheckedIOException(AuthCtx authCtx, EnrichedArtifact enrichedArtifact, @Nullable Subscription.SubscriptionLevel subscriptionLevel) {
        return this.mapToUIArtifactsOrUIArtifactException_NoLicenseCheck_UncheckedIOException(authCtx, this.getEnrichedArtifactAndCurrentUserDataCtx_UncheckedIOException(authCtx, enrichedArtifact, subscriptionLevel));
    }

    private Either<UIArtifactException, UIArtifact> mapToUIArtifactsOrUIArtifactException_NoLicenseCheck_UncheckedIOException(AuthCtx authCtx, EnrichedArtifactWithCurrentUserDataCtx enrichedArtifactWithCurrentUserDataCtx) {
        String artifactId = enrichedArtifactWithCurrentUserDataCtx.enrichedArtifact.artifact.id;
        try {
            return Either.right(this.uiModelsMapperService.checkReadAndMapEnrichedArtifactToUIArtifact(this.permissionsService.isGovernArchitect(authCtx), enrichedArtifactWithCurrentUserDataCtx.assignedRolesAndPermissionsCtx, enrichedArtifactWithCurrentUserDataCtx.enrichedArtifact, enrichedArtifactWithCurrentUserDataCtx.subscriptionLevel));
        }
        catch (DKUSecurityException e) {
            return Either.left(UIArtifactException.build(artifactId, (Exception)((Object)e)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean applyArtifactPostFilters(EnrichedArtifactWithCurrentUserDataCtx enrichedArtifactWithCurrentUserDataCtx, List<ArtifactPostFilter> artifactPostFilters) {
        if (CollectionUtils.isEmpty(artifactPostFilters)) {
            return true;
        }
        EnrichedArtifact enrichedArtifact = enrichedArtifactWithCurrentUserDataCtx.enrichedArtifact;
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = enrichedArtifactWithCurrentUserDataCtx.assignedRolesAndPermissionsCtx;
        return artifactPostFilters.stream().allMatch(artifactPostFilter -> this.artifactPostFilterService.filter(enrichedArtifact, assignedRolesAndPermissionsCtx, (ArtifactPostFilter)artifactPostFilter));
    }

    private EnrichedArtifactWithCurrentUserDataCtx getEnrichedArtifactAndCurrentUserDataCtx_UncheckedIOException(AuthCtx authCtx, EnrichedArtifact enrichedArtifact, @Nullable Subscription.SubscriptionLevel subscriptionLevel) {
        try {
            return new EnrichedArtifactWithCurrentUserDataCtx(enrichedArtifact, this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authCtx, enrichedArtifact), authCtx.getAuthSource() == AuthCtx.AuthSource.USER_FROM_UI ? Optional.ofNullable(subscriptionLevel).orElse(Subscription.SubscriptionLevel.INO) : subscriptionLevel);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void checkLockedSystemArtifact(AuthCtx authCtx, String blueprintId) {
        if (this.permissionsService.isGovernArchitect(authCtx)) {
            return;
        }
        if (SystemProvidedConstants.isArtifactsSystemLockEnabledForBlueprint(blueprintId)) {
            throw new ValidationException("Cannot modify a locked system artifact with blueprint id `" + blueprintId + "`");
        }
    }

    private static class EnrichedArtifactWithCurrentUserDataCtx {
        public EnrichedArtifact enrichedArtifact;
        public AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx;
        @Nullable
        public Subscription.SubscriptionLevel subscriptionLevel;

        public EnrichedArtifactWithCurrentUserDataCtx(EnrichedArtifact enrichedArtifact, AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx, @Nullable Subscription.SubscriptionLevel subscriptionLevel) {
            this.enrichedArtifact = enrichedArtifact;
            this.assignedRolesAndPermissionsCtx = assignedRolesAndPermissionsCtx;
            this.subscriptionLevel = subscriptionLevel;
        }
    }
}

