/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.artifacts.context;

import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class EnrichedBlueprintVersionContext {
    private static final ThreadLocal<ParentContextContainer> currentContext = new ThreadLocal();

    public static EnrichedBlueprintVersionContextContainer attachNewContextOrKeepExistingOne() {
        if (EnrichedBlueprintVersionContext.hasContext()) {
            return new ChildContextContainer(currentContext.get());
        }
        ParentContextContainer context = new ParentContextContainer();
        currentContext.set(context);
        return context;
    }

    private static boolean hasContext() {
        return currentContext.get() != null;
    }

    private static void clearContext() {
        currentContext.remove();
    }

    private static class ChildContextContainer
    implements EnrichedBlueprintVersionContextContainer {
        private final ParentContextContainer parentContextContainer;

        private ChildContextContainer(ParentContextContainer parentContextContainer) {
            this.parentContextContainer = parentContextContainer;
        }

        @Override
        public void addEnrichedBlueprintVersion(EnrichedBlueprintVersion enrichedBlueprintVersion) {
            this.parentContextContainer.addEnrichedBlueprintVersion(enrichedBlueprintVersion);
        }

        @Override
        @Nullable
        public EnrichedBlueprintVersion getEnrichedBlueprintVersion(BlueprintVersionId blueprintVersionId) {
            return this.parentContextContainer.getEnrichedBlueprintVersion(blueprintVersionId);
        }

        @Override
        public void close() {
        }
    }

    private static class ParentContextContainer
    implements EnrichedBlueprintVersionContextContainer {
        public final Map<BlueprintVersionId, EnrichedBlueprintVersion> enrichedBlueprintVersionsCacheMap = new HashMap<BlueprintVersionId, EnrichedBlueprintVersion>();

        private ParentContextContainer() {
        }

        @Override
        public void close() {
            EnrichedBlueprintVersionContext.clearContext();
        }

        @Override
        public void addEnrichedBlueprintVersion(EnrichedBlueprintVersion enrichedBlueprintVersion) {
            this.enrichedBlueprintVersionsCacheMap.put(enrichedBlueprintVersion.blueprintVersion.id, enrichedBlueprintVersion);
        }

        @Override
        @Nullable
        public EnrichedBlueprintVersion getEnrichedBlueprintVersion(BlueprintVersionId blueprintVersionId) {
            return this.enrichedBlueprintVersionsCacheMap.get(blueprintVersionId);
        }
    }

    public static interface EnrichedBlueprintVersionContextContainer
    extends AutoCloseable {
        public void addEnrichedBlueprintVersion(EnrichedBlueprintVersion var1);

        @Nullable
        public EnrichedBlueprintVersion getEnrichedBlueprintVersion(BlueprintVersionId var1);

        @Override
        public void close();
    }
}

