/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.blueprints;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.blueprints.Blueprint;
import com.dataiku.gh.core.models.blueprints.BlueprintExport;
import com.dataiku.gh.core.models.blueprints.BlueprintVersion;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionExport;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionStatus;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprint;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPath;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.ArtifactSearchSourceConfig;
import com.dataiku.gh.core.models.security.UsersContainersValidationConfig;
import com.dataiku.gh.core.models.signoff.SignoffConfiguration;
import com.dataiku.gh.core.models.ui.UIBlueprint;
import com.dataiku.gh.core.models.ui.UIBlueprintVersion;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.blueprints.BlueprintVersionsUtils;
import com.dataiku.gh.core.services.blueprints.IAdminBlueprintsService;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.mappers.IAdminUIModelsMapperService;
import com.dataiku.gh.core.services.migration_paths.IAdminBlueprintVersionMigrationPathsService;
import com.dataiku.gh.core.services.migration_paths.IBlueprintVersionMigrationPathsDataService;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.IRolesAndPermissionsService;
import com.dataiku.gh.core.services.signoff.IAdminBlueprintVersionSignoffConfigurationsService;
import com.dataiku.gh.core.services.signoff.ISignoffsDataService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.BlueprintVersionsDependencySortHelper;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.IBlueprintValidationService;
import com.dataiku.gh.core.services.validation.IBlueprintVersionValidationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.blueprints.IBlueprintDAO;
import com.dataiku.gh.core.storage.blueprints.IBlueprintVersionDAO;
import com.dataiku.gh.core.storage.blueprints.IBlueprintVersionTraceDAO;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.core.utils.ValidatorUtils;
import com.dataiku.gh.security.IPermissionsService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminBlueprintsService
implements IAdminBlueprintsService {
    @Autowired
    private IBlueprintDAO blueprintDAO;
    @Autowired
    private IBlueprintVersionDAO blueprintVersionDAO;
    @Autowired
    private IBlueprintVersionTraceDAO blueprintVersionTraceDAO;
    @Autowired
    private IBlueprintsDataService blueprintsDataService;
    @Autowired
    private IBlueprintValidationService blueprintValidationService;
    @Autowired
    private IBlueprintVersionValidationService blueprintVersionValidationService;
    @Autowired
    private IRolesAndPermissionsService rolesAndPermissionsService;
    @Autowired
    private IAdminUIModelsMapperService adminUIModelsMapperService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private ICheckPermissionsService checkPermissionsService;
    @Autowired
    private IAdminBlueprintVersionSignoffConfigurationsService adminBlueprintVersionSignoffConfigurationsService;
    @Autowired
    private IAdminBlueprintVersionMigrationPathsService adminBlueprintVersionMigrationPathsService;
    @Autowired
    private ISignoffsDataService signoffsDataService;
    @Autowired
    private IBlueprintVersionMigrationPathsDataService blueprintVersionMigrationPathsDataService;

    @Override
    @GHWriteTransaction
    public UIBlueprint createBlueprint(AuthCtx authCtx, Blueprint blueprint, String newIdentifier) throws IOException, DKUSecurityException, LimitsStatusComputer.LicenseLimitException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        this.checkPermissionsService.checkGovernBlueprintDesignerAllowedInCreation("create blueprint");
        return this.mapToUIBlueprint(authCtx, this.performBlueprintCreation(blueprint, newIdentifier));
    }

    @Override
    @GHWriteTransaction
    public UIBlueprint importBlueprintWithVersions(AuthCtx authCtx, BlueprintExport blueprintExport, UsersContainersValidationConfig.ValidationBehavior rolesImportValidationBehavior, BlueprintVersionExport.MigrationPathImportBehavior migrationPathImportBehavior) throws DKUSecurityException, IOException, LimitsStatusComputer.LicenseLimitException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        this.checkPermissionsService.checkGovernBlueprintDesignerAllowedInCreation("import blueprint");
        if (blueprintExport.blueprint == null) {
            throw new ValidationException("blueprint required");
        }
        if (StringUtils.isBlank((CharSequence)blueprintExport.blueprint.id)) {
            throw new ValidationException("blueprint.id required");
        }
        if (IdentifiersUtils.getSourceFromBlueprintId(blueprintExport.blueprint.id) != IdentifiersUtils.ItemSource.CUSTOM) {
            throw new ValidationException("Cannot import a non-custom blueprint");
        }
        String newBlueprintIdentifier = IdentifiersUtils.getIdentifierFromBlueprintId(blueprintExport.blueprint.id);
        blueprintExport.blueprint.id = null;
        List<BlueprintVersionExport> orderedBlueprintWithVersions = BlueprintVersionsDependencySortHelper.sortBlueprintVersionsWithOriginVersion(blueprintExport.blueprintVersionsWithOriginVersionId);
        EnrichedBlueprint createdBlueprint = this.performBlueprintCreation(blueprintExport.blueprint, newBlueprintIdentifier);
        for (BlueprintVersionExport blueprintVersionWithOriginVersionId : orderedBlueprintWithVersions) {
            ValidatorUtils.validateThat(Objects.equals(blueprintVersionWithOriginVersionId.blueprintVersion.id.blueprintId, createdBlueprint.blueprint.id), "The blueprint id specified in the blueprint versions must match the outer blueprint id", new Object[0]);
            String originVersionId = this.prepareOriginVersionForBlueprintVersionImport(blueprintVersionWithOriginVersionId.blueprintVersion, blueprintVersionWithOriginVersionId.originVersionId, false);
            this.performBlueprintVersionCreation(blueprintVersionWithOriginVersionId.blueprintVersion, originVersionId);
            this.performSignoffsConfigurationsImport(authCtx, blueprintVersionWithOriginVersionId, rolesImportValidationBehavior);
        }
        if (CollectionUtils.isNotEmpty(blueprintExport.migrationPaths) && migrationPathImportBehavior != BlueprintVersionExport.MigrationPathImportBehavior.IMPORT_WITHOUT_MIGRATIONS) {
            for (BlueprintVersionMigrationPath migrationPath : blueprintExport.migrationPaths) {
                this.adminBlueprintVersionMigrationPathsService.importBlueprintVersionMigrationPath(authCtx, migrationPath, blueprintExport.blueprint.id, migrationPathImportBehavior);
            }
        }
        return this.mapToUIBlueprint(authCtx, this.blueprintsDataService.getBlueprint(createdBlueprint.blueprint.id));
    }

    @Override
    @GHReadonlyTransaction
    public BlueprintExport exportBlueprintWithVersions(AuthCtx authCtx, String blueprintId) throws IOException, DKUSecurityException {
        List<BlueprintVersionMigrationPath> migrationPaths;
        this.permissionsService.checkIsGovernArchitect(authCtx);
        BlueprintExport bpAndBpvs = new BlueprintExport();
        bpAndBpvs.blueprint = this.blueprintsDataService.getBlueprint((String)blueprintId).blueprint;
        List<EnrichedBlueprintVersion> bpvs = this.blueprintsDataService.listBlueprintVersionsByBlueprint(blueprintId);
        if (CollectionUtils.isNotEmpty(bpvs)) {
            bpAndBpvs.blueprintVersionsWithOriginVersionId = bpvs.stream().map(enrichedBlueprintVersion -> BlueprintVersionExport.buildFromAndFilterUsers(enrichedBlueprintVersion, null)).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(migrationPaths = this.blueprintVersionMigrationPathsDataService.listBlueprintVersionMigrationPathsByRelatedBlueprint(blueprintId))) {
            bpAndBpvs.migrationPaths = migrationPaths;
        }
        return bpAndBpvs;
    }

    @Override
    @GHWriteTransaction
    public UIBlueprint saveBlueprint(AuthCtx authCtx, Blueprint blueprint) throws IOException, DKUSecurityException, LimitsStatusComputer.LicenseLimitException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        this.checkPermissionsService.checkGovernBlueprintDesignerAllowed();
        return this.mapToUIBlueprint(authCtx, this.performBlueprintSave(blueprint));
    }

    @Override
    @GHWriteTransaction
    public void deleteBlueprint(AuthCtx authCtx, String blueprintId) throws IOException, DKUSecurityException, LimitsStatusComputer.LicenseLimitException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        this.performBlueprintDeletion(blueprintId);
    }

    @Override
    @GHReadonlyTransaction
    public UIBlueprint getBlueprint(AuthCtx authCtx, String blueprintId) throws IOException, DKUSecurityException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        return this.mapToUIBlueprint(authCtx, this.blueprintsDataService.getBlueprint(blueprintId));
    }

    @Override
    @GHReadonlyTransaction
    public List<UIBlueprint> listBlueprints(AuthCtx authCtx) throws IOException, DKUSecurityException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        return this.mapToUIBlueprint(authCtx, this.blueprintsDataService.listBlueprints());
    }

    @Override
    @GHWriteTransaction
    public UIBlueprintVersion importBlueprintVersion(AuthCtx authCtx, BlueprintVersionExport blueprintVersionExport, boolean ignoreOriginVersionErrors, UsersContainersValidationConfig.ValidationBehavior rolesImportValidationBehavior, BlueprintVersionExport.MigrationPathImportBehavior migrationPathImportBehavior) throws IOException, DKUSecurityException, LimitsStatusComputer.LicenseLimitException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        this.checkPermissionsService.checkGovernBlueprintDesignerAllowedInCreation("import blueprint version");
        ValidatorUtils.validateThat(blueprintVersionExport != null, "blueprintVersionWithOriginVersion is required", new Object[0]);
        ValidatorUtils.validateThat(blueprintVersionExport.blueprintVersion != null, "blueprintVersion is required", new Object[0]);
        ValidatorUtils.validateThat(blueprintVersionExport.blueprintVersion.id != null, "blueprintVersion.id is required", new Object[0]);
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)blueprintVersionExport.blueprintVersion.id.blueprintId), "blueprintVersion.id.blueprintId is required", new Object[0]);
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)blueprintVersionExport.blueprintVersion.id.versionId), "blueprintVersion.id.versionId is required", new Object[0]);
        String originVersionId = this.prepareOriginVersionForBlueprintVersionImport(blueprintVersionExport.blueprintVersion, blueprintVersionExport.originVersionId, ignoreOriginVersionErrors);
        this.performBlueprintVersionCreation(blueprintVersionExport.blueprintVersion, originVersionId);
        this.performSignoffsConfigurationsImport(authCtx, blueprintVersionExport, rolesImportValidationBehavior);
        if (CollectionUtils.isNotEmpty(blueprintVersionExport.migrationPaths) && migrationPathImportBehavior != BlueprintVersionExport.MigrationPathImportBehavior.IMPORT_WITHOUT_MIGRATIONS) {
            for (BlueprintVersionMigrationPath migrationPath : blueprintVersionExport.migrationPaths) {
                this.adminBlueprintVersionMigrationPathsService.importBlueprintVersionMigrationPath(authCtx, migrationPath, blueprintVersionExport.blueprintVersion.id.blueprintId, migrationPathImportBehavior);
            }
        }
        return this.mapToUIBlueprintVersion(authCtx, this.blueprintsDataService.getBlueprintVersion(blueprintVersionExport.blueprintVersion.id));
    }

    @Override
    @GHReadonlyTransaction
    public BlueprintVersionExport exportBlueprintVersion(AuthCtx authCtx, BlueprintVersionId blueprintVersionId) throws IOException, DKUSecurityException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        EnrichedBlueprintVersion bpv = this.blueprintsDataService.getBlueprintVersion(blueprintVersionId);
        List<BlueprintVersionMigrationPath> migrationPaths = this.blueprintVersionMigrationPathsDataService.listBlueprintVersionMigrationPathsByRelatedBlueprintVersion(blueprintVersionId);
        return BlueprintVersionExport.buildFromAndFilterUsers(bpv, migrationPaths);
    }

    @Override
    @GHWriteTransaction
    public UIBlueprintVersion createBlueprintVersion(AuthCtx authCtx, String blueprintId, String newIdentifier, @Nullable String name, @Nullable String originVersionId, @Nullable BlueprintVersion.IconSettings iconSettings) throws IOException, DKUSecurityException, LimitsStatusComputer.LicenseLimitException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        this.checkPermissionsService.checkGovernBlueprintDesignerAllowedInCreation("create blueprint version");
        BlueprintVersion blueprintVersion = this.prepareBlueprintVersionForCreation(blueprintId, newIdentifier, name, originVersionId, iconSettings);
        this.performBlueprintVersionCreation(blueprintVersion, originVersionId);
        this.performSignoffsConfigurationsCopyFromOrigin(originVersionId, blueprintVersion);
        return this.mapToUIBlueprintVersion(authCtx, this.blueprintsDataService.getBlueprintVersion(blueprintVersion.id));
    }

    @Override
    @GHWriteTransaction
    public UIBlueprintVersion saveBlueprintVersion(AuthCtx authCtx, BlueprintVersion blueprintVersion, boolean dangerZoneAccepted) throws IOException, DKUSecurityException, LimitsStatusComputer.LicenseLimitException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        this.checkPermissionsService.checkGovernBlueprintDesignerAllowed();
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.performBlueprintVersionSave(blueprintVersion, dangerZoneAccepted);
        return this.mapToUIBlueprintVersion(authCtx, enrichedBlueprintVersion);
    }

    @Override
    @GHWriteTransaction
    public UIBlueprintVersion updateBlueprintVersionStatus(AuthCtx authCtx, BlueprintVersionId blueprintVersionId, BlueprintVersionStatus blueprintVersionStatus) throws IOException, DKUSecurityException, LimitsStatusComputer.LicenseLimitException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        this.checkPermissionsService.checkGovernBlueprintDesignerAllowed();
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.performBlueprintVersionStatusUpdate(blueprintVersionId, blueprintVersionStatus);
        return this.mapToUIBlueprintVersion(authCtx, enrichedBlueprintVersion);
    }

    @Override
    @GHWriteTransaction
    public void deleteBlueprintVersion(AuthCtx authCtx, BlueprintVersionId blueprintVersionId) throws IOException, DKUSecurityException, LimitsStatusComputer.LicenseLimitException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        this.performBlueprintVersionDeletion(blueprintVersionId);
    }

    @Override
    @GHWriteTransaction
    public UIBlueprintVersion getBlueprintVersion(AuthCtx authCtx, BlueprintVersionId blueprintVersionId) throws IOException, DKUSecurityException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.blueprintsDataService.getBlueprintVersion(blueprintVersionId);
        return this.mapToUIBlueprintVersion(authCtx, enrichedBlueprintVersion);
    }

    @Override
    @GHReadonlyTransaction
    public List<UIBlueprintVersion> listBlueprintVersions(AuthCtx authCtx) throws IOException, DKUSecurityException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        return this.mapToUIBlueprintVersions(authCtx, this.blueprintsDataService.listBlueprintVersions());
    }

    @Override
    @GHReadonlyTransaction
    public List<UIBlueprintVersion> listBlueprintVersionsByBlueprint(AuthCtx authCtx, String blueprintId) throws IOException, DKUSecurityException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        return this.mapToUIBlueprintVersions(authCtx, this.blueprintsDataService.listBlueprintVersionsByBlueprint(blueprintId));
    }

    @Override
    @GHReadonlyTransaction
    public long countBlueprintVersionExistingArtifacts(AuthCtx authCtx, BlueprintVersionId blueprintVersionId) throws IOException, DKUSecurityException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        return this.artifactsDataService.searchArtifactsCount(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), Collections.singletonList(ArtifactFilter.BlueprintVersionsArtifactFilter.build(blueprintVersionId)));
    }

    private EnrichedBlueprint performBlueprintCreation(Blueprint blueprint, String newIdentifier) throws IOException {
        if (blueprint.id != null) {
            throw new ValidationException("blueprint.id `" + blueprint.id + "` cannot be set in creation");
        }
        blueprint.id = IdentifiersUtils.buildBlueprintIdForCustom(newIdentifier);
        if (this.blueprintDAO.exists(blueprint.id)) {
            throw new ValidationException("Blueprint ID already exists: " + blueprint.id);
        }
        return this.storeBlueprint(blueprint, true);
    }

    private EnrichedBlueprint performBlueprintSave(Blueprint blueprint) throws IOException {
        if (StringUtils.isBlank((CharSequence)blueprint.id)) {
            throw new ValidationException("blueprint.id is required");
        }
        if (IdentifiersUtils.getSourceFromBlueprintId(blueprint.id) != IdentifiersUtils.ItemSource.CUSTOM && !"1".equals(System.getenv("DSS_DEV"))) {
            throw new ValidationException("Cannot edit a non-custom blueprint with id: " + blueprint.id);
        }
        if (!this.blueprintDAO.exists(blueprint.id)) {
            throw new NotFoundException("Cannot find blueprint: " + blueprint.id);
        }
        return this.storeBlueprint(blueprint, false);
    }

    private void performBlueprintDeletion(String blueprintId) throws IOException {
        if (StringUtils.isBlank((CharSequence)blueprintId)) {
            throw new ValidationException("blueprint.id is required");
        }
        if (IdentifiersUtils.getSourceFromBlueprintId(blueprintId) != IdentifiersUtils.ItemSource.CUSTOM && !"1".equals(System.getenv("DSS_DEV"))) {
            throw new ValidationException("Cannot delete a non-custom blueprint with id: " + blueprintId);
        }
        if (CollectionUtils.isNotEmpty(this.blueprintsDataService.listBlueprintVersionsByBlueprint(blueprintId))) {
            throw new ValidationException("Cannot delete a blueprint with id: " + blueprintId + " that still has versions");
        }
        this.blueprintsDataService.deleteBlueprint(blueprintId);
    }

    private EnrichedBlueprint storeBlueprint(Blueprint blueprint, boolean creation) throws IOException {
        this.blueprintValidationService.validateBlueprint(blueprint);
        return this.blueprintsDataService.storeBlueprint(blueprint, creation);
    }

    private String prepareOriginVersionForBlueprintVersionImport(BlueprintVersion blueprintVersion, String originVersionId, boolean ignoreOriginVersionErrors) throws IOException {
        BlueprintVersionId originBlueprintVersionId;
        if (StringUtils.isNotBlank((CharSequence)originVersionId) && !this.blueprintVersionDAO.exists(originBlueprintVersionId = BlueprintVersionId.build(blueprintVersion.id.blueprintId, originVersionId))) {
            if (ignoreOriginVersionErrors) {
                return null;
            }
            throw new NotFoundException("Origin blueprint version not found: " + originVersionId);
        }
        return originVersionId;
    }

    private BlueprintVersion prepareBlueprintVersionForCreation(String blueprintId, String newIdentifier, @Nullable String name, @Nullable String originVersionId, @Nullable BlueprintVersion.IconSettings iconSettings) throws IOException {
        BlueprintVersion blueprintVersion;
        BlueprintVersionId blueprintVersionId = BlueprintVersionId.build(blueprintId, IdentifiersUtils.buildBlueprintVersionIdForCustom(newIdentifier));
        if (originVersionId != null) {
            BlueprintVersionId originBlueprintVersionId = BlueprintVersionId.build(blueprintId, originVersionId);
            EnrichedBlueprintVersion enrichedBlueprintVersionOrigin = (EnrichedBlueprintVersion)this.blueprintVersionDAO.getOrNull(originBlueprintVersionId);
            if (enrichedBlueprintVersionOrigin == null) {
                throw new NotFoundException("Origin blueprint version not found: " + originVersionId);
            }
            blueprintVersion = (BlueprintVersion)JSON.deepCopy((Object)enrichedBlueprintVersionOrigin.blueprintVersion);
        } else {
            blueprintVersion = new BlueprintVersion();
        }
        blueprintVersion.id = blueprintVersionId;
        blueprintVersion.name = name;
        blueprintVersion.updateIconSettings(iconSettings);
        return blueprintVersion;
    }

    private void performBlueprintVersionCreation(BlueprintVersion blueprintVersion, @Nullable String originVersionId) throws IOException {
        BlueprintVersionId blueprintVersionId = blueprintVersion.id;
        if (SystemProvidedConstants.isArtifactsSystemLockEnabledForBlueprint(blueprintVersionId.blueprintId)) {
            throw new ValidationException("Cannot create a locked system blueprint");
        }
        if (IdentifiersUtils.getSourceFromBlueprintVersionId(blueprintVersionId.versionId) != IdentifiersUtils.ItemSource.CUSTOM) {
            throw new ValidationException("Cannot create a non-custom blueprint version");
        }
        if (!this.blueprintDAO.exists(blueprintVersionId.blueprintId)) {
            throw new NotFoundException("Blueprint not found: " + blueprintVersionId.blueprintId);
        }
        if (this.blueprintVersionDAO.exists(blueprintVersionId) || this.blueprintVersionTraceDAO.exists(blueprintVersionId)) {
            throw new ValidationException("Blueprint version ID already exists: " + String.valueOf(blueprintVersionId));
        }
        this.blueprintVersionValidationService.validateBlueprintVersion(blueprintVersion);
        this.blueprintsDataService.createBlueprintVersion(blueprintVersion, originVersionId);
    }

    private EnrichedBlueprintVersion performBlueprintVersionSave(BlueprintVersion blueprintVersion, boolean dangerZoneAccepted) throws IOException {
        if (blueprintVersion.id == null) {
            throw new ValidationException("blueprintVersion.id is required");
        }
        if (BlueprintVersionsUtils.blueprintVersionIsNotEditable(blueprintVersion.id)) {
            throw new ValidationException("Cannot edit a non-custom blueprint version with id: " + String.valueOf(blueprintVersion.id));
        }
        if (!this.blueprintVersionDAO.exists(blueprintVersion.id) || !this.blueprintVersionTraceDAO.exists(blueprintVersion.id)) {
            throw new NotFoundException("Blueprint version not found: " + String.valueOf(blueprintVersion.id));
        }
        this.blueprintVersionValidationService.validateBlueprintVersion(blueprintVersion);
        return this.blueprintsDataService.saveBlueprintVersion(blueprintVersion, dangerZoneAccepted);
    }

    private EnrichedBlueprintVersion performBlueprintVersionStatusUpdate(BlueprintVersionId blueprintVersionId, BlueprintVersionStatus blueprintVersionStatus) throws IOException {
        if (blueprintVersionId == null) {
            throw new ValidationException("blueprintVersion.id is required");
        }
        if (StringUtils.isBlank((CharSequence)blueprintVersionId.blueprintId)) {
            throw new ValidationException("blueprintVersion.id.blueprintId is required");
        }
        if (StringUtils.isBlank((CharSequence)blueprintVersionId.versionId)) {
            throw new ValidationException("blueprintVersion.id.versionId is required");
        }
        if (blueprintVersionStatus == null) {
            throw new ValidationException("blueprintVersionStatus is required for blueprint version with id: " + String.valueOf(blueprintVersionId));
        }
        if (blueprintVersionStatus == BlueprintVersionStatus.DRAFT) {
            throw new ValidationException("Cannot set back a blueprint version in draft mode with id: " + String.valueOf(blueprintVersionId));
        }
        if (!this.blueprintVersionDAO.exists(blueprintVersionId) || !this.blueprintVersionTraceDAO.exists(blueprintVersionId)) {
            throw new NotFoundException("Blueprint version not found: " + String.valueOf(blueprintVersionId));
        }
        return this.blueprintsDataService.updateBlueprintVersionStatus(blueprintVersionId, blueprintVersionStatus);
    }

    private void performBlueprintVersionDeletion(BlueprintVersionId blueprintVersionId) throws IOException {
        if (blueprintVersionId == null) {
            throw new ValidationException("blueprintVersion.id is required");
        }
        if (StringUtils.isBlank((CharSequence)blueprintVersionId.blueprintId)) {
            throw new ValidationException("blueprintVersion.id.blueprintId is required");
        }
        if (StringUtils.isBlank((CharSequence)blueprintVersionId.versionId)) {
            throw new ValidationException("blueprintVersion.id.versionId is required");
        }
        if (BlueprintVersionsUtils.blueprintVersionIsNotEditable(blueprintVersionId)) {
            throw new ValidationException("Cannot delete a non-custom blueprint version with id: " + String.valueOf(blueprintVersionId));
        }
        if (!this.blueprintVersionDAO.exists(blueprintVersionId) || !this.blueprintVersionTraceDAO.exists(blueprintVersionId)) {
            throw new NotFoundException("Blueprint version not found: " + String.valueOf(blueprintVersionId));
        }
        if (!this.blueprintVersionMigrationPathsDataService.listBlueprintVersionMigrationPathsByRelatedBlueprintVersion(blueprintVersionId).isEmpty()) {
            throw new ValidationException("This blueprint version has existing migration paths related to it: " + String.valueOf(blueprintVersionId));
        }
        this.blueprintsDataService.deleteBlueprintVersion(blueprintVersionId);
    }

    private UIBlueprint mapToUIBlueprint(AuthCtx authCtx, EnrichedBlueprint enrichedBlueprint) throws IOException {
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtBlueprintLevel(authCtx, enrichedBlueprint);
        return this.adminUIModelsMapperService.mapEnrichedBlueprintToUIBlueprint(assignedRolesAndPermissionsCtx, enrichedBlueprint);
    }

    private List<UIBlueprint> mapToUIBlueprint(AuthCtx authCtx, List<EnrichedBlueprint> enrichedBlueprints) throws IOException {
        ArrayList<UIBlueprint> uiBlueprints = new ArrayList<UIBlueprint>();
        for (EnrichedBlueprint enrichedBlueprint : enrichedBlueprints) {
            uiBlueprints.add(this.mapToUIBlueprint(authCtx, enrichedBlueprint));
        }
        return uiBlueprints;
    }

    private UIBlueprintVersion mapToUIBlueprintVersion(AuthCtx authCtx, EnrichedBlueprintVersion enrichedBlueprintVersion) throws IOException {
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtBlueprintVersionLevel(authCtx, enrichedBlueprintVersion);
        return this.adminUIModelsMapperService.mapEnrichedBlueprintVersionToUIBlueprintVersion(assignedRolesAndPermissionsCtx, enrichedBlueprintVersion);
    }

    private List<UIBlueprintVersion> mapToUIBlueprintVersions(AuthCtx authCtx, List<EnrichedBlueprintVersion> enrichedBlueprintVersions) throws IOException {
        ArrayList<UIBlueprintVersion> uiBlueprintVersions = new ArrayList<UIBlueprintVersion>();
        for (EnrichedBlueprintVersion enrichedBlueprintVersion : enrichedBlueprintVersions) {
            uiBlueprintVersions.add(this.mapToUIBlueprintVersion(authCtx, enrichedBlueprintVersion));
        }
        return uiBlueprintVersions;
    }

    private void performSignoffsConfigurationsCopyFromOrigin(String originVersionId, BlueprintVersion blueprintVersion) throws IOException {
        if (originVersionId != null) {
            BlueprintVersionId originBlueprintVersionId = BlueprintVersionId.build(blueprintVersion.id.blueprintId, originVersionId);
            EnrichedBlueprintVersion originBlueprintVersion = this.blueprintsDataService.getBlueprintVersion(originBlueprintVersionId);
            if (CollectionUtils.isNotEmpty(originBlueprintVersion.signoffsConfigurations)) {
                originBlueprintVersion.signoffsConfigurations.forEach(signoffConfiguration -> {
                    signoffConfiguration.id.blueprintVersionId = blueprintVersion.id;
                });
                this.signoffsDataService.storeSignoffsConfigurations(originBlueprintVersion.signoffsConfigurations, true);
            }
        }
    }

    private void performSignoffsConfigurationsImport(AuthCtx authCtx, BlueprintVersionExport blueprintVersionWithOriginVersionId, UsersContainersValidationConfig.ValidationBehavior rolesImportValidationBehavior) throws LimitsStatusComputer.LicenseLimitException, DKUSecurityException, IOException {
        if (CollectionUtils.isNotEmpty(blueprintVersionWithOriginVersionId.signoffsConfigurations)) {
            for (SignoffConfiguration signoffConfiguration : blueprintVersionWithOriginVersionId.signoffsConfigurations) {
                ValidatorUtils.validateThat(signoffConfiguration.id != null, "signoffConfiguration.id is mandatory", new Object[0]);
                ValidatorUtils.validateThat(blueprintVersionWithOriginVersionId.blueprintVersion.id.equals(signoffConfiguration.id.blueprintVersionId), "The blueprint version id specified in the sign-off configuration must match the outer blueprint version id", new Object[0]);
                this.adminBlueprintVersionSignoffConfigurationsService.importSignoffConfiguration(authCtx, signoffConfiguration, rolesImportValidationBehavior);
            }
        }
    }
}

