/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.dss.govern;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.dss.DSSProjectArtifactsContainer;
import com.dataiku.gh.core.models.dss.DataikuDeploymentSourceObjects;
import com.dataiku.gh.core.models.dss.DataikuSourceObjects;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.ArtifactSearchSourceConfig;
import com.dataiku.gh.core.models.subscriptions.Subscription;
import com.dataiku.gh.core.models.system.SystemProvidedEnrichedBlueprint;
import com.dataiku.gh.core.models.ui.UIArtifact;
import com.dataiku.gh.core.models.ui.UIGetArtifactsResult;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.artifacts.IArtifactsService;
import com.dataiku.gh.core.services.dss.govern.IDSSIntegrationService;
import com.dataiku.gh.core.services.dss.search_artifacts.DSSIntegrationArtifactsSearchQueryBuilder;
import com.dataiku.gh.core.services.dss.search_artifacts.DSSIntegrationUtils;
import com.dataiku.gh.core.services.dss.sync.DSSObjectsToArtifactMapperService;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.IRolesAndPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.context.UserRolesCacheContext;
import com.dataiku.gh.core.services.subscriptions.ISubscriptionsService;
import com.dataiku.gh.core.services.system.ISystemArtifactService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.utils.Either;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DSSIntegrationService
implements IDSSIntegrationService {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.services.dss-integration-govern");
    @Autowired
    private ISystemArtifactService systemArtifactService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IArtifactsService artifactsService;
    @Autowired
    private IRolesAndPermissionsService rolesAndPermissionsService;
    @Autowired
    private ICheckPermissionsService checkPermissionsService;
    @Autowired
    private ISubscriptionsService subscriptionsService;

    @Override
    @GHWriteTransaction
    public void archiveGovernArtifact(String id) throws IOException {
        this.systemArtifactService.updateSystemArtifact(id, ea -> {
            ea.artifact.status.archived = true;
            ea.artifact.fields.remove("business_initiative");
            ea.artifact.fields.remove("govern_project");
            ea.artifact.fields.remove("govern_project");
            ea.artifact.fields.remove("govern_project");
            ea.artifact.fields.remove("govern_model");
        }, null);
    }

    @Override
    @GHWriteTransaction
    public List<UIArtifact> listRelatedProjects(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        Set governProjectArtifactIds;
        EnrichedArtifact enrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authCtx, enrichedArtifact);
        this.checkPermissionsService.checkArtifactReadPermission(authCtx, assignedRolesAndPermissionsCtx.effectivePermissionsItem, artifactId);
        if (!SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(enrichedArtifact.blueprintVersion.id)) {
            throw new ValidationException("Cannot list related projects of a non-project with blueprint version ID `" + String.valueOf(enrichedArtifact.blueprintVersion.id) + "` and with artifact ID `" + artifactId + "`");
        }
        Object isAutomationFieldValue = enrichedArtifact.artifact.fields.get("automation_node");
        boolean isAutomation = isAutomationFieldValue instanceof Boolean && (Boolean)isAutomationFieldValue != false;
        String nodeId = null;
        String projectKey = null;
        ArrayList dataikuProjects = Lists.newArrayList();
        if (isAutomation) {
            Object originalNodeId = enrichedArtifact.artifact.fields.get("original_node_id");
            Object originalProjectKey = enrichedArtifact.artifact.fields.get("original_project_key");
            if (originalNodeId instanceof String && originalProjectKey instanceof String && StringUtils.isNotBlank((CharSequence)((String)originalNodeId)) && StringUtils.isNotBlank((CharSequence)((String)originalProjectKey))) {
                nodeId = (String)originalNodeId;
                projectKey = (String)originalProjectKey;
                ArrayList<ArtifactFilter> filters = new ArrayList<ArtifactFilter>();
                filters.add(DSSIntegrationArtifactsSearchQueryBuilder.buildBlueprintFilter(SystemProvidedConstants.DATAIKU_PROJECT));
                filters.add(ArtifactFilter.ArchivedStatusArtifactFilter.build(false));
                filters.add(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("node_id", nodeId, false, false));
                filters.add(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("project_key", projectKey, false, false));
                filters.add(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("automation_node", "true", true, false));
                try (Stream<EnrichedArtifact> searchResult = this.artifactsDataService.searchArtifactsStream(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), filters, null, null);){
                    dataikuProjects.addAll(searchResult.collect(Collectors.toList()));
                }
            } else {
                dataikuProjects.add(enrichedArtifact);
            }
        } else {
            nodeId = (String)enrichedArtifact.artifact.fields.get("node_id");
            projectKey = (String)enrichedArtifact.artifact.fields.get("project_key");
            dataikuProjects.add(enrichedArtifact);
        }
        if (StringUtils.isNotBlank((CharSequence)nodeId) && StringUtils.isNotBlank((CharSequence)projectKey)) {
            ArrayList<ArtifactFilter> filters = new ArrayList<ArtifactFilter>();
            filters.add(DSSIntegrationArtifactsSearchQueryBuilder.buildBlueprintFilter(SystemProvidedConstants.DATAIKU_PROJECT));
            filters.add(ArtifactFilter.ArchivedStatusArtifactFilter.build(false));
            filters.add(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("original_node_id", nodeId, false, false));
            filters.add(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("original_project_key", projectKey, false, false));
            filters.add(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("automation_node", "true", false, false));
            try (Stream<EnrichedArtifact> searchResult = this.artifactsDataService.searchArtifactsStream(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), filters, null, null);){
                dataikuProjects.addAll(searchResult.collect(Collectors.toList()));
            }
        }
        if (CollectionUtils.isEmpty(governProjectArtifactIds = dataikuProjects.stream().map(ea -> (String)ea.artifact.fields.get("governed_by")).filter(StringUtils::isNotBlank).collect(Collectors.toSet()))) {
            return Collections.emptyList();
        }
        return UIGetArtifactsResult.build(this.artifactsService.getArtifactsOrExceptions((AuthCtx)authCtx, (List<String>)Lists.newArrayList(governProjectArtifactIds), (Boolean)Boolean.valueOf((boolean)false))).uiArtifacts;
    }

    @Override
    @GHWriteTransaction
    public DataikuSourceObjects getDataikuSources(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        DataikuSourceObjects dataikuSourceObjects;
        block16: {
            EnrichedArtifact enrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
            dataikuSourceObjects = new DataikuSourceObjects();
            try (UserRolesCacheContext.ContextContainer rolesCache = UserRolesCacheContext.attachNewContext();){
                AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authCtx, enrichedArtifact);
                this.checkPermissionsService.checkArtifactReadPermission(authCtx, assignedRolesAndPermissionsCtx.effectivePermissionsItem, artifactId);
                if (SystemProvidedConstants.isGovernBlueprint(enrichedArtifact.blueprint.id)) {
                    List<String> dataikuArtifactsIds = enrichedArtifact.artifact.fields.getOrDefault("dataiku_item", Collections.emptyList());
                    try (Stream<EnrichedArtifact> searchResult = this.artifactsDataService.searchArtifactsStream(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), Arrays.asList(ArtifactFilter.ArtifactsArtifactFilter.build(dataikuArtifactsIds), ArtifactFilter.ArchivedStatusArtifactFilter.build(false)), null, null);){
                        List dataikuArtifacts = searchResult.collect(Collectors.toList());
                        for (EnrichedArtifact dataikuUIArtifact : dataikuArtifacts) {
                            DataikuSourceObjects.DataikuSourceProject dataikuSourceProjectFromDataikuObjectWithReadPermissions = this.getDataikuSourceProjectFromDataikuObjectWithReadPermissions(authCtx, dataikuUIArtifact.artifact);
                            if (dataikuSourceProjectFromDataikuObjectWithReadPermissions == null) continue;
                            dataikuSourceObjects.dataikuSourceProjects.add(dataikuSourceProjectFromDataikuObjectWithReadPermissions);
                        }
                        break block16;
                    }
                }
                if (SystemProvidedConstants.isDataikuProjectItemBlueprint(enrichedArtifact.blueprint.id)) {
                    DataikuSourceObjects.DataikuSourceProject dataikuSourceProjectFromDataikuObjectWithReadPermissions = this.getDataikuSourceProjectFromDataikuObjectWithReadPermissions(authCtx, enrichedArtifact.artifact);
                    if (dataikuSourceProjectFromDataikuObjectWithReadPermissions != null) {
                        dataikuSourceObjects.dataikuSourceProjects.add(dataikuSourceProjectFromDataikuObjectWithReadPermissions);
                    }
                    break block16;
                }
                throw new ValidationException("Invalid artifact to get Dataiku sources from, blueprint ID `" + enrichedArtifact.blueprint.id + "`, artifact ID `" + artifactId + "`");
            }
        }
        return dataikuSourceObjects;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @GHWriteTransaction
    public DataikuDeploymentSourceObjects getDataikuDeploymentSources(AuthCtx authCtx, String artifactId) throws DKUSecurityException, IOException {
        EnrichedArtifact deployableArtifact = this.artifactsDataService.getArtifact(artifactId);
        try (UserRolesCacheContext.ContextContainer rolesCache = UserRolesCacheContext.attachNewContext();){
            DataikuDeploymentSourceObjects dataikuDeploymentSourceObjects;
            List<String> deploymentArtifactIds;
            AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authCtx, deployableArtifact);
            this.checkPermissionsService.checkArtifactReadPermission(authCtx, assignedRolesAndPermissionsCtx.effectivePermissionsItem, artifactId);
            DataikuDeploymentSourceObjects dataikuDeploymentSourceObjects2 = new DataikuDeploymentSourceObjects();
            if (SystemProvidedConstants.isGovernDeployableBlueprint(deployableArtifact.blueprint.id)) {
                List dataikuArtifactIdList = deployableArtifact.artifact.fields.getOrDefault("dataiku_item", Collections.emptyList());
                if (dataikuArtifactIdList.isEmpty()) {
                    throw new IllegalStateException("Impossible to retrieve the link to the related dataiku item for artifact: " + deployableArtifact.artifact.id);
                }
                if (dataikuArtifactIdList.size() > 1) {
                    logger.warnV("Found more than one dataiku item for this govern artifact: " + deployableArtifact.artifact.id, new Object[0]);
                }
                String dataikuArtifactId = (String)dataikuArtifactIdList.get(0);
                deployableArtifact = this.artifactsDataService.getArtifact(dataikuArtifactId);
                if (!SystemProvidedConstants.isDataikuDeployableBlueprint(deployableArtifact.blueprint.id)) {
                    throw new ValidationException("Invalid related dataiku artifact to get deployments from, related dataiku blueprint ID: " + deployableArtifact.blueprint.id + ", related dataiku artifact ID: " + deployableArtifact.artifact.id + ", requested govern artifact ID: " + artifactId);
                }
            } else if (!SystemProvidedConstants.isDataikuDeployableBlueprint(deployableArtifact.blueprint.id)) {
                throw new ValidationException("Invalid artifact to get deployments from, blueprint ID: " + deployableArtifact.blueprint.id + ", artifact ID: " + deployableArtifact.artifact.id);
            }
            if ((deploymentArtifactIds = deployableArtifact.artifact.fields.getOrDefault("deployments", Collections.emptyList())).isEmpty()) {
                dataikuDeploymentSourceObjects = dataikuDeploymentSourceObjects2;
                return dataikuDeploymentSourceObjects;
            }
            dataikuDeploymentSourceObjects = this.getDataikuDeploymentSourcesFromSearch(authCtx, dataikuDeploymentSourceObjects2, deploymentArtifactIds);
            return dataikuDeploymentSourceObjects;
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }

    private DataikuDeploymentSourceObjects getDataikuDeploymentSourcesFromSearch(AuthCtx authCtx, DataikuDeploymentSourceObjects dataikuDeploymentSourceObjects, List<String> deploymentArtifactIds) throws IOException {
        Map infraMap;
        Set infraArtifactIds;
        List deploymentArtifacts;
        Map<String, Subscription.SubscriptionLevel> subscriptions = this.subscriptionsService.getSubscriptionsMapForUser(authCtx);
        try (Stream<EnrichedArtifact> deploymentsResults = this.artifactsDataService.searchArtifactsStream(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), Arrays.asList(ArtifactFilter.ArtifactsArtifactFilter.build(deploymentArtifactIds), ArtifactFilter.ArchivedStatusArtifactFilter.build(false)), null, null);){
            deploymentArtifacts = deploymentsResults.map(enrichedArtifact -> ImmutablePair.of(this.artifactsService.mapToUIArtifactsOrUIArtifactException_NoLicenseCheck_UncheckedIOException(authCtx, (EnrichedArtifact)enrichedArtifact, (Subscription.SubscriptionLevel)((Object)((Object)subscriptions.get(enrichedArtifact.artifact.id)))), (Object)((String)enrichedArtifact.artifact.fields.get("infrastructure")))).filter(pair -> ((Either)pair.getLeft()).isRight()).map(pair -> ImmutablePair.of((Object)((UIArtifact)((Either)pair.getLeft()).getRight()), (Object)((String)pair.getRight()))).collect(Collectors.toList());
            infraArtifactIds = deploymentArtifacts.stream().map(Pair::getRight).collect(Collectors.toSet());
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
        try (Stream<EnrichedArtifact> infrastructureResults = this.artifactsDataService.searchArtifactsStream(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), Arrays.asList(ArtifactFilter.ArtifactsArtifactFilter.build(Lists.newArrayList(infraArtifactIds)), ArtifactFilter.ArchivedStatusArtifactFilter.build(false)), null, null);){
            infraMap = infrastructureResults.map(enrichedArtifact -> this.artifactsService.mapToUIArtifactsOrUIArtifactException_NoLicenseCheck_UncheckedIOException(authCtx, (EnrichedArtifact)enrichedArtifact, (Subscription.SubscriptionLevel)((Object)((Object)subscriptions.get(enrichedArtifact.artifact.id))))).filter(Either::isRight).map(Either::getRight).collect(Collectors.toMap(infra -> infra.artifact.id, Function.identity()));
        }
        for (Pair deploymentArtifact : deploymentArtifacts) {
            DataikuDeploymentSourceObjects.UIDeployment uiDeployment = new DataikuDeploymentSourceObjects.UIDeployment();
            UIArtifact relatedInfra = (UIArtifact)infraMap.get(deploymentArtifact.getRight());
            if (relatedInfra == null || !(relatedInfra.artifact.fields.get("stage") instanceof String)) continue;
            uiDeployment.stageId = (String)relatedInfra.artifact.fields.get("stage");
            uiDeployment.infrastructure = relatedInfra;
            uiDeployment.deployment = (UIArtifact)deploymentArtifact.getLeft();
            dataikuDeploymentSourceObjects.deployments.add(uiDeployment);
        }
        return dataikuDeploymentSourceObjects;
    }

    @Nullable
    private DataikuSourceObjects.DataikuSourceProject getDataikuSourceProjectFromDataikuObjectWithReadPermissions(AuthCtx authCtx, Artifact dataikuArtifact) throws IOException {
        ArrayList<EnrichedArtifact> artifactsWithReadPermissions = new ArrayList<EnrichedArtifact>();
        List<ArtifactFilter> filters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters(DSSObjectsToArtifactMapperService.getProjectIdentifierFromDataikuProjectItemArtifact(dataikuArtifact), (List<SystemProvidedEnrichedBlueprint>)Lists.newArrayList(SystemProvidedConstants.DATAIKU_PROJECT_ITEMS_SYSTEM_BLUEPRINT_BY_ID.values()), (List<ArtifactFilter>)Lists.newArrayList((Object[])new ArtifactFilter[]{ArtifactFilter.ArchivedStatusArtifactFilter.build(false)}));
        try (Stream<EnrichedArtifact> searchResults = this.artifactsDataService.searchArtifactsStream(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), filters, null, null);){
            searchResults.filter(enrichedArtifact -> this.hasArtifactReadPermission_UncheckedIOException(authCtx, (EnrichedArtifact)enrichedArtifact)).forEach(artifactsWithReadPermissions::add);
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
        if (artifactsWithReadPermissions.isEmpty()) {
            return null;
        }
        DSSProjectArtifactsContainer container = DSSIntegrationUtils.mapSearchResultToDSSContainer(artifactsWithReadPermissions);
        return DSSIntegrationUtils.mapDSSProjectContainerToDataikuObjectSources(container);
    }

    private boolean hasArtifactReadPermission_UncheckedIOException(AuthCtx authCtx, EnrichedArtifact enrichedArtifact) {
        try {
            AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authCtx, enrichedArtifact);
            return this.checkPermissionsService.hasArtifactReadPermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

