/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.export;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.files.MimeTypeUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.artifacts.ArtifactWorkflowStep;
import com.dataiku.gh.core.models.artifacts.Attachments;
import com.dataiku.gh.core.models.blueprints.BlueprintVersion;
import com.dataiku.gh.core.models.blueprints.StepDefinition;
import com.dataiku.gh.core.models.blueprints.ui.UIStepDefinition;
import com.dataiku.gh.core.models.blueprints.ui.View;
import com.dataiku.gh.core.models.blueprints.ui.view_components.types.FieldViewComponent;
import com.dataiku.gh.core.models.commons.ArtifactTableColumn;
import com.dataiku.gh.core.models.commons.BlueprintIdViewIdPair;
import com.dataiku.gh.core.models.custom_pages.ArtifactKanbanViewCustomPage;
import com.dataiku.gh.core.models.custom_pages.ArtifactMatrixCustomPage;
import com.dataiku.gh.core.models.custom_pages.ArtifactSearchSettings;
import com.dataiku.gh.core.models.custom_pages.ArtifactTableCustomPage;
import com.dataiku.gh.core.models.custom_pages.CustomHTMLCustomPage;
import com.dataiku.gh.core.models.export.ExportFile;
import com.dataiku.gh.core.models.export.ExportType;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.ArtifactSearchPagination;
import com.dataiku.gh.core.models.search.ArtifactSearchQuery;
import com.dataiku.gh.core.models.ui.UIArtifact;
import com.dataiku.gh.core.services.artifacts.IArtifactsService;
import com.dataiku.gh.core.services.blueprints.IBlueprintsService;
import com.dataiku.gh.core.services.custom_pages.ICustomPagesService;
import com.dataiku.gh.core.services.export.ArtifactExportRow;
import com.dataiku.gh.core.services.export.FieldDefinitionExportVisitor;
import com.dataiku.gh.core.services.export.IExportService;
import com.dataiku.gh.core.services.export.writers.ArtifactExportCSVWriter;
import com.dataiku.gh.core.services.export.writers.ArtifactExportPDFWriter;
import com.dataiku.gh.core.services.export.writers.CustomPageExportWriter;
import com.dataiku.gh.core.services.export.writers.IArtifactExportWriter;
import com.dataiku.gh.core.services.uploaded_files.IUploadedFilesService;
import com.dataiku.gh.core.visitors.IBlueprintVersionVisitor;
import com.dataiku.gh.core.visitors.ICustomPageVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportService
implements IExportService {
    @Autowired
    private IArtifactsService artifactsService;
    @Autowired
    private IUploadedFilesService uploadedFilesService;
    @Autowired
    private IBlueprintsService blueprintsService;
    @Autowired
    private ICustomPagesService customPagesService;
    protected Map<ArtifactWorkflowStep.StepStatus, String> displayableStepStatus = Map.ofEntries(Map.entry(ArtifactWorkflowStep.StepStatus.ONGOING, "Ongoing"), Map.entry(ArtifactWorkflowStep.StepStatus.NOT_STARTED, "Not started"), Map.entry(ArtifactWorkflowStep.StepStatus.FINISHED, "Finished"), Map.entry(ArtifactWorkflowStep.StepStatus.SKIPPED, "Skipped"));

    @Override
    public ExportFile exportArtifact(AuthCtx authCtx, String artifactId, ExportType exportType) throws DKUSecurityException, IOException {
        UIArtifact uiArtifact = this.artifactsService.getArtifact(authCtx, artifactId);
        String slugifiedName = uiArtifact.artifact.name.replaceAll("[^a-zA-Z0-9-]+", "_");
        switch (exportType) {
            case CSV: {
                return this.exportArtifactCSV(authCtx, uiArtifact, slugifiedName);
            }
            case PDF: {
                return this.exportArtifactPDF(authCtx, uiArtifact, slugifiedName);
            }
        }
        throw ErrorContext.iae((String)"Unsupported Export Type");
    }

    @Override
    public ExportFile exportCustomPage(AuthCtx authCtx, String customPageId, List<ArtifactFilter> artifactFilters) throws IOException, DKUSecurityException {
        CustomPageExportVisitor visitor = new CustomPageExportVisitor();
        this.customPagesService.getCustomPage(authCtx, customPageId).accept(visitor);
        visitor.artifactSearchQuery.artifactFilters.addAll(artifactFilters);
        return this.exportSearch(authCtx, visitor.artifactSearchQuery, visitor.artifactTableColumns);
    }

    private ExportFile exportSearch(AuthCtx authCtx, ArtifactSearchQuery artifactSearchQuery, @Nullable List<ArtifactTableColumn> artifactTableColumns) throws DKUSecurityException, IOException {
        ExportFile exportFile;
        artifactSearchQuery.artifactSearchPagination = new ArtifactSearchPagination();
        artifactSearchQuery.artifactSearchPagination.all = true;
        List<UIArtifact> uiArtifacts = this.artifactsService.search((AuthCtx)authCtx, (ArtifactSearchQuery)artifactSearchQuery).uiArtifacts;
        CustomPageExportWriter customPageWriter = new CustomPageExportWriter();
        try {
            exportFile = ExportFile.build(this.buildCustomPageExportStream(authCtx, uiArtifacts, customPageWriter, artifactTableColumns), "export", MimeTypeUtils.fromExtension((String)"csv"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    customPageWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UncheckedIOException uncheckedIOException) {
                throw uncheckedIOException.getCause();
            }
        }
        customPageWriter.close();
        return exportFile;
    }

    private ExportFile exportArtifactCSV(AuthCtx authCtx, UIArtifact uiArtifact, String slugifiedArtifactName) throws IOException {
        ExportFile exportFile;
        ArtifactExportCSVWriter csvWriter = new ArtifactExportCSVWriter();
        try {
            exportFile = ExportFile.build(this.buildArtifactExportStream(authCtx, uiArtifact, csvWriter), slugifiedArtifactName, MimeTypeUtils.fromExtension((String)"csv"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    csvWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UncheckedIOException uncheckedIOException) {
                throw uncheckedIOException.getCause();
            }
        }
        csvWriter.close();
        return exportFile;
    }

    private ExportFile exportArtifactPDF(AuthCtx authCtx, UIArtifact uiArtifact, String slugifiedArtifactName) throws IOException {
        ExportFile exportFile;
        ArtifactExportPDFWriter pdfWriter = new ArtifactExportPDFWriter();
        try {
            exportFile = ExportFile.build(this.buildArtifactExportStream(authCtx, uiArtifact, pdfWriter), slugifiedArtifactName, MimeTypeUtils.fromExtension((String)"pdf"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    pdfWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UncheckedIOException uncheckedIOException) {
                throw uncheckedIOException.getCause();
            }
        }
        pdfWriter.close();
        return exportFile;
    }

    private InputStream buildCustomPageExportStream(AuthCtx authCtx, List<UIArtifact> uiArtifacts, CustomPageExportWriter writer, List<ArtifactTableColumn> artifactTableColumns) throws DKUSecurityException {
        ArrayList blueprintVersionIdToFieldIdsForColumns = new ArrayList();
        ArrayList<String> columns = new ArrayList<String>(Arrays.asList("ID", "Blueprint", "Blueprint Version"));
        if (artifactTableColumns != null) {
            for (ArtifactTableColumn artifactTableColumn : artifactTableColumns) {
                if (artifactTableColumn instanceof ArtifactTableColumn.ArtifactTableNameColumn || artifactTableColumn instanceof ArtifactTableColumn.ArtifactTableWorkflowColumn || artifactTableColumn instanceof ArtifactTableColumn.ArtifactTableViewsColumn) {
                    columns.add(artifactTableColumn.label);
                }
                if (!(artifactTableColumn instanceof ArtifactTableColumn.ArtifactTableViewsColumn) || ((ArtifactTableColumn.ArtifactTableViewsColumn)artifactTableColumn).blueprintIdViewIdPairs == null) continue;
                HashMap blueprintVersionIdToFieldIds = new HashMap();
                for (BlueprintIdViewIdPair pair : ((ArtifactTableColumn.ArtifactTableViewsColumn)artifactTableColumn).blueprintIdViewIdPairs) {
                    try {
                        this.blueprintsService.listBlueprintVersionsByBlueprint(authCtx, pair.blueprintId).forEach(uiBlueprintVersion -> {
                            BlueprintVersionSearchExportVisitor visitor = new BlueprintVersionSearchExportVisitor();
                            View bpvCellView = uiBlueprintVersion.blueprintVersion.uiDefinition.views.get(pair.viewId);
                            if (bpvCellView != null) {
                                bpvCellView.accept(visitor, pair.viewId);
                                blueprintVersionIdToFieldIds.put(uiBlueprintVersion.blueprintVersion.id, visitor.fieldIds);
                            }
                        });
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                blueprintVersionIdToFieldIdsForColumns.add(blueprintVersionIdToFieldIds);
            }
        }
        writer.writeRow(columns);
        for (UIArtifact uiArtifact : uiArtifacts) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(uiArtifact.artifact.id);
            values.add(uiArtifact.blueprint.name);
            values.add(uiArtifact.blueprintVersion.name);
            if (artifactTableColumns != null && !artifactTableColumns.isEmpty()) {
                Iterator mapIterator = blueprintVersionIdToFieldIdsForColumns.iterator();
                for (ArtifactTableColumn artifactTableColumn : artifactTableColumns) {
                    if (artifactTableColumn instanceof ArtifactTableColumn.ArtifactTableNameColumn) {
                        values.add(uiArtifact.artifact.name);
                        continue;
                    }
                    if (artifactTableColumn instanceof ArtifactTableColumn.ArtifactTableWorkflowColumn) {
                        long numberOfVisibleSteps = uiArtifact.artifact.workflow.steps.values().stream().filter(step -> step.visible).count();
                        String stepToDisplay = uiArtifact.artifact.getCurrentOngoingWorkflowStepId(uiArtifact.blueprintVersion.workflowDefinition.stepDefinitions);
                        if (stepToDisplay == null) {
                            stepToDisplay = uiArtifact.getFurthestFinishedStepId();
                        }
                        int indexToDisplay = 0;
                        int progress = 0;
                        if (stepToDisplay != null) {
                            List<StepDefinition> stepDefinitions = uiArtifact.blueprintVersion.workflowDefinition.stepDefinitions;
                            for (int i = 0; i < stepDefinitions.size(); ++i) {
                                ArtifactWorkflowStep artifactWorkflowStep = uiArtifact.artifact.workflow.steps.get(stepDefinitions.get((int)i).id);
                                if (artifactWorkflowStep == null || !artifactWorkflowStep.visible.booleanValue()) continue;
                                ++progress;
                                if (!stepDefinitions.get((int)i).id.equals(stepToDisplay)) continue;
                                indexToDisplay = progress;
                            }
                            values.add(stepToDisplay + " (" + indexToDisplay + "/" + numberOfVisibleSteps + ")");
                            continue;
                        }
                        if (numberOfVisibleSteps > 0L) {
                            values.add("Not started (" + indexToDisplay + "/" + numberOfVisibleSteps + ")");
                            continue;
                        }
                        values.add("");
                        continue;
                    }
                    if (!(artifactTableColumn instanceof ArtifactTableColumn.ArtifactTableViewsColumn) || !mapIterator.hasNext()) continue;
                    List fieldIds = (List)((Map)mapIterator.next()).get(uiArtifact.blueprintVersion.id);
                    if (CollectionUtils.isEmpty((Collection)fieldIds)) {
                        values.add("N/A");
                        continue;
                    }
                    if (fieldIds.size() == 1) {
                        values.add(this.formatFieldValue(uiArtifact, authCtx, (String)fieldIds.get(0)));
                        continue;
                    }
                    ArrayList<CallSite> containerValues = new ArrayList<CallSite>();
                    for (String fieldId : fieldIds) {
                        String fieldLabel = uiArtifact.blueprintVersion.fieldDefinitions.get((Object)fieldId).label;
                        String fieldValue = this.formatFieldValue(uiArtifact, authCtx, fieldId);
                        containerValues.add((CallSite)((Object)(fieldLabel + " : " + fieldValue)));
                    }
                    values.add(String.join((CharSequence)"\n", containerValues));
                }
            }
            writer.writeRow(values);
        }
        return writer.getStream();
    }

    private String formatFieldValue(UIArtifact uiArtifact, AuthCtx authCtx, String fieldId) {
        Object fieldValue = uiArtifact.artifact.fields.get(fieldId);
        FieldDefinitionExportVisitor visitor = new FieldDefinitionExportVisitor(fieldValue, uiArtifact, this.artifactsService, this.uploadedFilesService, authCtx);
        FieldDefinition fieldDefinition = uiArtifact.blueprintVersion.fieldDefinitions.get(fieldId);
        fieldDefinition.accept(visitor, fieldId);
        if (!visitor.exportFieldValues.isEmpty()) {
            Object value = visitor.exportFieldValues.size() > 1 ? "[" + String.join((CharSequence)", ", visitor.exportFieldValues) + "]" : visitor.exportFieldValues.get(0);
            return value;
        }
        return "None";
    }

    private InputStream buildArtifactExportStream(AuthCtx authCtx, UIArtifact uiArtifact, IArtifactExportWriter writer) {
        HashSet<String> processedIds = new HashSet<String>();
        Artifact artifact = uiArtifact.artifact;
        writer.writeSectionHeader(artifact.name);
        writer.writeRow(new ArtifactExportRow("Item name", artifact.id, "Item", Collections.singletonList(artifact.name)));
        this.processWorkflow(writer, uiArtifact);
        this.processMainView(writer, uiArtifact, processedIds, authCtx);
        this.processStepDefinitions(writer, uiArtifact, processedIds, authCtx);
        this.processAttachments(writer, uiArtifact, authCtx);
        this.processFields(writer, uiArtifact, processedIds, authCtx);
        return writer.getStream();
    }

    private void processWorkflow(IArtifactExportWriter writer, UIArtifact uiArtifact) {
        if (!writer.getConfig().workflow) {
            return;
        }
        BlueprintVersion bpv = uiArtifact.blueprintVersion;
        Artifact artifact = uiArtifact.artifact;
        writer.writeSectionHeader("Workflow");
        for (StepDefinition stepDefinition : bpv.workflowDefinition.stepDefinitions) {
            ArtifactWorkflowStep artifactWorkflowStep = artifact.workflow.steps.get(stepDefinition.id);
            if (artifactWorkflowStep != null) {
                if (!artifactWorkflowStep.visible.booleanValue()) continue;
                writer.writeRow(new ArtifactExportRow(stepDefinition.name, stepDefinition.id, "Workflow Step", Collections.singletonList(this.displayableStepStatus.get((Object)artifactWorkflowStep.status))));
                continue;
            }
            writer.writeRow(new ArtifactExportRow(stepDefinition.name, stepDefinition.id, "Workflow Step", Collections.singletonList(this.displayableStepStatus.get((Object)ArtifactWorkflowStep.StepStatus.NOT_STARTED))));
        }
    }

    private void processMainView(IArtifactExportWriter writer, UIArtifact uiArtifact, Set<String> processedIds, AuthCtx authCtx) {
        if (!writer.getConfig().mainView) {
            return;
        }
        BlueprintVersion bpv = uiArtifact.blueprintVersion;
        BlueprintVersionExportVisitor mainViewVisitor = new BlueprintVersionExportVisitor(uiArtifact, this.artifactsService, this.uploadedFilesService, authCtx);
        Map<String, View> views = bpv.uiDefinition.views;
        String mainViewId = bpv.uiDefinition.artifactPageViewId;
        if (StringUtils.isNotEmpty((CharSequence)mainViewId)) {
            writer.writeSectionHeader(views.get((Object)mainViewId).label);
            views.get(mainViewId).accept(mainViewVisitor, mainViewId);
            mainViewVisitor.rows.forEach(row -> {
                writer.writeRow((ArtifactExportRow)row);
                processedIds.add(row.id);
            });
        }
    }

    private void processStepDefinitions(IArtifactExportWriter writer, UIArtifact uiArtifact, Set<String> processedIds, AuthCtx authCtx) {
        if (!writer.getConfig().stepDefinitions) {
            return;
        }
        BlueprintVersion bpv = uiArtifact.blueprintVersion;
        Map<String, UIStepDefinition> uiStepDefinitions = bpv.uiDefinition.uiStepDefinitions;
        BlueprintVersionExportVisitor stepViewVisitor = new BlueprintVersionExportVisitor(uiArtifact, this.artifactsService, this.uploadedFilesService, authCtx);
        Artifact artifact = uiArtifact.artifact;
        for (StepDefinition stepDefinition : bpv.workflowDefinition.stepDefinitions) {
            ArtifactWorkflowStep artifactWorkflowStep = artifact.workflow.steps.get(stepDefinition.id);
            if (artifactWorkflowStep != null) {
                if (!artifactWorkflowStep.visible.booleanValue()) continue;
                writer.writeSectionHeader(stepDefinition.name, this.displayableStepStatus.get((Object)artifactWorkflowStep.status));
            } else {
                writer.writeSectionHeader(stepDefinition.name, this.displayableStepStatus.get((Object)ArtifactWorkflowStep.StepStatus.NOT_STARTED));
            }
            String viewId = uiStepDefinitions.get((Object)stepDefinition.id).viewId;
            if (StringUtils.isEmpty((CharSequence)viewId)) continue;
            bpv.uiDefinition.views.get(viewId).accept(stepViewVisitor, viewId);
            stepViewVisitor.rows.forEach(row -> {
                writer.writeRow((ArtifactExportRow)row);
                processedIds.add(row.id);
            });
        }
    }

    private void processAttachments(IArtifactExportWriter writer, UIArtifact uiArtifact, AuthCtx authCtx) {
        if (!writer.getConfig().attachments) {
            return;
        }
        Attachments attachments = uiArtifact.artifact.attachments;
        writer.writeSectionHeader("Attachments");
        if (attachments.references.isEmpty()) {
            writer.writeAttachments("References", Collections.singletonList("None"));
        } else {
            writer.writeAttachments("References", attachments.references.stream().map(artifactId -> {
                StringBuilder builder = new StringBuilder();
                try {
                    builder.append((String)artifactId).append(": ").append(this.artifactsService.getArtifact((AuthCtx)authCtx, (String)artifactId).artifact.name);
                }
                catch (DKUSecurityException e) {
                    builder.append("Access denied (").append((String)artifactId).append(")");
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return builder.toString();
            }).collect(Collectors.toList()));
        }
        if (attachments.files.isEmpty()) {
            writer.writeAttachments("Files", Collections.singletonList("None"));
        } else {
            writer.writeAttachments("Files", attachments.files.stream().map(fileId -> {
                StringBuilder builder = new StringBuilder();
                try {
                    builder.append((String)fileId).append(": ").append(this.uploadedFilesService.getUploadedFileDesc((AuthCtx)authCtx, (String)fileId).name);
                }
                catch (DKUSecurityException e) {
                    builder.append("Access denied (").append((String)fileId).append(")");
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return builder.toString();
            }).collect(Collectors.toList()));
        }
    }

    private void processFields(IArtifactExportWriter writer, UIArtifact uiArtifact, Set<String> processedIds, AuthCtx authCtx) {
        if (!writer.getConfig().fields) {
            return;
        }
        boolean isHeaderWritten = false;
        for (Map.Entry<String, Object> entry : uiArtifact.artifact.fields.entrySet()) {
            String fieldId = entry.getKey();
            if (processedIds.contains(fieldId)) continue;
            if (!isHeaderWritten) {
                isHeaderWritten = true;
                writer.writeSectionHeader("Other Fields");
            }
            Object fieldValue = entry.getValue();
            FieldDefinitionExportVisitor visitor = new FieldDefinitionExportVisitor(fieldValue, uiArtifact, this.artifactsService, this.uploadedFilesService, authCtx);
            FieldDefinition fieldDefinition = uiArtifact.blueprintVersion.fieldDefinitions.get(fieldId);
            fieldDefinition.accept(visitor, fieldId);
            String fieldType = WordUtils.capitalizeFully((String)fieldDefinition.fieldType.name().replace('_', ' '));
            writer.writeRow(new ArtifactExportRow(fieldDefinition.label, fieldId, fieldType, visitor.exportFieldValues));
        }
    }

    static class CustomPageExportVisitor
    implements ICustomPageVisitor {
        List<ArtifactTableColumn> artifactTableColumns;
        ArtifactSearchQuery artifactSearchQuery;

        CustomPageExportVisitor() {
        }

        @Override
        public void visit(ArtifactTableCustomPage customPage) {
            this.artifactTableColumns = customPage.artifactTableSettings.artifactTableColumns;
            ArtifactSearchSettings settings = customPage.artifactSearchSettings;
            this.artifactSearchQuery = ArtifactSearchQuery.build(settings.artifactSearchSource, settings.artifactFilters, null, null, settings.artifactPostFilters);
        }

        @Override
        public void visit(ArtifactMatrixCustomPage customPage) {
            this.artifactTableColumns = customPage.artifactTableSettings.artifactTableColumns;
            ArtifactSearchSettings settings = customPage.artifactSearchSettings;
            this.artifactSearchQuery = ArtifactSearchQuery.build(settings.artifactSearchSource, settings.artifactFilters, null, null, settings.artifactPostFilters);
        }

        @Override
        public void visit(CustomHTMLCustomPage customPage) {
            throw new NotImplementedException(customPage.id + " is a custom HTML page and cannot be exported.");
        }

        @Override
        public void visit(ArtifactKanbanViewCustomPage customPage) {
            throw new NotImplementedException(customPage.id + " is a kanban page and cannot be exported.");
        }
    }

    static class BlueprintVersionExportVisitor
    implements IBlueprintVersionVisitor {
        List<ArtifactExportRow> rows = new ArrayList<ArtifactExportRow>();
        private final UIArtifact uiArtifact;
        private final IArtifactsService artifactsService;
        private final IUploadedFilesService uploadedFilesService;
        private final AuthCtx authCtx;

        BlueprintVersionExportVisitor(UIArtifact uiArtifact, IArtifactsService artifactsService, IUploadedFilesService uploadedFilesService, AuthCtx authCtx) {
            this.artifactsService = artifactsService;
            this.uploadedFilesService = uploadedFilesService;
            this.authCtx = authCtx;
            this.uiArtifact = uiArtifact;
        }

        @Override
        public void visit(FieldViewComponent fieldViewComponent) {
            String fieldId = fieldViewComponent.fieldId;
            Object fieldValue = this.uiArtifact.artifact.fields.get(fieldId);
            FieldDefinitionExportVisitor visitor = new FieldDefinitionExportVisitor(fieldValue, this.uiArtifact, this.artifactsService, this.uploadedFilesService, this.authCtx);
            FieldDefinition fieldDefinition = this.uiArtifact.blueprintVersion.fieldDefinitions.get(fieldId);
            fieldDefinition.accept(visitor, fieldId);
            ArtifactExportRow row = new ArtifactExportRow(fieldViewComponent.label, fieldId, WordUtils.capitalizeFully((String)fieldDefinition.fieldType.name().replace('_', ' ')), visitor.exportFieldValues);
            this.rows.add(row);
        }
    }

    static class BlueprintVersionSearchExportVisitor
    implements IBlueprintVersionVisitor {
        public List<String> fieldIds = new ArrayList<String>();

        BlueprintVersionSearchExportVisitor() {
        }

        @Override
        public void visit(FieldViewComponent fieldViewComponent) {
            this.fieldIds.add(fieldViewComponent.fieldId);
        }
    }
}

