/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.governance.script;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.configuration.DefaultAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.governance.ArtifactAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.AutoGovernanceEffectiveAction;
import com.dataiku.gh.core.models.governance.AutoGovernanceScriptOutput;
import com.dataiku.gh.core.services.configuration.IGovernConfigurationDataService;
import com.dataiku.gh.core.services.governance.script.IAutoGovernanceScriptService;
import com.dataiku.gh.core.services.governance.utils.GovernanceUtils;
import com.dataiku.gh.core.services.python_execution.IPythonExecutionService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.IAutomaticConfigurationValidationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import java.io.IOException;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutoGovernanceScriptService
implements IAutoGovernanceScriptService {
    protected static final DKULogger logger = DKULogger.getLogger((String)"gh.services.governance-service");
    @Autowired
    private IPythonExecutionService pythonExecutionService;
    @Autowired
    private IGovernConfigurationDataService governConfigurationDataService;
    @Autowired
    private IAutomaticConfigurationValidationService automaticConfigurationValidationService;

    @Override
    @GHWriteTransaction
    public AutoGovernanceScriptOutput runScriptOnArtifactIfAdvancedLicense(EnrichedArtifact enrichedArtifact, boolean isAdvancedLicense) throws IOException {
        if (!isAdvancedLicense) {
            logger.infoV("Skip running script on artifact of ID: %s due to license restriction", new Object[]{enrichedArtifact.artifact.id});
            return AutoGovernanceScriptOutput.build(AutoGovernanceEffectiveAction.DO_NOTHING);
        }
        Optional<DefaultAutoGovernanceConfiguration> configurationItemOrNull = Optional.ofNullable((DefaultAutoGovernanceConfiguration)this.governConfigurationDataService.getConfigurationItemOrNull("default-autogovern"));
        String script = configurationItemOrNull.map(cfg -> cfg.script).orElseThrow(() -> new IllegalStateException("Script computation required for artifact `" + enrichedArtifact.artifact.id + "` but no configuration is defined"));
        AutoGovernanceScriptOutput autoGovernanceScriptOutput = this.pythonExecutionService.applyScriptForAutoGovernance(enrichedArtifact, script);
        this.mutateScriptOutput(enrichedArtifact.artifact, autoGovernanceScriptOutput);
        this.validateScriptOutput(enrichedArtifact.artifact, autoGovernanceScriptOutput);
        return autoGovernanceScriptOutput;
    }

    private void validateScriptOutput(Artifact artifact, AutoGovernanceScriptOutput autoGovernanceScriptOutput) throws IOException {
        if (autoGovernanceScriptOutput.action == null) {
            throw new ValidationException("Output attribute 'action' was missing when running script on artifact: " + artifact.id);
        }
        if (autoGovernanceScriptOutput.action == AutoGovernanceEffectiveAction.GOVERN && autoGovernanceScriptOutput.blueprintVersionId == null && autoGovernanceScriptOutput.projectExistingArtifactId == null) {
            throw new ValidationException("Neither existing artifact id nor blueprint version are defined when running script on artifact: " + artifact.id);
        }
        if (autoGovernanceScriptOutput.blueprintVersionId != null && autoGovernanceScriptOutput.projectExistingArtifactId != null) {
            throw new ValidationException("Both existing artifact id and blueprint version defined when running script on artifact: " + artifact.id);
        }
        String bid = GovernanceUtils.getDefaultGoverningBlueprintIdForDSSArtifact(artifact);
        if (autoGovernanceScriptOutput.blueprintVersionId != null && !bid.equals(autoGovernanceScriptOutput.blueprintVersionId.blueprintId)) {
            throw new ValidationException("Can't use blueprint version id: " + String.valueOf(autoGovernanceScriptOutput.blueprintVersionId) + " as an auto-govern template for type: " + bid);
        }
        if (SystemProvidedConstants.DATAIKU_PROJECT.blueprintId.equals(artifact.blueprintVersionId.blueprintId) && autoGovernanceScriptOutput.childrenConfiguration != null && !(autoGovernanceScriptOutput.childrenConfiguration instanceof ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration) || SystemProvidedConstants.DATAIKU_SAVED_MODEL.blueprintId.equals(artifact.blueprintVersionId.blueprintId) && autoGovernanceScriptOutput.childrenConfiguration != null && !(autoGovernanceScriptOutput.childrenConfiguration instanceof ArtifactAutoGovernanceConfiguration.ModelAutoGovernanceConfiguration)) {
            throw new ValidationException("Defined children autogovernance configuration type does not match blueprint type running script on artifact:" + artifact.id);
        }
        if (autoGovernanceScriptOutput.childrenConfiguration != null) {
            this.automaticConfigurationValidationService.validateArtifactAutoGovernanceConfiguration(autoGovernanceScriptOutput.childrenConfiguration, false);
        }
    }

    private void mutateScriptOutput(Artifact artifact, AutoGovernanceScriptOutput autoGovernanceScriptOutput) {
        if (autoGovernanceScriptOutput.childrenConfiguration != null) {
            autoGovernanceScriptOutput.childrenConfiguration.artifactId = artifact.id;
        }
    }
}

