/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.mail;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.integrations.mail.AbstractMailSender;
import com.dataiku.dip.integrations.mail.factory.MailSenderFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.services.mail.IEmailService;
import com.dataiku.gh.dao.GeneralSettingsDAO;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.util.Strings;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmailService
implements IEmailService {
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MailSenderFactory mailSenderFactory;
    private final ExecutorService threadPool = Executors.newCachedThreadPool();
    private static final Logger logger = Logger.getLogger((String)"gh.emails");

    @Override
    public boolean emailChannelActivated() throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            GeneralSettingsDAO.GeneralSettings settings = this.generalSettingsDAO.read();
            boolean bl = StringUtils.isNotBlank((String)settings.emailChannelId);
            return bl;
        }
    }

    @Override
    public void send(AuthCtx authCtx, String to, String subject, String body) throws Exception {
        String fromField;
        AbstractMailSender sender;
        try (Transaction t = this.transactionService.beginRead();){
            GeneralSettingsDAO.GeneralSettings settings = this.generalSettingsDAO.read();
            if (StringUtils.isBlank((String)settings.emailChannelId)) {
                throw new NotFoundException("The mail integration channel id is not set");
            }
            IntegrationChannel mailChannel = settings.integrationChannels.stream().filter(channel -> Strings.equals((String)channel.getId(), (String)settings.emailChannelId)).findFirst().orElseThrow(() -> new NotFoundException("The mail integration channel does not exist: " + settings.emailChannelId));
            sender = this.mailSenderFactory.createMailSenderWithoutPermissionCheck(mailChannel);
            fromField = sender.getConfiguration().computeFromField(authCtx, null, settings.studioMailAddress);
        }
        final Session session = sender.newSession();
        final Message msg = this.makeMessage(session, fromField, to, subject, body);
        logger.info((Object)"Message ready to be sent");
        this.threadPool.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                sender.send(session, msg, new InfoMessage.InfoMessages());
                return "sent";
            }
        });
    }

    private Message makeMessage(Session session, String from, String to, String subject, String body) throws Exception {
        String senderAddress = StringUtils.isNotBlank((String)from) ? from : to;
        InternetAddress sender = new InternetAddress(senderAddress);
        MimeMessage mail = new MimeMessage(session);
        mail.setFrom((Address)sender);
        mail.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
        mail.setSubject(subject);
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(body, "utf-8", "html");
        multipart.addBodyPart((BodyPart)messageBodyPart);
        mail.setContent((Multipart)multipart);
        return mail;
    }
}

