/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.python_execution_factory;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.actions.InstanceAction;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.blueprints.Action;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.governance.AutoGovernanceEffectiveAction;
import com.dataiku.gh.core.models.governance.AutoGovernanceScriptOutput;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPath;
import com.dataiku.gh.core.services.python_execution.IPythonExecutionService;
import com.dataiku.gh.core.services.python_execution.PythonExecutionStatus;
import com.dataiku.gh.core.services.python_execution.artifact_action.ArtifactActionScriptResponse;
import com.dataiku.gh.core.services.python_execution.instance_action.ActionScriptResponse;
import com.dataiku.gh.core.services.python_execution.logical_hooks.HooksExecutionResult;
import com.google.gson.JsonObject;
import java.io.IOException;
import javax.annotation.Nullable;

public class PythonExecutionNoOpService
implements IPythonExecutionService {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.services.python-execution.no-op");

    @Override
    public HooksExecutionResult applyLogicalHooksForCreation(EnrichedArtifact newEnrichedArtifact, @Nullable String authCtxIdentifier) throws IOException {
        logger.info((Object)"No-op service execution due to the loaded diagnosis database");
        return HooksExecutionResult.build(newEnrichedArtifact);
    }

    @Override
    public HooksExecutionResult applyLogicalHooksForUpdate(EnrichedArtifact newArtifact, EnrichedArtifact existingEnrichedArtifact, @Nullable String authCtxIdentifier) throws IOException {
        logger.info((Object)"No-op service execution due to the loaded diagnosis database");
        return HooksExecutionResult.build(newArtifact);
    }

    @Override
    public HooksExecutionResult applyLogicalHooksForDeletion(EnrichedArtifact existingEnrichedArtifact, @Nullable String authCtxIdentifier) throws IOException {
        logger.info((Object)"No-op service execution due to the loaded diagnosis database");
        return HooksExecutionResult.build(existingEnrichedArtifact);
    }

    @Override
    public ArtifactActionScriptResponse applyArtifactAction(String actionId, Action action, EnrichedArtifact enrichedArtifact, String authCtxIdentifier, JsonObject params) throws IOException {
        logger.info((Object)"No-op service execution due to the loaded diagnosis database");
        ArtifactActionScriptResponse artifactActionScriptResponse = new ArtifactActionScriptResponse();
        artifactActionScriptResponse.status = PythonExecutionStatus.SUCCESS;
        return artifactActionScriptResponse;
    }

    @Override
    public ActionScriptResponse applyInstanceAction(InstanceAction action, String authCtxIdentifier, JsonObject params) throws IOException {
        logger.info((Object)"No-op service execution due to the loaded diagnosis database");
        ActionScriptResponse instanceActionScriptResponse = new ActionScriptResponse();
        instanceActionScriptResponse.status = PythonExecutionStatus.SUCCESS;
        return instanceActionScriptResponse;
    }

    @Override
    public Artifact applyBlueprintVersionMigrationPath(EnrichedArtifact enrichedArtifactToMigrate, BlueprintVersionMigrationPath migration, EnrichedBlueprintVersion enrichedTargetBlueprintVersion, @Nullable String authCtxIdentifier) throws IOException {
        logger.info((Object)"No-op service execution due to the loaded diagnosis database");
        EnrichedArtifact returnedEnrichedArtifact = (EnrichedArtifact)JSON.deepCopy((Object)enrichedArtifactToMigrate);
        returnedEnrichedArtifact.artifact.blueprintVersionId = enrichedTargetBlueprintVersion.blueprintVersion.id;
        return returnedEnrichedArtifact.artifact;
    }

    @Override
    public AutoGovernanceScriptOutput applyScriptForAutoGovernance(EnrichedArtifact dkuEnrichedArtifact, String script) throws IOException {
        logger.info((Object)"No-op service execution due to the loaded diagnosis database");
        return AutoGovernanceScriptOutput.build(AutoGovernanceEffectiveAction.DO_NOTHING);
    }
}

