/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.relationships.collectors;

import com.dataiku.gh.core.models.relationships.FieldRelationshipData;
import com.dataiku.gh.core.models.relationships.ListFieldRelationshipDataDetails;
import com.dataiku.gh.core.models.relationships.PlainFieldRelationshipDataDetails;
import com.dataiku.gh.core.models.relationships.TimeSeriesRelationship;
import com.dataiku.gh.core.visitors.IFieldAndListValueVisitor;
import com.dataiku.gh.core.visitors.IFieldValueVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;

public class TimeSeriesRelationshipFieldCollector
implements IFieldValueVisitor {
    private final String from;
    private final String fieldId;
    public List<TimeSeriesRelationship> relationships = new ArrayList<TimeSeriesRelationship>();

    public TimeSeriesRelationshipFieldCollector(String from, String fieldId) {
        this.from = from;
        this.fieldId = fieldId;
    }

    @Override
    public void visit(String stringFieldValue) {
        FieldRelationshipData fieldRelationshipData = new FieldRelationshipData();
        fieldRelationshipData.fieldId = this.fieldId;
        fieldRelationshipData.details = new PlainFieldRelationshipDataDetails();
        TimeSeriesRelationship timeSeriesRelationship = new TimeSeriesRelationship();
        timeSeriesRelationship.artifactId = this.from;
        timeSeriesRelationship.timeSeriesId = stringFieldValue;
        timeSeriesRelationship.relationshipData = fieldRelationshipData;
        this.relationships.add(timeSeriesRelationship);
    }

    @Override
    public void visit(List<Object> listFieldValue) {
        IntStream.range(0, listFieldValue.size()).forEach(i -> {
            Object fieldValue = listFieldValue.get(i);
            ListTimeSeriesRelationshipFieldCollector collector = new ListTimeSeriesRelationshipFieldCollector(i);
            collector.visit(fieldValue);
            if (collector.relationship != null) {
                this.relationships.add(collector.relationship);
            }
        });
    }

    private class ListTimeSeriesRelationshipFieldCollector
    implements IFieldAndListValueVisitor {
        private final int index;
        public TimeSeriesRelationship relationship;

        private ListTimeSeriesRelationshipFieldCollector(int index) {
            this.index = index;
        }

        @Override
        public void visit(String stringFieldValue) {
            ListFieldRelationshipDataDetails listFieldRelationshipDataDetails = new ListFieldRelationshipDataDetails();
            listFieldRelationshipDataDetails.index = this.index;
            FieldRelationshipData fieldRelationshipData = new FieldRelationshipData();
            fieldRelationshipData.fieldId = TimeSeriesRelationshipFieldCollector.this.fieldId;
            fieldRelationshipData.details = listFieldRelationshipDataDetails;
            TimeSeriesRelationship timeSeriesRelationship = new TimeSeriesRelationship();
            timeSeriesRelationship.artifactId = TimeSeriesRelationshipFieldCollector.this.from;
            timeSeriesRelationship.timeSeriesId = stringFieldValue;
            timeSeriesRelationship.relationshipData = fieldRelationshipData;
            this.relationship = timeSeriesRelationship;
        }
    }
}

