/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.roles_and_permissions;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.roles.permissions.EffectivePermissionsItem;
import com.dataiku.gh.core.models.roles.permissions.FieldPermissionsItem;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CheckPermissionsService
implements ICheckPermissionsService {
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private TransactionService transactionService;

    @Override
    public boolean isGovernBlueprintDesignerAllowed() {
        return this.licenseEnforcementService.isGovernBlueprintDesignerAllowed();
    }

    @Override
    public void checkGovernBlueprintDesignerAllowed() throws LimitsStatusComputer.LicenseLimitException {
        this.licenseEnforcementService.checkGovernBlueprintDesignerAllowed();
    }

    @Override
    public void checkGovernBlueprintDesignerAllowedInCreation(String explanation) throws LimitsStatusComputer.LicenseLimitException {
        this.licenseEnforcementService.checkGovernBlueprintDesignerAllowed();
        try (Transaction t = this.transactionService.beginRead();){
            this.licenseEnforcementService.checkUsersOverQuota(explanation);
        }
    }

    @Override
    public boolean hasArtifactReadPermission(AuthCtx authCtx, EffectivePermissionsItem epi) {
        try {
            this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        }
        catch (DKUSecurityException e) {
            return false;
        }
        return epi.artifactPermissionsItem.hasReadPermission();
    }

    @Override
    public boolean hasArtifactReadPermission_NoLicenseCheck(EffectivePermissionsItem epi) {
        return epi.artifactPermissionsItem.hasReadPermission();
    }

    @Override
    public void checkBlueprintReadPermission(AuthCtx authCtx, EffectivePermissionsItem epi, String blueprintId) throws DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        this.checkBlueprintReadPermission_NoLicenseCheck(epi, blueprintId);
    }

    @Override
    public void checkBlueprintReadPermission_NoLicenseCheck(EffectivePermissionsItem epi, String blueprintId) throws DKUSecurityException {
        if (!epi.artifactPermissionsItem.hasReadPermission()) {
            throw new UnauthorizedException("Permission denied: unable to read item: " + blueprintId, "blueprint-read-denied");
        }
    }

    @Override
    public void checkBlueprintVersionReadPermission(AuthCtx authCtx, EffectivePermissionsItem epi, BlueprintVersionId blueprintVersionId) throws DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        this.checkBlueprintVersionReadPermission_NoLicenseCheck(epi, blueprintVersionId);
    }

    @Override
    public void checkBlueprintVersionReadPermission_NoLicenseCheck(EffectivePermissionsItem epi, BlueprintVersionId blueprintVersionId) throws DKUSecurityException {
        if (!epi.artifactPermissionsItem.hasReadPermission()) {
            throw new UnauthorizedException("Permission denied: unable to read item: " + String.valueOf(blueprintVersionId), "blueprint-version-read-denied");
        }
    }

    @Override
    public void checkArtifactReadPermission(AuthCtx authCtx, EffectivePermissionsItem epi, String artifactId) throws DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        this.checkArtifactReadPermission_NoLicenseCheck(epi, artifactId);
    }

    @Override
    public void checkArtifactReadPermission_NoLicenseCheck(EffectivePermissionsItem epi, String artifactId) throws DKUSecurityException {
        if (!epi.artifactPermissionsItem.hasReadPermission()) {
            throw new UnauthorizedException("Permission denied: unable to read item: " + artifactId, "artifact-read-denied");
        }
    }

    @Override
    public boolean hasArtifactWritePermission(AuthCtx authCtx, EffectivePermissionsItem epi) {
        try {
            this.licenseEnforcementService.checkWriteGovernAllowed(authCtx);
        }
        catch (DKUSecurityException e) {
            return false;
        }
        return epi.artifactPermissionsItem.hasWritePermission();
    }

    @Override
    public boolean hasArtifactWritePermission_NoLicenseCheck(EffectivePermissionsItem epi) {
        return epi.artifactPermissionsItem.hasWritePermission();
    }

    @Override
    public void checkArtifactWritePermission(AuthCtx authCtx, EffectivePermissionsItem epi, String artifactId) throws DKUSecurityException {
        this.licenseEnforcementService.checkWriteGovernAllowed(authCtx);
        this.checkArtifactWritePermission_NoLicenseCheck(epi, artifactId);
    }

    @Override
    public void checkArtifactWritePermission_NoLicenseCheck(EffectivePermissionsItem epi, String artifactId) throws DKUSecurityException {
        if (!epi.artifactPermissionsItem.hasWritePermission()) {
            throw new UnauthorizedException("Permission denied: unable to write item: " + artifactId, "artifact-write-denied");
        }
    }

    @Override
    public boolean hasArtifactCreatePermission(AuthCtx authCtx, EffectivePermissionsItem epi) {
        try {
            this.licenseEnforcementService.checkWriteGovernAllowed(authCtx);
            try (Transaction t = this.transactionService.beginRead();){
                this.licenseEnforcementService.checkUsersOverQuota("create item");
            }
        }
        catch (DKUSecurityException | LimitsStatusComputer.LicenseLimitException e) {
            return false;
        }
        return epi.artifactPermissionsItem.hasCreatePermission();
    }

    @Override
    public boolean hasArtifactCreatePermission_NoLicenseCheck(EffectivePermissionsItem epi) {
        return epi.artifactPermissionsItem.hasCreatePermission();
    }

    @Override
    public void checkArtifactCreatePermission(AuthCtx authCtx, EffectivePermissionsItem epi, String blueprintId) throws DKUSecurityException, LimitsStatusComputer.LicenseLimitException {
        this.licenseEnforcementService.checkWriteGovernAllowed(authCtx);
        try (Transaction t = this.transactionService.beginRead();){
            this.licenseEnforcementService.checkUsersOverQuota("create item");
        }
        this.checkArtifactCreatePermission_NoLicenseCheck(epi, blueprintId);
    }

    @Override
    public void checkArtifactCreatePermission_NoLicenseCheck(EffectivePermissionsItem epi, String blueprintId) throws DKUSecurityException {
        if (!epi.artifactPermissionsItem.hasCreatePermission()) {
            throw new UnauthorizedException("Permission denied: unable to create item of type: " + blueprintId, "artifact-create-denied");
        }
    }

    @Override
    public boolean hasArtifactDeletePermission(AuthCtx authCtx, EffectivePermissionsItem epi) {
        try {
            this.licenseEnforcementService.checkWriteGovernAllowed(authCtx);
        }
        catch (DKUSecurityException e) {
            return false;
        }
        return epi.artifactPermissionsItem.hasDeletePermission();
    }

    @Override
    public boolean hasArtifactAdminPermission(AuthCtx authCtx, EffectivePermissionsItem epi) {
        try {
            this.licenseEnforcementService.checkWriteGovernAllowed(authCtx);
        }
        catch (DKUSecurityException e) {
            return false;
        }
        return epi.artifactPermissionsItem.hasAdminPermission();
    }

    @Override
    public boolean hasArtifactAdminPermission_NoLicenseCheck(EffectivePermissionsItem epi) {
        return epi.artifactPermissionsItem.hasAdminPermission();
    }

    @Override
    public void checkArtifactAdminPermission(AuthCtx authCtx, EffectivePermissionsItem epi, String artifactId) throws DKUSecurityException {
        this.licenseEnforcementService.checkWriteGovernAllowed(authCtx);
        if (!epi.artifactPermissionsItem.hasAdminPermission()) {
            throw new UnauthorizedException("No admin permission for item: " + artifactId, "artifact-admin-denied");
        }
    }

    @Override
    public void checkArtifactAdminPermission_NoLicenseCheck(EffectivePermissionsItem epi, String artifactId) throws DKUSecurityException {
        if (!epi.artifactPermissionsItem.hasAdminPermission()) {
            throw new UnauthorizedException("No admin permission for item: " + artifactId, "artifact-admin-denied");
        }
    }

    @Override
    public void checkArtifactDeletePermission(AuthCtx authCtx, EffectivePermissionsItem epi, String artifactId) throws DKUSecurityException {
        this.licenseEnforcementService.checkWriteGovernAllowed(authCtx);
        if (!epi.artifactPermissionsItem.hasDeletePermission()) {
            throw new UnauthorizedException("Permission denied: unable to delete item " + artifactId, "artifact-delete-denied");
        }
    }

    @Override
    public boolean hasFieldReadPermission(AuthCtx authCtx, EffectivePermissionsItem epi, String fieldId) {
        try {
            this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        }
        catch (DKUSecurityException e) {
            return false;
        }
        return this.hasFieldReadPermission_NoLicenseCheck(epi, fieldId);
    }

    @Override
    public boolean hasFieldReadPermission_NoLicenseCheck(EffectivePermissionsItem epi, String fieldId) {
        if (!epi.artifactPermissionsItem.hasReadPermission()) {
            return false;
        }
        FieldPermissionsItem field = epi.fieldPermissionsItems.get(fieldId);
        return field != null && field.hasReadPermission();
    }

    @Override
    public void checkFieldReadPermission(AuthCtx authCtx, EffectivePermissionsItem epi, String fieldId) throws DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        this.checkFieldReadPermission_NoLicenseCheck(epi, fieldId);
    }

    @Override
    public void checkFieldReadPermission_NoLicenseCheck(EffectivePermissionsItem epi, String fieldId) throws DKUSecurityException {
        if (!this.hasFieldReadPermission_NoLicenseCheck(epi, fieldId)) {
            throw new UnauthorizedException("Permission denied: unable to read field " + fieldId, "artifact-field-read-denied");
        }
    }

    @Override
    public boolean hasFieldWritePermissionForCreate(AuthCtx authCtx, EffectivePermissionsItem epi, String fieldId) {
        try {
            this.licenseEnforcementService.checkWriteGovernAllowed(authCtx);
        }
        catch (DKUSecurityException e) {
            return false;
        }
        return this.hasFieldWritePermissionForCreate_NoLicenseCheck(epi, fieldId);
    }

    @Override
    public boolean hasFieldWritePermissionForCreate_NoLicenseCheck(EffectivePermissionsItem epi, String fieldId) {
        if (!epi.artifactPermissionsItem.hasCreatePermission()) {
            return false;
        }
        FieldPermissionsItem field = epi.fieldPermissionsItems.get(fieldId);
        return field != null && field.hasWritePermission();
    }

    @Override
    public void checkFieldWritePermissionForCreate(AuthCtx authCtx, EffectivePermissionsItem epi, String fieldId) throws DKUSecurityException {
        this.licenseEnforcementService.checkWriteGovernAllowed(authCtx);
        this.checkFieldWritePermissionForCreate_NoLicenseCheck(epi, fieldId);
    }

    @Override
    public void checkFieldWritePermissionForCreate_NoLicenseCheck(EffectivePermissionsItem epi, String fieldId) throws DKUSecurityException {
        if (!this.hasFieldWritePermissionForCreate_NoLicenseCheck(epi, fieldId)) {
            throw new UnauthorizedException("Permission denied: unable to write field " + fieldId, "artifact-field-write-denied");
        }
    }

    @Override
    public boolean hasFieldWritePermissionForWrite(AuthCtx authCtx, EffectivePermissionsItem epi, String fieldId) {
        try {
            this.licenseEnforcementService.checkWriteGovernAllowed(authCtx);
        }
        catch (DKUSecurityException e) {
            return false;
        }
        return this.hasFieldWritePermissionForWrite_NoLicenseCheck(epi, fieldId);
    }

    @Override
    public boolean hasFieldWritePermissionForWrite_NoLicenseCheck(EffectivePermissionsItem epi, String fieldId) {
        if (!epi.artifactPermissionsItem.hasWritePermission()) {
            return false;
        }
        FieldPermissionsItem field = epi.fieldPermissionsItems.get(fieldId);
        return field != null && field.hasWritePermission();
    }

    @Override
    public void checkFieldWritePermissionForWrite(AuthCtx authCtx, EffectivePermissionsItem epi, String fieldId) throws DKUSecurityException {
        this.licenseEnforcementService.checkWriteGovernAllowed(authCtx);
        this.checkFieldWritePermissionForWrite_NoLicenseCheck(epi, fieldId);
    }

    @Override
    public void checkFieldWritePermissionForWrite_NoLicenseCheck(EffectivePermissionsItem epi, String fieldId) throws DKUSecurityException {
        if (!this.hasFieldWritePermissionForWrite_NoLicenseCheck(epi, fieldId)) {
            throw new UnauthorizedException("Permission denied: unable to write field " + fieldId, "artifact-field-write-denied");
        }
    }
}

