/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.roles_and_permissions.permissions;

import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.gh.core.models.configuration.DefaultBlueprintPermissionsGovernConfiguration;
import com.dataiku.gh.core.models.configuration.GovernConfiguration;
import com.dataiku.gh.core.models.roles.permissions.BlueprintPermissions;
import com.dataiku.gh.core.services.configuration.IGovernConfigurationDataService;
import com.dataiku.gh.core.services.roles_and_permissions.permissions.IAdminBlueprintPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.permissions.IBlueprintPermissionsDataService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.IBlueprintPermissionsValidationService;
import com.dataiku.gh.security.IPermissionsService;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminBlueprintPermissionsService
implements IAdminBlueprintPermissionsService {
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private IBlueprintPermissionsDataService blueprintPermissionsDataService;
    @Autowired
    private IBlueprintPermissionsValidationService blueprintPermissionsValidationService;
    @Autowired
    private IGovernConfigurationDataService governConfigurationDataService;

    @Override
    @GHReadonlyTransaction
    public BlueprintPermissions getBlueprintPermissions(AuthCtx authCtx, String blueprintId) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        return this.blueprintPermissionsDataService.getBlueprintPermissions(blueprintId);
    }

    @Override
    @GHReadonlyTransaction
    public BlueprintPermissions getBlueprintPermissionsOrNull(AuthCtx authCtx, String blueprintId) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        return this.blueprintPermissionsDataService.getBlueprintPermissionsOrNull(blueprintId);
    }

    @Override
    @GHReadonlyTransaction
    public List<BlueprintPermissions> listBlueprintPermissions(AuthCtx authCtx) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        return this.blueprintPermissionsDataService.listBlueprintPermissions();
    }

    @Override
    @GHWriteTransaction
    public BlueprintPermissions createBlueprintPermissions(AuthCtx authCtx, BlueprintPermissions blueprintPermissions) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        this.blueprintPermissionsValidationService.validateBlueprintPermissions(blueprintPermissions);
        return this.blueprintPermissionsDataService.createBlueprintPermissions(blueprintPermissions);
    }

    @Override
    @GHWriteTransaction
    public BlueprintPermissions saveBlueprintPermissions(AuthCtx authCtx, BlueprintPermissions blueprintPermissions) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        this.blueprintPermissionsValidationService.validateBlueprintPermissions(blueprintPermissions);
        return this.blueprintPermissionsDataService.saveBlueprintPermissions(blueprintPermissions);
    }

    @Override
    @GHWriteTransaction
    public void deleteBlueprintPermissions(AuthCtx authCtx, String blueprintId) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        this.blueprintPermissionsDataService.deleteBlueprintPermissions(blueprintId);
    }

    @Override
    @GHReadonlyTransaction
    public BlueprintPermissions getDefaultBlueprintPermissions(AuthCtx authCtx) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        GovernConfiguration configurationItem = this.governConfigurationDataService.getConfigurationItem("default-blueprint-permissions");
        return ((DefaultBlueprintPermissionsGovernConfiguration)configurationItem).defaultBlueprintPermissions;
    }

    @Override
    @GHWriteTransaction
    public BlueprintPermissions saveDefaultBlueprintPermissions(AuthCtx authCtx, BlueprintPermissions blueprintPermissions) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        blueprintPermissions.blueprintId = null;
        DefaultBlueprintPermissionsGovernConfiguration configurationItem = DefaultBlueprintPermissionsGovernConfiguration.build(blueprintPermissions);
        GovernConfiguration newConfigurationItem = this.governConfigurationDataService.upsertConfigurationItem(configurationItem);
        return configurationItem.defaultBlueprintPermissions;
    }
}

