/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.signoff;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.notifications.signoff.AbandonSignoffNotificationContext;
import com.dataiku.gh.core.models.notifications.signoff.AddApprovalSignoffNotificationContext;
import com.dataiku.gh.core.models.notifications.signoff.AddFeedbackSignoffNotificationContext;
import com.dataiku.gh.core.models.notifications.signoff.CancelAbandonSignoffNotificationContext;
import com.dataiku.gh.core.models.notifications.signoff.DeleteApprovalSignoffNotificationContext;
import com.dataiku.gh.core.models.notifications.signoff.EditApprovalSignoffNotificationContext;
import com.dataiku.gh.core.models.notifications.signoff.RequestApprovalSignoffNotificationContext;
import com.dataiku.gh.core.models.notifications.signoff.RequestFeedbackSignoffNotificationContext;
import com.dataiku.gh.core.models.notifications.signoff.SignoffGroupData;
import com.dataiku.gh.core.models.notifications.signoff.SignoffNotificationContext;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.models.security.GlobalAPIKeyUsersContainer;
import com.dataiku.gh.core.models.security.GroupUsersContainer;
import com.dataiku.gh.core.models.security.RoleUsersContainer;
import com.dataiku.gh.core.models.security.UserUsersContainer;
import com.dataiku.gh.core.models.security.UsersContainer;
import com.dataiku.gh.core.models.security.UsersContainersExtraction;
import com.dataiku.gh.core.models.signoff.EnrichedSignoff;
import com.dataiku.gh.core.models.signoff.Signoff;
import com.dataiku.gh.core.models.signoff.SignoffApproval;
import com.dataiku.gh.core.models.signoff.SignoffConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffConfigurationId;
import com.dataiku.gh.core.models.signoff.SignoffDetails;
import com.dataiku.gh.core.models.signoff.SignoffFeedback;
import com.dataiku.gh.core.models.signoff.SignoffId;
import com.dataiku.gh.core.models.signoff.SignoffIdAndBPVId;
import com.dataiku.gh.core.models.signoff.SignoffRecurrenceConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffUser;
import com.dataiku.gh.core.models.signoff.SignoffUserAndGroupId;
import com.dataiku.gh.core.models.signoff.SignoffUsersContainerRelation;
import com.dataiku.gh.core.models.signoff.SignoffUsersGroup;
import com.dataiku.gh.core.models.signoff.SignoffUsersGroupDetails;
import com.dataiku.gh.core.models.signoff.search.SignoffSearchQuery;
import com.dataiku.gh.core.models.ui.UISignoffApprovalData;
import com.dataiku.gh.core.models.ui.UISignoffFeedbackData;
import com.dataiku.gh.core.models.ui.UISignoffSearchResults;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.notifications.INotificationsService;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.IRolesAndPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.computation.assigned_roles.IUserBlueprintRoleAssignmentsComputationService;
import com.dataiku.gh.core.services.roles_and_permissions.computation.assigned_roles.IUsersAndAPIKeysBlueprintRoleAssignmentsComputationService;
import com.dataiku.gh.core.services.roles_and_permissions.context.UserRolesCacheContext;
import com.dataiku.gh.core.services.signoff.ISignoffsDataService;
import com.dataiku.gh.core.services.signoff.ISignoffsNoAuthService;
import com.dataiku.gh.core.services.signoff.ISignoffsService;
import com.dataiku.gh.core.services.signoff.SignoffUtils;
import com.dataiku.gh.core.services.subscriptions.ISubscriptionsService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.utils.ITransactionHandler;
import com.dataiku.gh.core.services.utils.ITransactionScope;
import com.dataiku.gh.core.services.utils.TransactionUtils;
import com.dataiku.gh.core.services.validation.ISignoffsValidationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.services.validation.extractor.UsersContainerExtractor;
import com.dataiku.gh.core.storage.signoff.ISignoffsConfigurationsDAO;
import com.dataiku.gh.core.utils.DateUtils;
import com.dataiku.gh.core.utils.ValidatorUtils;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.security.PermissionsService;
import com.dataiku.gh.security.model.GlobalScopePublicAPIKeyWithGroups;
import com.dataiku.gh.server.api.auth.PublicAPIKeysService;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.intellij.lang.annotations.PrintFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SignoffsService
implements ISignoffsService,
ISignoffsNoAuthService {
    @Autowired
    private ITransactionHandler transactionHandler;
    @Autowired
    private ISignoffsDataService signoffsDataService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private ISignoffsValidationService signoffsValidationService;
    @Autowired
    private IRolesAndPermissionsService rolesAndPermissionsService;
    @Autowired
    private IUserBlueprintRoleAssignmentsComputationService userBlueprintRoleAssignmentsComputationService;
    @Autowired
    private IUsersAndAPIKeysBlueprintRoleAssignmentsComputationService usersAndAPIKeysBlueprintRoleAssignmentsComputationService;
    @Autowired
    private INotificationsService notificationService;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private ICheckPermissionsService checkPermissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ISignoffsConfigurationsDAO signoffsConfigurationsDAO;
    @Autowired
    private ISubscriptionsService subscriptionsService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private PublicAPIKeysService publicAPIKeysService;
    private final Map<Signoff.SignoffStatus, Set<Signoff.SignoffStatus>> workflowUpward = ImmutableMap.builder().put((Object)Signoff.SignoffStatus.NOT_STARTED, (Object)ImmutableSet.of((Object)((Object)Signoff.SignoffStatus.WAITING_FOR_FEEDBACK), (Object)((Object)Signoff.SignoffStatus.WAITING_FOR_APPROVAL), (Object)((Object)Signoff.SignoffStatus.ABANDONED))).put((Object)Signoff.SignoffStatus.WAITING_FOR_FEEDBACK, (Object)ImmutableSet.of((Object)((Object)Signoff.SignoffStatus.WAITING_FOR_APPROVAL), (Object)((Object)Signoff.SignoffStatus.ABANDONED))).put((Object)Signoff.SignoffStatus.WAITING_FOR_APPROVAL, (Object)ImmutableSet.of((Object)((Object)Signoff.SignoffStatus.ABANDONED))).put((Object)Signoff.SignoffStatus.APPROVED, (Object)ImmutableSet.of((Object)((Object)Signoff.SignoffStatus.ABANDONED))).put((Object)Signoff.SignoffStatus.REJECTED, (Object)ImmutableSet.of((Object)((Object)Signoff.SignoffStatus.ABANDONED))).put((Object)Signoff.SignoffStatus.ABANDONED, (Object)ImmutableSet.of()).build();
    private final Map<Signoff.SignoffStatus, Set<Signoff.SignoffStatus>> workflowBackward = ImmutableMap.builder().put((Object)Signoff.SignoffStatus.NOT_STARTED, (Object)ImmutableSet.of()).put((Object)Signoff.SignoffStatus.WAITING_FOR_FEEDBACK, (Object)ImmutableSet.of()).put((Object)Signoff.SignoffStatus.WAITING_FOR_APPROVAL, (Object)ImmutableSet.of((Object)((Object)Signoff.SignoffStatus.WAITING_FOR_FEEDBACK))).put((Object)Signoff.SignoffStatus.APPROVED, (Object)ImmutableSet.of()).put((Object)Signoff.SignoffStatus.REJECTED, (Object)ImmutableSet.of()).put((Object)Signoff.SignoffStatus.ABANDONED, (Object)ImmutableSet.of((Object)((Object)Signoff.SignoffStatus.NOT_STARTED), (Object)((Object)Signoff.SignoffStatus.WAITING_FOR_FEEDBACK), (Object)((Object)Signoff.SignoffStatus.WAITING_FOR_APPROVAL), (Object)((Object)Signoff.SignoffStatus.APPROVED), (Object)((Object)Signoff.SignoffStatus.REJECTED))).build();
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.services.signoff");

    @Override
    @GHReadonlyTransaction
    public Signoff getSignoff(AuthCtx authCtx, SignoffId signoffId) throws IOException, DKUSecurityException {
        EnrichedArtifact enrichedArtifact = this.getArtifactAndCheckReadPermissions(authCtx, signoffId.artifactId);
        return enrichedArtifact.findMandatorySignoffByStepId(signoffId.stepId);
    }

    @Override
    @GHReadonlyTransaction
    public List<Signoff> getSignoffs(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        EnrichedArtifact enrichedArtifact = this.getArtifactAndCheckReadPermissions(authCtx, artifactId);
        return enrichedArtifact.signoffs;
    }

    /*
     * Exception decompiling
     */
    @Override
    @GHReadonlyTransaction
    public UISignoffSearchResults searchUserSignoffs(AuthCtx authCtx, SignoffSearchQuery signoffSearchQuery) throws IOException, DKUSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @GHReadonlyTransaction
    public SignoffDetails getSignoffDetails(AuthCtx authCtx, SignoffId signoffId) throws IOException, DKUSecurityException {
        EnrichedArtifact enrichedArtifact = this.getArtifactAndCheckReadPermissions(authCtx, signoffId.artifactId);
        SignoffDetails signoffDetails = new SignoffDetails();
        try {
            Signoff signoff = enrichedArtifact.findMandatorySignoffByStepId(signoffId.stepId);
            Supplier<Map<String, IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole>> allRolesMappingComputer = this.allRolesMappingForArtifactComputer_UncheckedIOException(enrichedArtifact);
            Supplier<List<UsersDAO.User>> allUsersComputer = this.listUsersUnsafe_UncheckedIOException();
            Supplier<List<GlobalScopePublicAPIKeyWithGroups>> allGlobalApiKeysWithGroupsComputer = this.listGlobalApiKeysWithGroups_UncheckedIOException();
            signoffDetails.feedbackGroups.addAll(signoff.configuration.feedbackUsersGroups.stream().map(signoffUsersGroup -> SignoffUsersGroupDetails.build(signoffUsersGroup.id, this.unwrapSignoffUsersToSignoffUsersContainerRelation_UncheckedIOException(signoffUsersGroup.users, allRolesMappingComputer, allUsersComputer, allGlobalApiKeysWithGroupsComputer))).collect(Collectors.toList()));
            signoffDetails.approvalUsersRelations.addAll(this.unwrapSignoffUsersToSignoffUsersContainerRelation_UncheckedIOException(signoff.configuration.approvers, allRolesMappingComputer, allUsersComputer, allGlobalApiKeysWithGroupsComputer));
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
        return signoffDetails;
    }

    @Override
    @GHWriteTransaction
    public Signoff createSignoff(AuthCtx authCtx, SignoffId signoffId) throws IOException, DKUSecurityException {
        EnrichedArtifact enrichedArtifact = this.getArtifactAndCheckWritePermissions(authCtx, signoffId.artifactId);
        if (enrichedArtifact.findSignoffByStepId(signoffId.stepId).isPresent()) {
            throw new ValidationException("A sign-off already exists for id " + String.valueOf(signoffId));
        }
        this.validateThatSignoffWorkflowStepIsOnGoing(signoffId, enrichedArtifact);
        Signoff signoff = this.buildNewSignoffReloadConfOrNull(enrichedArtifact.blueprintVersion.id, signoffId, 0);
        if (signoff == null) {
            throw new ValidationException("No sign-off configuration exists for bpvId " + String.valueOf(enrichedArtifact.blueprintVersion.id) + " and stepId " + signoffId.stepId);
        }
        this.subscriptionsService.automaticSubscribe(authCtx, enrichedArtifact.artifact.id);
        return this.validateAndCreateSignoff(signoff);
    }

    @Override
    @GHWriteTransaction
    public SignoffFeedback addFeedback(AuthCtx authCtx, SignoffId signoffId, String groupId, UISignoffFeedbackData signoffFeedbackData) throws IOException, DKUSecurityException {
        try (UserRolesCacheContext.ContextContainer rolesCache = UserRolesCacheContext.attachNewContext();){
            EnrichedArtifact enrichedArtifact = this.getArtifactAndCheckReadPermissions(authCtx, signoffId.artifactId);
            Signoff signoff = enrichedArtifact.findMandatorySignoffByStepId(signoffId.stepId);
            String authCtxIdentifier = authCtx.getIdentifier();
            this.validateThatSignoffWorkflowStepIsOnGoing(signoff.signoffId, enrichedArtifact);
            ValidatorUtils.validateThat(signoff.status.acceptsFeedback(), "The sign-off must be waiting for feedback", new Object[0]);
            SignoffUsersGroup feedbackGroup = signoff.configuration.findFeedbackGroupById(groupId).orElseThrow(() -> new ValidationException(String.format("Cannot find group '%s'", groupId)));
            this.validateThatLoggedUserIsWithinTheGroup(authCtx, feedbackGroup.users, signoffId.artifactId, "User/API key '%s' is not part of the group '%s'", authCtxIdentifier, feedbackGroup.id);
            Set<String> uuids = signoff.feedbackResponses.stream().map(fr -> fr.id).collect(Collectors.toSet());
            SignoffFeedback feedbackResponse = SignoffFeedback.build(uuids, groupId, authCtxIdentifier, signoffFeedbackData.comment, signoffFeedbackData.status);
            signoff.feedbackResponses.add(feedbackResponse);
            SignoffGroupData groupData = this.retrieveGroupData(enrichedArtifact, signoff.configuration);
            AddFeedbackSignoffNotificationContext notification = new AddFeedbackSignoffNotificationContext(enrichedArtifact, signoff, groupData, feedbackResponse, authCtx.getIdentifier());
            this.scheduleSubscriberNotification(authCtx, notification, enrichedArtifact.artifact.id, Collections.singleton(authCtx.getIdentifier()));
            this.validateAndStoreSignoff(signoff);
            this.subscriptionsService.automaticSubscribe(authCtx, enrichedArtifact.artifact.id);
            SignoffFeedback signoffFeedback = feedbackResponse;
            return signoffFeedback;
        }
    }

    @Override
    @GHWriteTransaction
    public SignoffFeedback editFeedback(AuthCtx authCtx, SignoffId signoffId, String feedbackId, UISignoffFeedbackData signoffFeedbackData) throws IOException, DKUSecurityException {
        EnrichedArtifact enrichedArtifact = this.getArtifactAndCheckReadPermissions(authCtx, signoffId.artifactId);
        Signoff signoff = enrichedArtifact.findMandatorySignoffByStepId(signoffId.stepId);
        String authCtxIdentifier = authCtx.getIdentifier();
        this.validateThatSignoffWorkflowStepIsOnGoing(signoff.signoffId, enrichedArtifact);
        ValidatorUtils.validateThat(signoff.status.acceptsFeedback(), "The sign-off must be waiting for feedback to edit a feedback", new Object[0]);
        SignoffFeedback editedFeedback = signoff.feedbackResponses.stream().filter(feedbackResponse -> StringUtils.equals((CharSequence)feedbackId, (CharSequence)feedbackResponse.id)).findFirst().orElseThrow(() -> new ValidationException(String.format("Cannot find a feedback with id: '%s'", feedbackId)));
        boolean userCanEditFeedback = StringUtils.equals((CharSequence)authCtxIdentifier, (CharSequence)editedFeedback.user);
        ValidatorUtils.validateThat(userCanEditFeedback, "User/API key '%s' cannot edit this feedback", authCtxIdentifier);
        editedFeedback.updateCommentAndStatus(signoffFeedbackData.comment, signoffFeedbackData.status);
        this.validateAndStoreSignoff(signoff);
        this.subscriptionsService.automaticSubscribe(authCtx, enrichedArtifact.artifact.id);
        return editedFeedback;
    }

    @Override
    @GHWriteTransaction
    public void deleteFeedback(AuthCtx authCtx, SignoffId signoffId, String feedbackId) throws IOException, DKUSecurityException {
        EnrichedArtifact enrichedArtifact = this.artifactsDataService.getArtifact(signoffId.artifactId);
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.getAssignedRolesAndPermissionsAndCheckReadPermissions(authCtx, enrichedArtifact);
        Signoff signoff = enrichedArtifact.findMandatorySignoffByStepId(signoffId.stepId);
        String authCtxIdentifier = authCtx.getIdentifier();
        this.validateThatSignoffWorkflowStepIsOnGoing(signoff.signoffId, enrichedArtifact);
        ValidatorUtils.validateThat(signoff.status.acceptsFeedback(), "The sign-off must be waiting for feedback to delete a feedback", new Object[0]);
        SignoffFeedback toDeleteFeedback = signoff.feedbackResponses.stream().filter(feedback -> StringUtils.equals((CharSequence)feedbackId, (CharSequence)feedback.id)).findFirst().orElseThrow(() -> new ValidationException(String.format("Cannot find a feedback with id: '%s'", feedbackId)));
        boolean userCanDeleteFeedback = StringUtils.equals((CharSequence)authCtxIdentifier, (CharSequence)toDeleteFeedback.user) || this.checkPermissionsService.hasArtifactAdminPermission(authCtx, assignedRolesAndPermissionsCtx.effectivePermissionsItem);
        ValidatorUtils.validateThat(userCanDeleteFeedback, "User/API key '%s' cannot delete this feedback", authCtxIdentifier);
        signoff.feedbackResponses.removeIf(feedback -> StringUtils.equals((CharSequence)feedbackId, (CharSequence)feedback.id));
        this.subscriptionsService.automaticSubscribe(authCtx, enrichedArtifact.artifact.id);
        this.validateAndStoreSignoff(signoff);
    }

    @Override
    @GHWriteTransaction
    public Signoff delegateFeedback(AuthCtx authCtx, SignoffId signoffId, String groupId, UserUsersContainer delegatedUser) throws IOException, DKUSecurityException {
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)groupId), "The id of the feedback group is mandatory", new Object[0]);
        return this.delegateToUser(authCtx, signoffId, delegatedUser.login, groupId);
    }

    @Override
    @GHWriteTransaction
    public SignoffApproval addApproval(AuthCtx authCtx, SignoffId signoffId, UISignoffApprovalData signoffApprovalData) throws IOException, DKUSecurityException {
        try (UserRolesCacheContext.ContextContainer rolesCache = UserRolesCacheContext.attachNewContext();){
            SignoffApproval approval;
            EnrichedArtifact enrichedArtifact = this.getArtifactAndCheckReadPermissions(authCtx, signoffId.artifactId);
            Signoff signoff = enrichedArtifact.findMandatorySignoffByStepId(signoffId.stepId);
            String authCtxIdentifier = authCtx.getIdentifier();
            this.validateThatSignoffWorkflowStepIsOnGoing(signoff.signoffId, enrichedArtifact);
            ValidatorUtils.validateThat(signoff.status.acceptsApproval(), "The sign-off must be waiting for an approval to approve it", new Object[0]);
            this.validateThatLoggedUserIsWithinTheGroup(authCtx, signoff.configuration.approvers, signoffId.artifactId, "User/API key '%s' is not an approver", authCtxIdentifier);
            boolean checkApproverIsDistinctFromRequesters = DKUApp.getParams().getBoolParam("dku.govern.preventSignoffApprovalFromSignoffRequesters", false);
            if (!this.permissionsService.isGovernArchitect(authCtx) && checkApproverIsDistinctFromRequesters) {
                ValidatorUtils.validateThat(!Objects.equals(signoff.feedbackRequesterIdentifier, authCtxIdentifier), "User/API key '%s' requested feedback, hence cannot self-approve", authCtxIdentifier);
                ValidatorUtils.validateThat(!Objects.equals(signoff.approvalRequesterIdentifier, authCtxIdentifier), "User/API key '%s' requested a final approval, hence cannot self-approve", authCtxIdentifier);
            }
            signoff.approverResponse = approval = SignoffApproval.build(authCtxIdentifier, signoffApprovalData.comment, signoffApprovalData.status);
            signoff.updateStatus(Signoff.SignoffStatus.from(approval.status));
            SignoffGroupData groupData = this.retrieveGroupData(enrichedArtifact, signoff.configuration);
            AddApprovalSignoffNotificationContext notification = new AddApprovalSignoffNotificationContext(enrichedArtifact, signoff, groupData, authCtx.getIdentifier());
            this.scheduleSubscriberNotification(authCtx, notification, enrichedArtifact.artifact.id, Collections.singleton(authCtx.getIdentifier()));
            this.validateAndStoreSignoff(signoff);
            this.subscriptionsService.automaticSubscribe(authCtx, enrichedArtifact.artifact.id);
            SignoffApproval signoffApproval = approval;
            return signoffApproval;
        }
    }

    @Override
    @GHWriteTransaction
    public SignoffApproval editApproval(AuthCtx authCtx, SignoffId signoffId, UISignoffApprovalData signoffApprovalData) throws IOException, DKUSecurityException {
        EnrichedArtifact enrichedArtifact = this.getArtifactAndCheckReadPermissions(authCtx, signoffId.artifactId);
        Signoff signoff = enrichedArtifact.findMandatorySignoffByStepId(signoffId.stepId);
        String authCtxIdentifier = authCtx.getIdentifier();
        this.validateThatSignoffWorkflowStepIsOnGoing(signoff.signoffId, enrichedArtifact);
        ValidatorUtils.validateThat(signoff.status.acceptsApprovalEdition(), "The sign-off with id `" + String.valueOf(signoffId) + "` must be already approved or rejected or abandoned to edit the approval", new Object[0]);
        SignoffApproval approverResponse = signoff.approverResponse;
        ValidatorUtils.validateThat(approverResponse != null, "The sign-off with id `" + String.valueOf(signoffId) + "` must have an approval to edit it", new Object[0]);
        if (signoff.status == Signoff.SignoffStatus.ABANDONED && approverResponse.status != SignoffApproval.SignoffApprovalStatus.ABANDONED) {
            throw new ValidationException("The approval cannot be edited when the sign-off with id `" + String.valueOf(signoffId) + "` is abandoned with a previous approval approved or rejected");
        }
        boolean userIsApprover = StringUtils.equals((CharSequence)authCtxIdentifier, (CharSequence)approverResponse.user);
        ValidatorUtils.validateThat(userIsApprover, "User/API key '%s' cannot edit this approval", authCtxIdentifier);
        boolean statusHasChanged = approverResponse.status != signoffApprovalData.status;
        approverResponse.updateCommentAndStatus(signoffApprovalData.comment, signoffApprovalData.status);
        signoff.updateStatus(Signoff.SignoffStatus.from(approverResponse.status));
        if (SignoffApproval.SignoffApprovalStatus.ABANDONED.equals((Object)approverResponse.status)) {
            signoff.statusBeforeAbandoned = Signoff.SignoffStatus.WAITING_FOR_APPROVAL;
        }
        if (statusHasChanged) {
            SignoffGroupData groupData = this.retrieveGroupData(enrichedArtifact, signoff.configuration);
            EditApprovalSignoffNotificationContext notification = new EditApprovalSignoffNotificationContext(enrichedArtifact, signoff, groupData, authCtx.getIdentifier());
            this.scheduleSubscriberNotification(authCtx, notification, enrichedArtifact.artifact.id, Collections.singleton(authCtx.getIdentifier()));
        }
        this.validateAndStoreSignoff(signoff);
        this.subscriptionsService.automaticSubscribe(authCtx, enrichedArtifact.artifact.id);
        return approverResponse;
    }

    @Override
    @GHWriteTransaction
    public void deleteApproval(AuthCtx authCtx, SignoffId signoffId) throws IOException, DKUSecurityException {
        EnrichedArtifact enrichedArtifact = this.artifactsDataService.getArtifact(signoffId.artifactId);
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.getAssignedRolesAndPermissionsAndCheckReadPermissions(authCtx, enrichedArtifact);
        Signoff signoff = enrichedArtifact.findMandatorySignoffByStepId(signoffId.stepId);
        String authCtxIdentifier = authCtx.getIdentifier();
        this.validateThatSignoffWorkflowStepIsOnGoing(signoff.signoffId, enrichedArtifact);
        ValidatorUtils.validateThat(signoff.status.acceptsApprovalEdition(), "The sign-off must be already approved or rejected or abandoned to delete the approval", new Object[0]);
        SignoffApproval approverResponse = signoff.approverResponse;
        ValidatorUtils.validateThat(approverResponse != null, "The sign-off must have an approval to delete it", new Object[0]);
        if (signoff.status == Signoff.SignoffStatus.ABANDONED && approverResponse.status != SignoffApproval.SignoffApprovalStatus.ABANDONED) {
            throw new ValidationException("The approval cannot be deleted when the sign-off with id `" + String.valueOf(signoffId) + "` is abandoned with a previous approval approved or rejected");
        }
        boolean userCanDeleteApproval = StringUtils.equals((CharSequence)authCtxIdentifier, (CharSequence)approverResponse.user) || this.checkPermissionsService.hasArtifactAdminPermission(authCtx, assignedRolesAndPermissionsCtx.effectivePermissionsItem);
        ValidatorUtils.validateThat(userCanDeleteApproval, "User/API key '%s' cannot delete this approval", authCtxIdentifier);
        signoff.approverResponse = null;
        signoff.updateStatus(Signoff.SignoffStatus.WAITING_FOR_APPROVAL);
        SignoffGroupData groupData = this.retrieveGroupData(enrichedArtifact, signoff.configuration);
        DeleteApprovalSignoffNotificationContext notification = new DeleteApprovalSignoffNotificationContext(enrichedArtifact, signoff, groupData, authCtx.getIdentifier());
        this.scheduleSubscriberNotification(authCtx, notification, enrichedArtifact.artifact.id, Collections.singleton(authCtx.getIdentifier()));
        this.subscriptionsService.automaticSubscribe(authCtx, enrichedArtifact.artifact.id);
        this.validateAndStoreSignoff(signoff);
    }

    @Override
    @GHWriteTransaction
    public Signoff delegateApproval(AuthCtx authCtx, SignoffId signoffId, UserUsersContainer delegatedUser) throws IOException, DKUSecurityException {
        return this.delegateToUser(authCtx, signoffId, delegatedUser.login, null);
    }

    @Override
    @GHWriteTransaction
    @Nullable
    public Signoff updateStatus(AuthCtx authCtx, SignoffId signoffId, Signoff.SignoffStatus targetStatus, @Nullable Set<SignoffUserAndGroupId> usersToSendEmailTo, @Nullable Boolean reloadConfForReset) throws IOException, DKUSecurityException {
        EnrichedArtifact enrichedArtifact = this.getArtifactAndCheckWritePermissions(authCtx, signoffId.artifactId);
        Signoff signoff = enrichedArtifact.findMandatorySignoffByStepId(signoffId.stepId);
        String authCtxIdentifier = authCtx.getIdentifier();
        this.validateThatSignoffWorkflowStepIsOnGoing(signoff.signoffId, enrichedArtifact);
        Signoff.SignoffStatus sourceStatus = signoff.status;
        if (sourceStatus.equals((Object)targetStatus)) {
            throw new ValidationException("The sign-off with ID `" + String.valueOf(signoff.signoffId) + "` is already " + String.valueOf((Object)targetStatus));
        }
        if (sourceStatus.compareTo(targetStatus) < 0) {
            this.updateToUpwardStatus(authCtx, enrichedArtifact, signoff, targetStatus, usersToSendEmailTo, authCtxIdentifier);
        } else {
            signoff = this.updateToBackwardStatus(authCtx, enrichedArtifact, signoff, targetStatus, reloadConfForReset, authCtxIdentifier);
        }
        this.subscriptionsService.automaticSubscribe(authCtx, enrichedArtifact.artifact.id);
        if (signoff == null) {
            this.signoffsDataService.deleteSignoff(signoffId);
            return null;
        }
        return this.validateAndStoreSignoff(signoff);
    }

    @Override
    @GHWriteTransaction
    public Signoff scheduleReset(AuthCtx authCtx, SignoffId signoffId, SignoffRecurrenceConfiguration signoffRecurrenceConfiguration) throws IOException, DKUSecurityException, LimitsStatusComputer.LicenseLimitException {
        if (signoffRecurrenceConfiguration.activated) {
            try {
                this.checkPermissionsService.checkGovernBlueprintDesignerAllowed();
            }
            catch (LimitsStatusComputer.LicenseLimitException e) {
                throw new LimitsStatusComputer.LicenseLimitException("Your license does not allow you to use the sign-off recurrence");
            }
        }
        EnrichedArtifact enrichedArtifact = this.getArtifactAndCheckWritePermissions(authCtx, signoffId.artifactId);
        Signoff signoff = enrichedArtifact.findMandatorySignoffByStepId(signoffId.stepId);
        this.validateThatSignoffWorkflowStepIsOnGoing(signoff.signoffId, enrichedArtifact);
        signoff.configuration.recurrenceConfiguration = signoffRecurrenceConfiguration;
        this.subscriptionsService.automaticSubscribe(authCtx, enrichedArtifact.artifact.id);
        return this.validateAndStoreSignoff(signoff);
    }

    @Override
    @GHReadonlyTransaction
    public List<String> getStepsWithSignoffConfiguration(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        EnrichedArtifact enrichedArtifact = this.getArtifactAndCheckReadPermissions(authCtx, artifactId);
        return this.signoffsDataService.listSignoffsConfigurationsByBlueprintVersion(enrichedArtifact.blueprintVersion.id).stream().map(signoffConfig -> signoffConfig.id.stepId).collect(Collectors.toList());
    }

    private void updateToUpwardStatus(AuthCtx authCtx, EnrichedArtifact enrichedArtifact, Signoff signoff, Signoff.SignoffStatus targetStatus, @Nullable Set<SignoffUserAndGroupId> usersToSendEmailTo, String userWhoDidAction) throws IOException {
        Signoff.SignoffStatus sourceStatus = signoff.status;
        boolean canReachTargetStatus = this.workflowUpward.getOrDefault((Object)sourceStatus, (Set<Signoff.SignoffStatus>)ImmutableSet.of()).contains((Object)targetStatus);
        ValidatorUtils.validateThat(canReachTargetStatus, "Unable to set the status to '%s' when current status is '%s'", new Object[]{targetStatus, sourceStatus});
        if (Objects.equals((Object)targetStatus, (Object)Signoff.SignoffStatus.WAITING_FOR_FEEDBACK)) {
            signoff.feedbackRequesterIdentifier = userWhoDidAction;
            signoff.feedbackRequestDate = DateUtils.now();
        }
        if (Objects.equals((Object)targetStatus, (Object)Signoff.SignoffStatus.WAITING_FOR_APPROVAL)) {
            signoff.approvalRequesterIdentifier = userWhoDidAction;
            signoff.approvalRequestDate = DateUtils.now();
        }
        signoff.updateStatus(targetStatus);
        if (targetStatus.isRunning()) {
            Set<String> recipients;
            SignoffNotificationContext notification;
            SignoffGroupData groupData = this.retrieveGroupData(enrichedArtifact, signoff.configuration);
            if (targetStatus.equals((Object)Signoff.SignoffStatus.WAITING_FOR_FEEDBACK)) {
                HashMap<String, List<String>> groupsRequestedPerUser = new HashMap<String, List<String>>();
                if (usersToSendEmailTo == null) {
                    groupData.groupsPerUser.forEach((user, groups) -> groupsRequestedPerUser.put((String)user, groups.stream().map(g -> g.title).collect(Collectors.toList())));
                } else {
                    usersToSendEmailTo.forEach(s -> {
                        Optional<SignoffUsersGroup> feedbackGroup = signoff.configuration.findFeedbackGroupById(s.groupId);
                        if (feedbackGroup.isPresent()) {
                            groupsRequestedPerUser.computeIfAbsent(s.userLogin, login -> new ArrayList()).add(feedbackGroup.get().title);
                        } else {
                            logger.warnV("Cannot find feedback group for id %s", new Object[]{s.groupId});
                        }
                    });
                }
                notification = new RequestFeedbackSignoffNotificationContext(enrichedArtifact, signoff, groupData, userWhoDidAction, groupsRequestedPerUser);
                recipients = groupData.groupsPerUser.keySet().stream().filter(groupsRequestedPerUser::containsKey).collect(Collectors.toSet());
            } else {
                notification = new RequestApprovalSignoffNotificationContext(enrichedArtifact, signoff, groupData, userWhoDidAction);
                if (usersToSendEmailTo == null) {
                    recipients = new HashSet<String>(groupData.approvers);
                } else {
                    Set userSetFromUI = usersToSendEmailTo.stream().map(signoffUser -> signoffUser.userLogin).collect(Collectors.toSet());
                    recipients = groupData.approvers.stream().filter(userSetFromUI::contains).collect(Collectors.toSet());
                }
            }
            this.scheduleTargetedNotification(authCtx, notification, enrichedArtifact.artifact.id, recipients);
        } else if (Objects.equals((Object)targetStatus, (Object)Signoff.SignoffStatus.ABANDONED) && (Objects.equals((Object)sourceStatus, (Object)Signoff.SignoffStatus.APPROVED) || Objects.equals((Object)sourceStatus, (Object)Signoff.SignoffStatus.REJECTED))) {
            SignoffGroupData groupData = this.retrieveGroupData(enrichedArtifact, signoff.configuration);
            AbandonSignoffNotificationContext notification = new AbandonSignoffNotificationContext(enrichedArtifact, signoff, groupData, userWhoDidAction);
            this.scheduleSubscriberNotification(authCtx, notification, enrichedArtifact.artifact.id, Collections.singleton(userWhoDidAction));
        }
    }

    private Signoff updateToBackwardStatus(AuthCtx authCtx, EnrichedArtifact enrichedArtifact, Signoff signoff, Signoff.SignoffStatus targetStatus, @Nullable Boolean reloadConfForReset, String userWhoDidAction) throws IOException {
        Signoff.SignoffStatus sourceStatus = signoff.status;
        boolean canReachTargetStatus = this.workflowBackward.getOrDefault((Object)sourceStatus, (Set<Signoff.SignoffStatus>)ImmutableSet.of()).contains((Object)targetStatus);
        ValidatorUtils.validateThat(canReachTargetStatus, "Unable to set the status to '%s' when current status is '%s'", new Object[]{targetStatus, sourceStatus});
        if (Objects.equals((Object)Signoff.SignoffStatus.ABANDONED, (Object)sourceStatus) && !Objects.equals((Object)Signoff.SignoffStatus.NOT_STARTED, (Object)targetStatus)) {
            if (signoff.approverResponse != null && Objects.equals((Object)SignoffApproval.SignoffApprovalStatus.ABANDONED, (Object)signoff.approverResponse.status)) {
                throw new ValidationException("Can't cancel abandon as it would remove the final approval set to ABANDONED, signoff ID: " + String.valueOf(signoff.signoffId));
            }
            Signoff.SignoffStatus previousStatus = signoff.statusBeforeAbandoned;
            ValidatorUtils.validateThat(Objects.equals((Object)previousStatus, (Object)targetStatus), "Unable to reset the status to a different status than it was before the abandon (was '%s', given '%s')", new Object[]{previousStatus, targetStatus});
        }
        if (Objects.equals((Object)targetStatus, (Object)Signoff.SignoffStatus.NOT_STARTED)) {
            ValidatorUtils.validateThat(reloadConfForReset != null, "'reloadConfForReset' is mandatory", new Object[0]);
            signoff = reloadConfForReset != false ? this.buildNewSignoffReloadConfOrNull(enrichedArtifact.blueprintVersion.id, signoff.signoffId, signoff.cycleIndex + 1) : this.buildNewSignoffFromConf(signoff.configuration, signoff.signoffId, signoff.cycleIndex + 1);
        } else {
            signoff.updateStatus(targetStatus);
            if (Objects.equals((Object)sourceStatus, (Object)Signoff.SignoffStatus.ABANDONED) && (Objects.equals((Object)targetStatus, (Object)Signoff.SignoffStatus.APPROVED) || Objects.equals((Object)targetStatus, (Object)Signoff.SignoffStatus.REJECTED))) {
                SignoffGroupData groupData = this.retrieveGroupData(enrichedArtifact, signoff.configuration);
                CancelAbandonSignoffNotificationContext notification = new CancelAbandonSignoffNotificationContext(enrichedArtifact, signoff, groupData, userWhoDidAction);
                this.scheduleSubscriberNotification(authCtx, notification, enrichedArtifact.artifact.id, Collections.singleton(userWhoDidAction));
            }
        }
        return signoff;
    }

    private Signoff buildNewSignoffReloadConfOrNull(BlueprintVersionId blueprintVersionId, SignoffId signoffId, int cycleIndex) throws IOException {
        return Optional.ofNullable((SignoffConfiguration)this.signoffsConfigurationsDAO.getOrNull(SignoffConfigurationId.build(blueprintVersionId, signoffId.stepId))).map(config -> {
            Signoff signoff = this.buildNewSignoffFromConf((SignoffConfiguration)config, signoffId, cycleIndex);
            if (signoff.configuration.recurrenceConfiguration.activated && !this.checkPermissionsService.isGovernBlueprintDesignerAllowed()) {
                signoff.configuration.recurrenceConfiguration.activated = false;
            }
            return signoff;
        }).orElse(null);
    }

    private Signoff buildNewSignoffFromConf(SignoffConfiguration signoffConfiguration, SignoffId signoffId, int cycleIndex) {
        Signoff signoff = SignoffUtils.buildSignoffFromConfig(signoffId.artifactId, signoffConfiguration);
        signoff.cycleIndex = cycleIndex;
        return signoff;
    }

    @Override
    @GHWriteTransaction
    public void resetScheduledSignoffs_noAuth() throws IOException {
        List<SignoffIdAndBPVId> signoffIdsToReset = this.signoffsDataService.findScheduledSignoffsToReset();
        if (CollectionUtils.isEmpty(signoffIdsToReset)) {
            logger.info((Object)"Found no scheduled sign-offs to reset");
            return;
        }
        logger.infoV("Found %s scheduled sign-offs to reset", new Object[]{signoffIdsToReset.size()});
        AtomicInteger nbReset = new AtomicInteger();
        AtomicInteger nbIgnored = new AtomicInteger();
        int nbError = 0;
        for (SignoffIdAndBPVId signoffIdToReset : signoffIdsToReset) {
            try {
                ITransactionScope ts = this.transactionHandler.openNewWriteTransaction();
                try {
                    if (this.resetScheduledSignoff(signoffIdToReset)) {
                        nbReset.getAndIncrement();
                    } else {
                        nbIgnored.getAndIncrement();
                    }
                    ts.commit();
                }
                finally {
                    if (ts == null) continue;
                    ts.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error during sign-off reset " + String.valueOf(signoffIdToReset.signoffId)), (Throwable)e);
                ++nbError;
            }
        }
        logger.infoV("Done resetting scheduled sign-offs (%s reset, %s ignored, %s in error)", new Object[]{nbReset, nbIgnored, nbError});
    }

    private boolean resetScheduledSignoff(SignoffIdAndBPVId signoffIdToReset) throws IOException {
        SignoffConfiguration bpvSignoffConfiguration;
        this.signoffsDataService.lockSignoff(signoffIdToReset);
        if (!this.signoffsDataService.isSignoffScheduledToReset(signoffIdToReset.signoffId)) {
            logger.debugV("Sign-off %s doesn't need a reset anymore", new Object[]{signoffIdToReset.signoffId});
            return false;
        }
        EnrichedSignoff enrichedSignoffToReset = this.signoffsDataService.getSignoff(signoffIdToReset.signoffId);
        Signoff signoffToReset = enrichedSignoffToReset.signoff;
        SignoffRecurrenceConfiguration artifactRecurrenceConfiguration = signoffToReset.configuration.recurrenceConfiguration;
        Signoff resetSignoff = artifactRecurrenceConfiguration.reloadConf ? ((bpvSignoffConfiguration = enrichedSignoffToReset.signoffConfiguration) != null ? this.buildNewSignoffFromConf(bpvSignoffConfiguration, signoffToReset.signoffId, signoffToReset.cycleIndex + 1) : null) : this.buildNewSignoffFromConf(signoffToReset.configuration, signoffToReset.signoffId, signoffToReset.cycleIndex + 1);
        if (resetSignoff != null) {
            this.validateAndStoreSignoff(resetSignoff);
            logger.debugV("Sign-off %s has been reset", new Object[]{signoffToReset.signoffId});
        } else {
            this.signoffsDataService.deleteSignoff(signoffToReset.signoffId);
            logger.debugV("Sign-off %s has been removed: reloaded configuration does not exist anymore", new Object[]{enrichedSignoffToReset.signoff.signoffId});
        }
        return true;
    }

    private Signoff delegateToUser(AuthCtx authCtx, SignoffId signoffId, String delegatedUserLogin, @Nullable String groupId) throws IOException, DKUSecurityException {
        try (UserRolesCacheContext.ContextContainer rolesCache = UserRolesCacheContext.attachNewContext();){
            List<SignoffUser> users;
            boolean isFeedbackDelegation;
            EnrichedArtifact enrichedArtifact = this.artifactsDataService.getArtifact(signoffId.artifactId);
            AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.getAssignedRolesAndPermissionsAndCheckReadPermissions(authCtx, enrichedArtifact);
            Signoff signoff = enrichedArtifact.findMandatorySignoffByStepId(signoffId.stepId);
            String authCtxIdentifier = authCtx.getIdentifier();
            this.validateThatSignoffWorkflowStepIsOnGoing(signoff.signoffId, enrichedArtifact);
            boolean bl = isFeedbackDelegation = groupId != null;
            if (isFeedbackDelegation) {
                ValidatorUtils.validateThat(signoff.status.acceptsFeedbackDelegation(), "The sign-off must not be past waiting for feedback to delegate to a new user", new Object[0]);
                users = signoff.configuration.findFeedbackGroupById((String)groupId).orElseThrow((Supplier<ValidationException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$delegateToUser$19(java.lang.String ), ()Lcom/dataiku/gh/core/services/validation/errors/ValidationException;)((String)groupId)).users;
            } else {
                ValidatorUtils.validateThat(signoff.status.acceptsApprovalDelegation(), "The sign-off must not be past waiting for approval to delegate to a new user", new Object[0]);
                users = signoff.configuration.approvers;
            }
            this.validateThatLoggedUserCanDelegate(authCtx, assignedRolesAndPermissionsCtx, users, signoffId.artifactId);
            boolean newUserIsAlreadyPartOfTheGroup = users.stream().anyMatch(SignoffUtils.userUsersContainerContainsUser(delegatedUserLogin));
            if (newUserIsAlreadyPartOfTheGroup) {
                logger.infoV("User %s is already configured for %s, ignoring the delegation", new Object[]{delegatedUserLogin, isFeedbackDelegation ? "feedback" : "approval"});
                Signoff signoff2 = signoff;
                return signoff2;
            }
            users.add(this.buildDelegatedSignoffUserWithUsersContainer(delegatedUserLogin, authCtxIdentifier));
            SignoffGroupData groupData = this.retrieveGroupData(enrichedArtifact, signoff.configuration);
            if (isFeedbackDelegation) {
                Optional<SignoffUsersGroup> feedbackGroup = signoff.configuration.findFeedbackGroupById(groupId);
                if (feedbackGroup.isPresent()) {
                    Map<String, List<String>> groupsRequestedPerUser = Collections.singletonMap(delegatedUserLogin, Collections.singletonList(feedbackGroup.get().title));
                    RequestFeedbackSignoffNotificationContext notification = new RequestFeedbackSignoffNotificationContext(enrichedArtifact, signoff, groupData, authCtx.getIdentifier(), groupsRequestedPerUser);
                    this.scheduleTargetedNotification(authCtx, notification, enrichedArtifact.artifact.id, Collections.singleton(delegatedUserLogin));
                } else {
                    logger.warnV("Cannot find feedback group for id %s", new Object[]{groupId});
                }
            } else {
                RequestApprovalSignoffNotificationContext notification = new RequestApprovalSignoffNotificationContext(enrichedArtifact, signoff, groupData, authCtx.getIdentifier());
                this.scheduleTargetedNotification(authCtx, notification, enrichedArtifact.artifact.id, Collections.singleton(delegatedUserLogin));
            }
            this.subscriptionsService.automaticSubscribe(authCtx, enrichedArtifact.artifact.id);
            Signoff signoff3 = this.validateAndStoreSignoff(signoff);
            return signoff3;
        }
    }

    private EnrichedArtifact getArtifactAndCheckReadPermissions(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        EnrichedArtifact enrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
        this.getAssignedRolesAndPermissionsAndCheckReadPermissions(authCtx, enrichedArtifact);
        return enrichedArtifact;
    }

    private Optional<EnrichedArtifact> getOptionalArtifactIfCheckReadPermissions_NoLicenseCheck_UncheckedIOException(AuthCtx authCtx, String artifactId) {
        try {
            EnrichedArtifact enrichedArtifact = this.artifactsDataService.getArtifactOrNull(artifactId);
            if (enrichedArtifact != null && this.hasReadPermissions_NoLicenseCheck(authCtx, enrichedArtifact)) {
                return Optional.of(enrichedArtifact);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return Optional.empty();
    }

    private AssignedRolesAndPermissionsCtx getAssignedRolesAndPermissionsAndCheckReadPermissions(AuthCtx authCtx, EnrichedArtifact enrichedArtifact) throws IOException, DKUSecurityException {
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authCtx, enrichedArtifact);
        this.checkPermissionsService.checkArtifactReadPermission(authCtx, assignedRolesAndPermissionsCtx.effectivePermissionsItem, enrichedArtifact.artifact.id);
        return assignedRolesAndPermissionsCtx;
    }

    private boolean hasReadPermissions_NoLicenseCheck(AuthCtx authCtx, EnrichedArtifact enrichedArtifact) throws IOException {
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authCtx, enrichedArtifact);
        return this.checkPermissionsService.hasArtifactReadPermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem);
    }

    private EnrichedArtifact getArtifactAndCheckWritePermissions(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        EnrichedArtifact enrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authCtx, enrichedArtifact);
        this.checkPermissionsService.checkArtifactWritePermission(authCtx, assignedRolesAndPermissionsCtx.effectivePermissionsItem, artifactId);
        return enrichedArtifact;
    }

    public SignoffGroupData retrieveGroupData(EnrichedArtifact enrichedArtifact, SignoffConfiguration signoffConfiguration) throws IOException {
        try {
            Supplier<Map<String, IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole>> allRolesMappingForArtifactComputer = this.allRolesMappingForArtifactComputer_UncheckedIOException(enrichedArtifact);
            Supplier<List<UsersDAO.User>> allUsersComputer = this.listUsersUnsafe_UncheckedIOException();
            HashMap<String, List<SignoffUsersGroup>> groupsPerUser = new HashMap<String, List<SignoffUsersGroup>>();
            for (SignoffUsersGroup signoffUsersGroup : signoffConfiguration.feedbackUsersGroups) {
                this.unwrapSignoffUsersToUserUsersContainers_UncheckedIOException(signoffUsersGroup.users, allRolesMappingForArtifactComputer, allUsersComputer).forEach(userContainer -> groupsPerUser.computeIfAbsent(userContainer.login, login -> new ArrayList()).add(signoffUsersGroup));
            }
            Set<String> approvers = this.unwrapSignoffUsersToUserUsersContainers_UncheckedIOException(signoffConfiguration.approvers, allRolesMappingForArtifactComputer, allUsersComputer).stream().map(userContainer -> userContainer.login).collect(Collectors.toSet());
            return new SignoffGroupData(groupsPerUser, approvers);
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }

    private void scheduleSubscriberNotification(AuthCtx authCtx, SignoffNotificationContext notification, String artifactId, Set<String> userBlacklist) {
        TransactionUtils.executeAfterCommit(() -> {
            try {
                this.notificationService.sendEmailToSubscribers(authCtx, notification, artifactId, userBlacklist);
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Unable to send emails for artifact '%s'", new Object[]{artifactId});
            }
        });
    }

    private void scheduleTargetedNotification(AuthCtx authCtx, SignoffNotificationContext notification, String artifactId, Set<String> userLogins) {
        TransactionUtils.executeAfterCommit(() -> {
            try {
                this.notificationService.sendEmailToUsers(authCtx, notification, userLogins);
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Unable to send emails for artifact '%s'", new Object[]{artifactId});
            }
        });
    }

    private List<UserUsersContainer> unwrapSignoffUsersToUserUsersContainers_UncheckedIOException(List<SignoffUser> signoffUsers, Supplier<Map<String, IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole>> roleIdToUserLoginsAndAPIKeyIds, Supplier<List<UsersDAO.User>> allUsers) throws UncheckedIOException {
        UsersContainersExtraction extraction = signoffUsers.stream().map(signoffUser -> signoffUser.usersContainer).collect(new UsersContainerExtractor());
        HashSet<String> userLogins = new HashSet<String>();
        userLogins.addAll(extraction.logins);
        userLogins.addAll(extraction.roleIds.stream().map(roleId -> (IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole)((Map)roleIdToUserLoginsAndAPIKeyIds.get()).get(roleId)).filter(Objects::nonNull).flatMap(it -> it.userLogins.stream()).collect(Collectors.toSet()));
        if (CollectionUtils.isNotEmpty(extraction.groupNames)) {
            userLogins.addAll(allUsers.get().stream().filter(user -> user.groups.stream().anyMatch(extraction.groupNames::contains)).map(user -> user.login).collect(Collectors.toSet()));
        }
        return userLogins.stream().sorted().map(UserUsersContainer::build).collect(Collectors.toList());
    }

    private List<SignoffUsersContainerRelation> unwrapSignoffUsersToSignoffUsersContainerRelation_UncheckedIOException(List<SignoffUser> signoffUsers, Supplier<Map<String, IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole>> roleIdToUserLoginsAndAPIKeyIds, Supplier<List<UsersDAO.User>> allUsers, Supplier<List<GlobalScopePublicAPIKeyWithGroups>> allGlobalApiKeysWithGroups) throws UncheckedIOException {
        HashMap userRelationsMap = new HashMap();
        UsersContainersExtraction extraction = signoffUsers.stream().map(signoffUser -> signoffUser.usersContainer).collect(new UsersContainerExtractor());
        extraction.logins.stream().map(UserUsersContainer::build).map(SignoffUsersContainerRelation::build).forEach(userRelation -> userRelationsMap.put(userRelation.user, userRelation));
        extraction.globalAPIKeyIds.stream().map(GlobalAPIKeyUsersContainer::build).map(SignoffUsersContainerRelation::build).forEach(userRelation -> userRelationsMap.put(userRelation.user, userRelation));
        Set computedUsersAndAPIKeysForRoles = extraction.roleIds.stream().map(roleId -> (IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole)((Map)roleIdToUserLoginsAndAPIKeyIds.get()).get(roleId)).filter(Objects::nonNull).collect(Collectors.toSet());
        for (IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole computedUsersAndAPIKeys : computedUsersAndAPIKeysForRoles) {
            computedUsersAndAPIKeys.userLogins.stream().map(UserUsersContainer::build).map(userContainer -> userRelationsMap.computeIfAbsent(userContainer, SignoffUsersContainerRelation::build)).forEach(usersContainerRelation -> usersContainerRelation.grantedBy.add(RoleUsersContainer.build(computedUsersAndAPIKeys.role.id)));
            computedUsersAndAPIKeys.apiKeyIds.stream().map(GlobalAPIKeyUsersContainer::build).map(apiKeyUserContainer -> userRelationsMap.computeIfAbsent(apiKeyUserContainer, SignoffUsersContainerRelation::build)).forEach(apiKeyContainerRelation -> apiKeyContainerRelation.grantedBy.add(RoleUsersContainer.build(computedUsersAndAPIKeys.role.id)));
        }
        if (CollectionUtils.isNotEmpty(extraction.groupNames)) {
            for (UsersDAO.User user : allUsers.get()) {
                UserUsersContainer userContainer2 = UserUsersContainer.build(user.login);
                user.groups.stream().filter(extraction.groupNames::contains).forEach(groupName -> userRelationsMap.computeIfAbsent(userContainer, (Function<UsersContainer, SignoffUsersContainerRelation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, build(com.dataiku.gh.core.models.security.UsersContainer ), (Lcom/dataiku/gh/core/models/security/UsersContainer;)Lcom/dataiku/gh/core/models/signoff/SignoffUsersContainerRelation;)()).grantedBy.add(GroupUsersContainer.build(groupName)));
            }
            for (GlobalScopePublicAPIKeyWithGroups apiKey : allGlobalApiKeysWithGroups.get()) {
                GlobalAPIKeyUsersContainer apiKeyContainer = GlobalAPIKeyUsersContainer.build(apiKey.id);
                apiKey.getGroups().stream().filter(extraction.groupNames::contains).forEach(groupName -> userRelationsMap.computeIfAbsent(apiKeyContainer, (Function<UsersContainer, SignoffUsersContainerRelation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, build(com.dataiku.gh.core.models.security.UsersContainer ), (Lcom/dataiku/gh/core/models/security/UsersContainer;)Lcom/dataiku/gh/core/models/signoff/SignoffUsersContainerRelation;)()).grantedBy.add(GroupUsersContainer.build(groupName)));
            }
        }
        return new ArrayList<SignoffUsersContainerRelation>(userRelationsMap.values());
    }

    private void validateThatLoggedUserIsWithinTheGroup(AuthCtx authCtx, List<SignoffUser> users, String artifactId, @PrintFormat String errorMsg, Object ... errorMsgParams) throws IOException {
        try {
            boolean userIsPartOfTheGroup = users.stream().anyMatch(this.containsUser_UncheckedIOException(authCtx, artifactId));
            ValidatorUtils.validateThat(userIsPartOfTheGroup, errorMsg, errorMsgParams);
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }

    private void validateThatLoggedUserCanDelegate(AuthCtx authCtx, AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx, List<SignoffUser> users, String artifactId) throws IOException {
        try {
            boolean userCanDelegate = this.checkPermissionsService.hasArtifactAdminPermission(authCtx, assignedRolesAndPermissionsCtx.effectivePermissionsItem) || !DKUApp.getParams().getBoolParam("dku.govern.preventSignoffDelegateForNonAdmins", false) && users.stream().anyMatch(this.containsUser_UncheckedIOException(authCtx, artifactId));
            ValidatorUtils.validateThat(userCanDelegate, "User '%s' cannot delegate", authCtx.getIdentifier());
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }

    private Predicate<SignoffUser> containsUser_UncheckedIOException(AuthCtx authCtx, String artifactId) throws UncheckedIOException {
        return user -> user != null && Stream.of(user).anyMatch(SignoffUtils.userUsersContainerContainsUser(authCtx.getAssociatedDSSUser()).or(this.globalApiKeyUsersContainerContainsUser(authCtx)).or(this.roleUsersContainerContainsUser_UncheckedIOException(authCtx, artifactId)).or(this.groupUsersContainerContainsUser(authCtx)));
    }

    private Predicate<SignoffUser> roleUsersContainerContainsUser_UncheckedIOException(AuthCtx authCtx, String artifactId) throws UncheckedIOException {
        Supplier<Set<String>> roles = this.rolesForUserAndArtifactComputer_UncheckedIOException(authCtx, artifactId);
        return user -> {
            if (user == null || !(user.usersContainer instanceof RoleUsersContainer)) {
                return false;
            }
            String roleId = ((RoleUsersContainer)user.usersContainer).roleId;
            return ((Set)roles.get()).contains(roleId);
        };
    }

    private Predicate<SignoffUser> groupUsersContainerContainsUser(AuthCtx authCtx) {
        return user -> {
            if (user == null || !(user.usersContainer instanceof GroupUsersContainer) || !authCtx.isGroupsAware()) {
                return false;
            }
            String groupName = ((GroupUsersContainer)user.usersContainer).groupName;
            return authCtx.isInGroup(groupName);
        };
    }

    private Predicate<SignoffUser> globalApiKeyUsersContainerContainsUser(AuthCtx authCtx) throws UncheckedIOException {
        String authCtxIdentifier = authCtx.getIdentifier();
        Predicate<SignoffUser> globalApiKeyPredicate = StringUtils.startsWith((CharSequence)authCtxIdentifier, (CharSequence)"api:") ? SignoffUtils.globalApikeyUsersContainerContainsApiKeyId(StringUtils.substringAfter((String)authCtxIdentifier, (String)"api:")) : user -> false;
        return globalApiKeyPredicate;
    }

    private Supplier<Set<String>> rolesForUserAndArtifactComputer_UncheckedIOException(AuthCtx authCtx, String artifactId) {
        return Suppliers.memoize(() -> {
            try {
                EnrichedArtifact enrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
                return this.userBlueprintRoleAssignmentsComputationService.computeRolesAtArtifactExistingLevel(authCtx, enrichedArtifact);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private Supplier<Map<String, IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole>> allRolesMappingForArtifactComputer_UncheckedIOException(EnrichedArtifact enrichedArtifact) {
        return Suppliers.memoize(() -> {
            try {
                return this.usersAndAPIKeysBlueprintRoleAssignmentsComputationService.computeUserLoginsAndAPIKeyIdsForRolesAtArtifactExistingLevel(enrichedArtifact).stream().collect(Collectors.toMap(it -> it.role.id, Function.identity()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private Supplier<List<UsersDAO.User>> listUsersUnsafe_UncheckedIOException() {
        return Suppliers.memoize(() -> {
            List<UsersDAO.User> list;
            block8: {
                Transaction t = this.transactionService.beginRead();
                try {
                    list = this.usersDAO.listUsersUnsafe();
                    if (t == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (t != null) {
                            try {
                                t.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                t.close();
            }
            return list;
        });
    }

    private Supplier<List<GlobalScopePublicAPIKeyWithGroups>> listGlobalApiKeysWithGroups_UncheckedIOException() {
        return Suppliers.memoize(() -> {
            List<GlobalScopePublicAPIKeyWithGroups> list;
            block8: {
                Transaction t = this.transactionService.beginRead();
                try {
                    list = this.publicAPIKeysService.listGlobalAPIKeys().stream().filter(apiKey -> apiKey instanceof GlobalScopePublicAPIKeyWithGroups).map(apiKey -> (GlobalScopePublicAPIKeyWithGroups)((Object)((Object)apiKey))).toList();
                    if (t == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (t != null) {
                            try {
                                t.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                t.close();
            }
            return list;
        });
    }

    private Signoff validateAndCreateSignoff(Signoff signoff) throws IOException {
        this.signoffsValidationService.validateSignoff(signoff);
        return this.signoffsDataService.createSignoff((Signoff)signoff).signoff;
    }

    private Signoff validateAndStoreSignoff(Signoff signoff) throws IOException {
        this.signoffsValidationService.validateSignoff(signoff);
        return this.signoffsDataService.storeSignoff((Signoff)signoff).signoff;
    }

    private SignoffUser buildDelegatedSignoffUserWithUsersContainer(String usersContainerLogin, String addedByUser) {
        SignoffUser newSignoffUser = new SignoffUser();
        UserUsersContainer newUserContainer = new UserUsersContainer();
        newSignoffUser.usersContainer = newUserContainer;
        newUserContainer.login = usersContainerLogin;
        newSignoffUser.updateAddedBy(addedByUser);
        newSignoffUser.delegated = true;
        return newSignoffUser;
    }

    private void validateThatSignoffWorkflowStepIsOnGoing(SignoffId signoffId, EnrichedArtifact enrichedArtifact) {
        if (!StringUtils.equals((CharSequence)enrichedArtifact.getCurrentOngoingWorkflowStepId(), (CharSequence)signoffId.stepId)) {
            throw new ValidationException("Cannot modify a sign-off `" + String.valueOf(signoffId) + "` on a not active step");
        }
    }

    private boolean isFeedbackOrApprovalRequestedForUser(String user, Signoff signoff, Supplier<Map<String, IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole>> roleIdToUserLoginsAndAPIKeyIds, Supplier<List<UsersDAO.User>> allUsers) {
        if (signoff.status.equals((Object)Signoff.SignoffStatus.WAITING_FOR_FEEDBACK)) {
            Set userFeedbackIds = signoff.feedbackResponses.stream().filter(fr -> fr.user.equals(user)).map(fr -> fr.groupId).collect(Collectors.toSet());
            return signoff.configuration.feedbackUsersGroups.stream().filter(fg -> !userFeedbackIds.contains(fg.getId())).map(fg -> this.unwrapSignoffUsersToUserUsersContainers_UncheckedIOException(fg.users, roleIdToUserLoginsAndAPIKeyIds, allUsers)).flatMap(Collection::stream).anyMatch(userContainer -> userContainer.login.equals(user));
        }
        if (signoff.status.equals((Object)Signoff.SignoffStatus.WAITING_FOR_APPROVAL)) {
            return this.unwrapSignoffUsersToUserUsersContainers_UncheckedIOException(signoff.configuration.approvers, roleIdToUserLoginsAndAPIKeyIds, allUsers).stream().anyMatch(userContainer -> userContainer.login.equals(user));
        }
        return false;
    }

    private static /* synthetic */ ValidationException lambda$delegateToUser$19(String groupId) {
        return new ValidationException(String.format("Cannot find group '%s'", groupId));
    }

    private static /* synthetic */ Signoff lambda$searchUserSignoffs$3(Pair p) {
        return (Signoff)p.first;
    }

    private /* synthetic */ boolean lambda$searchUserSignoffs$2(String user, Supplier allUsersComputer, Pair p) {
        EnrichedArtifact enrichedArtifact = (EnrichedArtifact)((Optional)p.second).get();
        Signoff signoff = (Signoff)p.first;
        return switch (signoff.status) {
            case Signoff.SignoffStatus.APPROVED, Signoff.SignoffStatus.ABANDONED, Signoff.SignoffStatus.REJECTED -> {
                if (signoff.approverResponse != null && signoff.approverResponse.user.equals(user)) {
                    yield true;
                }
                yield false;
            }
            case Signoff.SignoffStatus.WAITING_FOR_APPROVAL, Signoff.SignoffStatus.WAITING_FOR_FEEDBACK -> {
                Supplier<Map<String, IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole>> allRolesMappingComputer = this.allRolesMappingForArtifactComputer_UncheckedIOException(enrichedArtifact);
                yield this.isFeedbackOrApprovalRequestedForUser(user, signoff, allRolesMappingComputer, allUsersComputer);
            }
            default -> false;
        };
    }

    private static /* synthetic */ boolean lambda$searchUserSignoffs$1(Pair p) {
        return ((Optional)p.second).isPresent();
    }

    private /* synthetic */ Pair lambda$searchUserSignoffs$0(AuthCtx authCtx, EnrichedSignoff enrichedSignoff) {
        return new Pair((Object)enrichedSignoff.signoff, this.getOptionalArtifactIfCheckReadPermissions_NoLicenseCheck_UncheckedIOException(authCtx, enrichedSignoff.signoff.signoffId.artifactId));
    }
}

