/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.admin;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.gh.core.models.configuration.DkuInternalSettingsGovernConfiguration;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.storage.admin.IDBDumpDAO;
import com.dataiku.gh.core.storage.sql.AbstractPostgreSQLClient;
import com.dataiku.gh.core.storage.sql.Constants;
import com.dataiku.gh.core.storage.sql.model.QGovernConfiguration;
import com.dataiku.gh.core.storage.sql.model.QGovernSchemaVersion;
import com.dataiku.gh.core.storage.sql.model.Q_historyRevisions;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.google.common.base.Joiner;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.NumberTemplate;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLInsertClause;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class DBDumpDAO
extends AbstractPostgreSQLClient
implements IDBDumpDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.cli.govern-reload-db");

    @Override
    @GHReadonlyTransaction
    public void dumpDB(File targetFolder, boolean includeHistoryTables) throws IOException {
        block17: {
            try (OutputStream os = Files.newOutputStream(DBDumpDAO.getTableFile(targetFolder, "postgres-version.txt").toPath(), StandardOpenOption.CREATE_NEW);){
                String version = (String)this.querydslJdbcTemplate.queryForObject("SELECT version();", String.class);
                if (!StringUtils.isNotBlank((CharSequence)version)) break block17;
                try {
                    os.write(version.getBytes(StandardCharsets.UTF_8));
                    os.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        for (Constants.DBTableWithColumnInfo tableInfo : Constants.ALL_DB_TABLES) {
            if (Objects.equals(tableInfo.table, (Object)Q_historyRevisions.HistoryRevisions) || !includeHistoryTables && tableInfo.isHistoryTable()) continue;
            ArrayList<Object> selectPaths = new ArrayList<Object>();
            if (tableInfo.jsonColumn != null) {
                selectPaths.add(tableInfo.jsonColumn);
            }
            if (tableInfo.revisionJsonColumn != null) {
                selectPaths.add(tableInfo.revisionJsonColumn);
            }
            SQLQuery sqlQuery = (SQLQuery)this.sqlQueryFactory.select((Expression[])selectPaths.toArray(new Path[0])).from(tableInfo.table);
            try (OutputStream os = Files.newOutputStream(DBDumpDAO.getTableFile(targetFolder, tableInfo.table.getTableName()).toPath(), StandardOpenOption.CREATE_NEW);){
                this.querydslJdbcTemplate.queryForStream(sqlQuery, (rs, rowNum) -> {
                    ArrayList<String> ret = new ArrayList<String>();
                    for (Path path : selectPaths) {
                        ret.add(rs.getString(ColumnMetadata.getName((Path)path)));
                    }
                    return ret;
                }).forEach(items -> {
                    try {
                        os.write((Joiner.on((String)"\t").join((Iterable)items) + "\n").getBytes(StandardCharsets.UTF_8));
                        os.flush();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }

    @Override
    @GHWriteTransaction
    public void reloadDB(File sourceFolder, boolean excludeHistoryTables, boolean noDiagDb) throws IOException, SQLException {
        String allTables = Arrays.stream(Constants.ALL_DB_TABLES).map(table -> table.table.getTableName()).collect(Collectors.joining(", "));
        this.querydslJdbcTemplate.update("TRUNCATE TABLE " + allTables + " CASCADE;");
        this.querydslJdbcTemplate.execute("SET CONSTRAINTS ALL DEFERRED;");
        for (Constants.DBTableWithColumnInfo tableInfo : Constants.ALL_DB_TABLES) {
            this.loadTable(sourceFolder, excludeHistoryTables, tableInfo);
        }
        for (Constants.DBSequenceWithTableInfo seq : Constants.ALL_DB_SEQUENCES) {
            this.updateSequence(seq);
        }
        this.querydslJdbcTemplate.execute("SET CONSTRAINTS ALL IMMEDIATE;");
        if (!noDiagDb) {
            SQLInsertClause insertClause = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QGovernConfiguration.governConfiguration).columns(new Path[]{QGovernConfiguration.governConfiguration.configurationItemJson})).values(new Object[]{QueryBuilderUtils.toJsonbAsExpression(DkuInternalSettingsGovernConfiguration.build(true))});
            this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insertClause);
        }
        this.querydslJdbcTemplate.execute("ANALYZE;");
    }

    private void loadTable(File sourceFolder, boolean excludeHistoryTables, Constants.DBTableWithColumnInfo tableInfo) throws IOException, SQLException {
        if (Objects.equals(tableInfo.table, (Object)Q_historyRevisions.HistoryRevisions)) {
            return;
        }
        if (excludeHistoryTables && tableInfo.isHistoryTable()) {
            return;
        }
        File tableFile = DBDumpDAO.getTableFile(sourceFolder, tableInfo.table.getTableName());
        if (!Files.exists(tableFile.toPath(), new LinkOption[0]) || Files.size(tableFile.toPath()) == 0L) {
            logger.info((Object)("Skipping empty or missing file: " + tableFile.getName()));
            return;
        }
        ArrayList<Object> selectPaths = new ArrayList<Object>();
        if (tableInfo.jsonColumn != null) {
            selectPaths.add(tableInfo.jsonColumn);
        }
        if (tableInfo.revisionJsonColumn != null) {
            selectPaths.add(tableInfo.revisionJsonColumn);
        }
        Objects.requireNonNull(this.querydslJdbcTemplate.getDataSource());
        BaseConnection pgConn = DataSourceUtils.getConnection((DataSource)this.querydslJdbcTemplate.getDataSource()).unwrap(BaseConnection.class);
        CopyManager copyManager = new CopyManager(pgConn);
        ArrayList<String> colsNames = new ArrayList<String>();
        for (Path path : selectPaths) {
            colsNames.add(Objects.requireNonNull(tableInfo.table.getMetadata(path)).getName());
        }
        String columns = String.join((CharSequence)", ", colsNames);
        String string = "COPY " + String.valueOf(tableInfo.table) + " (" + columns + ") FROM STDIN WITH (FORMAT csv, DELIMITER '\t', QUOTE '\b', ESCAPE '\\')";
        try (BufferedReader reader = new BufferedReader(new FileReader(tableFile));){
            long inserted = copyManager.copyIn(string, (Reader)reader);
            logger.info((Object)(String.valueOf(LocalDateTime.now()) + ": Inserted " + inserted + " rows into " + String.valueOf(tableInfo.table)));
        }
    }

    private void updateSequence(Constants.DBSequenceWithTableInfo seqInfo) {
        SQLQuery query;
        NumberPath maxId = Expressions.numberPath(Long.class, (String)"max_id");
        NumberTemplate mainMax = Expressions.numberTemplate(Long.class, (String)"regexp_replace({0}::text, '.*?(\\d+)$', '\\1')::bigint", (Object[])new Object[]{seqInfo.idColumn()});
        SQLQuery mainQuery = (SQLQuery)this.sqlQueryFactory.select((Expression)mainMax.max().as((Path)maxId)).from(seqInfo.table());
        if (seqInfo.historyTable() == null) {
            query = mainQuery;
        } else {
            NumberTemplate historyMax = Expressions.numberTemplate(Long.class, (String)"regexp_replace({0}::text, '.*?(\\d+)$', '\\1')::bigint", (Object[])new Object[]{seqInfo.historyIdColumn()});
            SQLQuery historyQuery = (SQLQuery)this.sqlQueryFactory.select((Expression)historyMax.max().as((Path)maxId)).from(seqInfo.historyTable());
            query = (SQLQuery)this.sqlQueryFactory.select((Expression)maxId.max()).from(SQLExpressions.unionAll((SubQueryExpression[])new SubQueryExpression[]{mainQuery, historyQuery}).as("u"));
        }
        List<Long> maxIdValue = this.querydslJdbcTemplate.queryForList(query, Long.class);
        if (maxIdValue.isEmpty()) {
            logger.info((Object)String.format("Skipping sequence %s with no id on table %s", seqInfo.name(), seqInfo.table().getTableName()));
            return;
        }
        String sql = "SELECT setval('" + seqInfo.name() + "', " + String.valueOf(maxIdValue.get(0)) + ", true)";
        this.querydslJdbcTemplate.execute(sql);
    }

    @NotNull
    private static File getTableFile(File sourceFolder, String table) {
        return new File(sourceFolder, table + ".txt");
    }

    public static Long getDumpVersion(File sourceDirFile) throws IOException {
        String lastLine = null;
        File tableFile = DBDumpDAO.getTableFile(sourceDirFile, QGovernSchemaVersion.governSchemaVersion.getTableName());
        try (BufferedReader reader = new BufferedReader(new FileReader(tableFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                lastLine = line;
            }
        }
        if (lastLine == null) {
            throw new IOException(String.format("Unable to extract db version from dump folder. Please ensure the file %s is correctly formatted", tableFile.getName()));
        }
        return Long.parseLong(lastLine);
    }
}

