/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.blueprints;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionTrace;
import com.dataiku.gh.core.storage.blueprints.IBlueprintVersionTraceDAO;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.blueprints.BlueprintVersionTraceRowMapper;
import com.dataiku.gh.core.storage.sql.model.QBlueprintVersionTraces;
import com.dataiku.gh.core.storage.sql.model.QBlueprintVersionTracesHistory;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class BlueprintVersionTraceDAO
extends AbstractItemBasedDAO<BlueprintVersionId, BlueprintVersionTrace, BlueprintVersionTrace>
implements IBlueprintVersionTraceDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.blueprint-version-traces");
    @Autowired
    private BlueprintVersionTraceRowMapper blueprintVersionTraceRowMapper;

    @Override
    protected EntityType getEntityType() {
        return EntityType.BLUEPRINT_VERSION_TRACE;
    }

    @Override
    protected RowMapper<BlueprintVersionTrace> getRowMapper() {
        return this.blueprintVersionTraceRowMapper;
    }

    @Override
    protected BlueprintVersionId getId(BlueprintVersionTrace item) {
        return item.blueprintVersionId;
    }

    @Override
    protected RelationalPathBase<?> getItemTablePath() {
        return QBlueprintVersionTraces.blueprintVersionTraces;
    }

    @Override
    protected SimplePath<Object> getItemTableJsonColumnPath() {
        return QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceJson;
    }

    @Override
    protected Predicate getIdCondition(BlueprintVersionId blueprintVersionId) {
        return QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceBlueprintId.eq((Object)blueprintVersionId.blueprintId).and((Predicate)QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceVersionId.eq((Object)blueprintVersionId.versionId));
    }

    @Override
    protected RelationalPathBase<?> getHistoryTablePath() {
        return QBlueprintVersionTracesHistory.blueprintVersionTracesHistory;
    }

    @Override
    protected SimplePath<Object> getHistoryRevisionColumnPath() {
        return QBlueprintVersionTracesHistory.blueprintVersionTracesHistory._revisionJson;
    }

    @Override
    protected SimplePath<Object> getHistoryJsonColumnPath() {
        return QBlueprintVersionTracesHistory.blueprintVersionTracesHistory.blueprintVersionTraceJson;
    }

    @Override
    public List<BlueprintVersionTrace> listByOriginVersion(BlueprintVersionId blueprintVersionId) throws IOException {
        SQLQuery query = (SQLQuery)this.buildBaseSelectQuery().where((Predicate)QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceBlueprintId.eq((Object)blueprintVersionId.blueprintId).and((Predicate)QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceOriginVersionId.eq((Object)blueprintVersionId.versionId)));
        try {
            return this.querydslJdbcTemplate.query(query, this.blueprintVersionTraceRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }
}

