/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.model;

import com.dataiku.gh.core.models.artifacts.ArtifactWorkflowStep;
import com.dataiku.gh.core.storage.sql.model.QArtifacts;
import com.dataiku.gh.core.storage.sql.model.QBlueprintVersionsStepsIndices;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadataFactory;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.SimpleTemplate;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class QArtifactWorkflowCurrentStatus
extends RelationalPathBase<QArtifactWorkflowCurrentStatus> {
    private static final String queryName = "artifact_workflow_current_status";
    public static final int NO_WORKFLOW_STATUS = 0;
    public static final int NOT_STARTED_STATUS = 1;
    public static final int ONGOING_STATUS = 2;
    public static final int FINISHED_STATUS = 3;
    private static final long serialVersionUID = -3450490643755430116L;
    private static final QArtifactWorkflowCurrentStatus artifactWorkflowCurrentStatus;
    public static final QArtifactWorkflowCurrentStatus artifactWorkflowCurrentStatusAlias;
    public static final SubQueryExpression<?> artifactWorkflowCurrentStatusQuery;
    public final StringPath artifactId = this.createString("artifactId");
    public final NumberPath<Integer> workflowStatus = this.createNumber("workflowStatus", Integer.class);
    public final NumberPath<Integer> workflowProgress = this.createNumber("workflowProgress", Integer.class);
    public final NumberPath<Integer> nbSteps = this.createNumber("nbSteps", Integer.class);
    public final NumberPath<Integer> nbVisibleSteps = this.createNumber("nbVisibleSteps", Integer.class);

    public QArtifactWorkflowCurrentStatus(String variable) {
        super(QArtifactWorkflowCurrentStatus.class, PathMetadataFactory.forVariable((String)variable), "public", queryName);
        this.addMetadata();
    }

    public void addMetadata() {
        int index = 1;
        this.addMetadata((Path)this.artifactId, ColumnMetadata.named((String)"artifact_id").withIndex(index++).ofType(12).withSize(Integer.MAX_VALUE));
        this.addMetadata((Path)this.workflowStatus, ColumnMetadata.named((String)"workflow_status").withIndex(index++).ofType(-5).withSize(1));
        this.addMetadata((Path)this.workflowProgress, ColumnMetadata.named((String)"workflow_progress").withIndex(index++).ofType(8).withSize(19));
        this.addMetadata((Path)this.nbSteps, ColumnMetadata.named((String)"nb_steps").withIndex(index++).ofType(-5).withSize(19));
        this.addMetadata((Path)this.nbVisibleSteps, ColumnMetadata.named((String)"nb_visible_steps").withIndex(index++).ofType(-5).withSize(19));
    }

    private SQLQuery<Tuple> getArtifactWorkflowCurrentStatusQuery() {
        BooleanExpression noVisibleStep = QArtifactWorkflowStepsCount.artifactWorkflowStepsCount.nbVisibleSteps.eq(QueryBuilderUtils.unsafeInQueryConstant(0));
        BooleanExpression allVisibleStepsAreNotStarted = QArtifactWorkflowStepsCount.artifactWorkflowStepsCount.nbNotStartedVisibleSteps.eq(QArtifactWorkflowStepsCount.artifactWorkflowStepsCount.nbVisibleSteps);
        BooleanExpression allVisibleStepsAreFinishedOrSkipped = QArtifactWorkflowStepsCount.artifactWorkflowStepsCount.nbFinishedVisibleSteps.add(QArtifactWorkflowStepsCount.artifactWorkflowStepsCount.nbSkippedVisibleSteps).eq(QArtifactWorkflowStepsCount.artifactWorkflowStepsCount.nbVisibleSteps);
        BooleanExpression hasOngoingOrLastFinishedStepIndex = QArtifactWorkflowStepsCount.artifactWorkflowStepsCount.workflowProgress.isNotNull();
        SimpleExpression workflowStatusColumnExpression = (SimpleExpression)Expressions.cases().when((Predicate)noVisibleStep).then(QueryBuilderUtils.unsafeInQueryConstant(0)).when((Predicate)allVisibleStepsAreNotStarted).then(QueryBuilderUtils.unsafeInQueryConstant(1)).when((Predicate)allVisibleStepsAreFinishedOrSkipped).then(QueryBuilderUtils.unsafeInQueryConstant(3)).when((Predicate)hasOngoingOrLastFinishedStepIndex).then(QueryBuilderUtils.unsafeInQueryConstant(2)).otherwise((Expression)Expressions.nullExpression(Integer.class));
        SimpleExpression ongoingStepIndexColumnExpression = (SimpleExpression)Expressions.cases().when((Predicate)allVisibleStepsAreFinishedOrSkipped).then((Expression)Expressions.nullExpression(Integer.class)).otherwise(QArtifactWorkflowStepsCount.artifactWorkflowStepsCount.workflowProgress);
        return (SQLQuery)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{QArtifactWorkflowStepsCount.artifactWorkflowStepsCount.artifactId.as(ColumnMetadata.getName((Path)this.artifactId)), workflowStatusColumnExpression.as(ColumnMetadata.getName(this.workflowStatus)), ongoingStepIndexColumnExpression.as(ColumnMetadata.getName(this.workflowProgress)), QArtifactWorkflowStepsCount.artifactWorkflowStepsCount.nbVisibleSteps.add(QArtifactWorkflowStepsCount.artifactWorkflowStepsCount.nbInvisibleSteps).as(ColumnMetadata.getName(this.nbSteps)), QArtifactWorkflowStepsCount.artifactWorkflowStepsCount.nbVisibleSteps.as(ColumnMetadata.getName(this.nbVisibleSteps))}).with((Path)QArtifactWorkflowStepsCount.artifactWorkflowStepsCount, QArtifactWorkflowStepsCount.artifactWorkflowStepsCount.getArtifactWorkflowStepsCountQuery())).from((Expression)QArtifactWorkflowStepsCount.artifactWorkflowStepsCount);
    }

    static {
        artifactWorkflowCurrentStatusAlias = artifactWorkflowCurrentStatus = new QArtifactWorkflowCurrentStatus(queryName);
        artifactWorkflowCurrentStatusQuery = artifactWorkflowCurrentStatus.getArtifactWorkflowCurrentStatusQuery();
    }

    protected static class QArtifactWorkflowStepsCount
    extends RelationalPathBase<QArtifactWorkflowStepsCount> {
        private static final String queryName = "artifacts_workflow_steps_count";
        private static final long serialVersionUID = 8176183737481667867L;
        public static final QArtifactWorkflowStepsCount artifactWorkflowStepsCount = new QArtifactWorkflowStepsCount("artifacts_workflow_steps_count");
        public final StringPath artifactId = this.createString("artifactId");
        public final NumberPath<Integer> workflowProgress = this.createNumber("workflowProgress", Integer.class);
        public final NumberPath<Integer> nbInvisibleSteps = this.createNumber("nbInvisibleSteps", Integer.class);
        public final NumberPath<Integer> nbVisibleSteps = this.createNumber("nbVisibleSteps", Integer.class);
        public final NumberPath<Integer> nbNotStartedVisibleSteps = this.createNumber("nbNotStartedVisibleSteps", Integer.class);
        public final NumberPath<Integer> nbFinishedVisibleSteps = this.createNumber("nbFinishedVisibleSteps", Integer.class);
        public final NumberPath<Integer> nbSkippedVisibleSteps = this.createNumber("nbSkippedVisibleSteps", Integer.class);

        public QArtifactWorkflowStepsCount(String variable) {
            super(QArtifactWorkflowStepsCount.class, PathMetadataFactory.forVariable((String)variable), "public", queryName);
            this.addMetadata();
        }

        public void addMetadata() {
            int index = 1;
            this.addMetadata((Path)this.artifactId, ColumnMetadata.named((String)"artifact_id").withIndex(index++).ofType(12).withSize(Integer.MAX_VALUE));
            this.addMetadata((Path)this.workflowProgress, ColumnMetadata.named((String)"workflow_progress").withIndex(index++).ofType(8).withSize(19));
            this.addMetadata((Path)this.nbInvisibleSteps, ColumnMetadata.named((String)"nb_invisible_steps").withIndex(index++).ofType(-5).withSize(19));
            this.addMetadata((Path)this.nbVisibleSteps, ColumnMetadata.named((String)"nb_visible_steps").withIndex(index++).ofType(-5).withSize(19));
            this.addMetadata((Path)this.nbNotStartedVisibleSteps, ColumnMetadata.named((String)"nb_not_started_visible_steps").withIndex(index++).ofType(-5).withSize(19));
            this.addMetadata((Path)this.nbFinishedVisibleSteps, ColumnMetadata.named((String)"nb_finished_visible_steps").withIndex(index++).ofType(-5).withSize(19));
            this.addMetadata((Path)this.nbSkippedVisibleSteps, ColumnMetadata.named((String)"nb_skipped_visible_steps").withIndex(index++).ofType(-5).withSize(19));
        }

        public SQLQuery<Tuple> getArtifactWorkflowStepsCountQuery() {
            SimpleExpression workflowProgressColumnCaseExpression = (SimpleExpression)Expressions.cases().when((Predicate)QueryBuilderUtils.jsonArrayLength((Expression<Object>)this.getArtifactWorkflowStepWithStateExpression(true, ArtifactWorkflowStep.StepStatus.ONGOING)).eq(QueryBuilderUtils.unsafeInQueryConstant(0))).then(QBlueprintVersionsStepsIndices.blueprintVersionsStepsIndices.stepIndex.max().castToNum(Double.class).add(QueryBuilderUtils.unsafeInQueryConstant(0.5))).otherwise((Expression)QBlueprintVersionsStepsIndices.blueprintVersionsStepsIndices.stepIndex.max().castToNum(Double.class));
            SQLQuery workflowProgressColumnExpression = (SQLQuery)((SQLQuery)SQLExpressions.select((Expression)workflowProgressColumnCaseExpression).from((Expression)QBlueprintVersionsStepsIndices.blueprintVersionsStepsIndices)).where(new Predicate[]{QBlueprintVersionsStepsIndices.blueprintVersionsStepsIndices.blueprintVersionBlueprintId.eq((Expression)QArtifacts.artifacts.artifactBlueprintId), QBlueprintVersionsStepsIndices.blueprintVersionsStepsIndices.blueprintVersionVersionId.eq((Expression)QArtifacts.artifacts.artifactVersionId), QBlueprintVersionsStepsIndices.blueprintVersionsStepsIndices.stepId.in((SubQueryExpression)SQLExpressions.select(QueryBuilderUtils.jsonArrayElementsText((Expression<Object>)QueryBuilderUtils.jsonPathQueryArray(QueryBuilderUtils.coalesceTo(QueryBuilderUtils.nullIfJsonbEmptyArray(this.getArtifactWorkflowStepWithStateExpression(true, ArtifactWorkflowStep.StepStatus.ONGOING)), this.getArtifactWorkflowStepWithStateExpression(true, ArtifactWorkflowStep.StepStatus.FINISHED)), "$.key"))))});
            return (SQLQuery)SQLExpressions.select((Expression[])new Expression[]{QArtifacts.artifacts.artifactId.as(ColumnMetadata.getName((Path)this.artifactId)), workflowProgressColumnExpression.as(ColumnMetadata.getName(this.workflowProgress)), QueryBuilderUtils.jsonArrayLength((Expression<Object>)this.getArtifactWorkflowStepWithStateExpression(false, null)).as(ColumnMetadata.getName(this.nbInvisibleSteps)), QueryBuilderUtils.jsonArrayLength((Expression<Object>)this.getArtifactWorkflowStepWithStateExpression(true, null)).as(ColumnMetadata.getName(this.nbVisibleSteps)), QueryBuilderUtils.jsonArrayLength((Expression<Object>)this.getArtifactWorkflowStepWithStateExpression(true, ArtifactWorkflowStep.StepStatus.NOT_STARTED)).as(ColumnMetadata.getName(this.nbNotStartedVisibleSteps)), QueryBuilderUtils.jsonArrayLength((Expression<Object>)this.getArtifactWorkflowStepWithStateExpression(true, ArtifactWorkflowStep.StepStatus.FINISHED)).as(ColumnMetadata.getName(this.nbFinishedVisibleSteps)), QueryBuilderUtils.jsonArrayLength((Expression<Object>)this.getArtifactWorkflowStepWithStateExpression(true, ArtifactWorkflowStep.StepStatus.SKIPPED)).as(ColumnMetadata.getName(this.nbSkippedVisibleSteps))}).from((Expression)QArtifacts.artifacts);
        }

        private SimpleExpression getArtifactWorkflowStepWithStateExpression(boolean visible, @Nullable ArtifactWorkflowStep.StepStatus stepStatus) {
            SimpleTemplate<Object> stepsPath = QueryBuilderUtils.jsonObjectDefaultEmpty(QArtifacts.artifacts.artifactJson, new String[]{"workflow", "steps"});
            String visibleCondition = "@.value.visible == " + visible;
            String stepCondition = stepStatus != null ? String.format("@.value.status == \"%s\"", new Object[]{stepStatus}) : null;
            String conditions = Stream.of(visibleCondition, stepCondition).filter(Objects::nonNull).collect(Collectors.joining(" && "));
            String jsonPath = "$.keyvalue()[*] ? (" + conditions + ")";
            return QueryBuilderUtils.jsonPathQueryArray(stepsPath, jsonPath);
        }
    }
}

