/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.monitoring;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.storage.monitoring.IMonitoringDAO;
import com.dataiku.gh.core.storage.sql.AbstractPostgreSQLClient;
import com.dataiku.gh.core.storage.sql.Constants;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.Wildcard;
import com.querydsl.sql.SQLQuery;
import java.util.HashMap;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Repository;

@Repository
public class MonitoringDAO
extends AbstractPostgreSQLClient
implements IMonitoringDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.monitoring");

    @Override
    @GHMandatoryTransaction
    public String getPostgresVersion() throws DataStoreIOException {
        try {
            return (String)this.querydslJdbcTemplate.queryForObject("SELECT version();", String.class);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    @GHMandatoryTransaction
    public Map<String, Long> getTableCounts() throws DataStoreIOException {
        try {
            HashMap<String, Long> counts = new HashMap<String, Long>();
            for (Constants.DBTableWithColumnInfo tableInfo : Constants.ALL_DB_TABLES) {
                SQLQuery sqlQuery = (SQLQuery)this.sqlQueryFactory.select((Expression)Wildcard.count.as("count")).from(tableInfo.table);
                Long count = this.querydslJdbcTemplate.queryForObject(sqlQuery, Long.class);
                counts.put(tableInfo.table.getTableName(), count);
            }
            return counts;
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }
}

