/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.security.mappings;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.models.history.RevisionType;
import com.dataiku.gh.core.models.security.mappings.GlobalAPIKeyMapping;
import com.dataiku.gh.core.services.history.IHistoryDataService;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.storage.security.mappings.IGlobalAPIKeyMappingDAO;
import com.dataiku.gh.core.storage.sql.AbstractPostgreSQLClient;
import com.dataiku.gh.core.storage.sql.model.QGlobalApiKeyMappings;
import com.dataiku.gh.core.storage.sql.model.QGlobalApiKeyMappingsHistory;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Repository;

@Repository
public class GlobalAPIKeyMappingDAO
extends AbstractPostgreSQLClient
implements IGlobalAPIKeyMappingDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.global-api-key-mapping");
    @Autowired
    protected IHistoryDataService historyDataService;

    @Override
    @GHMandatoryTransaction
    public List<GlobalAPIKeyMapping> listAllGlobalAPIKeyMappings() throws IOException {
        return this.listGlobalAPIKeyMappingsInternal(true, Collections.emptyList());
    }

    @Override
    @GHMandatoryTransaction
    public List<GlobalAPIKeyMapping> listGlobalAPIKeyMappings(Collection<String> globalApiKeyIds) throws IOException {
        return this.listGlobalAPIKeyMappingsInternal(false, globalApiKeyIds);
    }

    private List<GlobalAPIKeyMapping> listGlobalAPIKeyMappingsInternal(boolean listAll, Collection<String> globalApiKeyIds) throws IOException {
        if (!listAll && CollectionUtils.isEmpty(globalApiKeyIds)) {
            return Collections.emptyList();
        }
        SQLQuery query = (SQLQuery)this.sqlQueryFactory.select(QGlobalApiKeyMappings.globalApiKeyMappings.globalApiKeyMappingJson).from((Expression)QGlobalApiKeyMappings.globalApiKeyMappings);
        if (!listAll) {
            query = (SQLQuery)query.where((Predicate)QGlobalApiKeyMappings.globalApiKeyMappings.globalApiKeyMappingApiKeyId.in(globalApiKeyIds));
        }
        try {
            return this.querydslJdbcTemplate.query(query, (rs, rowNum) -> (GlobalAPIKeyMapping)JSON.parse((String)rs.getString(ColumnMetadata.getName(QGlobalApiKeyMappings.globalApiKeyMappings.globalApiKeyMappingJson)), GlobalAPIKeyMapping.class));
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    @GHMandatoryTransaction
    public void createGlobalAPIKeyMappings(Collection<GlobalAPIKeyMapping> globalAPIKeyMappings) throws IOException {
        if (CollectionUtils.isEmpty(globalAPIKeyMappings)) {
            return;
        }
        try {
            SQLInsertClause insert = this.sqlQueryFactory.insert((RelationalPath)QGlobalApiKeyMappings.globalApiKeyMappings);
            for (GlobalAPIKeyMapping globalAPIKeyMapping : globalAPIKeyMappings) {
                ((SQLInsertClause)insert.set(QGlobalApiKeyMappings.globalApiKeyMappings.globalApiKeyMappingJson, QueryBuilderUtils.toJsonb(globalAPIKeyMapping))).addBatch();
            }
            this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)insert);
            this.insertHistoryRevisions(RevisionType.ADD, globalAPIKeyMappings);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    @GHMandatoryTransaction
    public void deleteGlobalAPIKeyMappings(Collection<GlobalAPIKeyMapping> globalAPIKeyMappings) throws IOException {
        if (CollectionUtils.isEmpty(globalAPIKeyMappings)) {
            return;
        }
        try {
            this.insertHistoryRevisions(RevisionType.DELETE, globalAPIKeyMappings);
            SQLDeleteClause delete = this.sqlQueryFactory.delete((RelationalPath)QGlobalApiKeyMappings.globalApiKeyMappings);
            for (GlobalAPIKeyMapping globalAPIKeyMapping : globalAPIKeyMappings) {
                ((SQLDeleteClause)delete.where((Predicate)QGlobalApiKeyMappings.globalApiKeyMappings.globalApiKeyMappingArtifactId.eq((Object)globalAPIKeyMapping.artifactId).and((Predicate)QGlobalApiKeyMappings.globalApiKeyMappings.globalApiKeyMappingApiKeyId.eq((Object)globalAPIKeyMapping.apiKeyId)))).addBatch();
            }
            this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)delete);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    private void insertHistoryRevisions(RevisionType revisionType, Collection<GlobalAPIKeyMapping> globalAPIKeyMappings) throws IOException {
        SQLInsertClause insertHistory = this.sqlQueryFactory.insert((RelationalPath)QGlobalApiKeyMappingsHistory.globalApiKeyMappingsHistory);
        for (GlobalAPIKeyMapping globalAPIKeyMapping : globalAPIKeyMappings) {
            HistoryRevision historyRevision = this.historyDataService.createRevision(revisionType, EntityType.GLOBAL_API_KEY_MAPPING);
            ((SQLInsertClause)((SQLInsertClause)insertHistory.set(QGlobalApiKeyMappingsHistory.globalApiKeyMappingsHistory._revisionJson, QueryBuilderUtils.toJsonb(historyRevision))).set(QGlobalApiKeyMappingsHistory.globalApiKeyMappingsHistory.globalApiKeyMappingJson, QueryBuilderUtils.toJsonb(globalAPIKeyMapping))).addBatch();
        }
        this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)insertHistory);
    }
}

